/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.worldedit;

import com.q3hardcore.xcommands.core.PlayerHelper;
import com.q3hardcore.xcommands.core.PluginManager;
import com.q3hardcore.xcommands.proxy.EnumSide;
import com.q3hardcore.xcommands.proxy.Proxy;
import com.q3hardcore.xcommands.worldedit.XCommandsLocalWorld;
import com.q3hardcore.xcommands.wrapper.WItemStack;
import com.q3hardcore.xcommands.wrapper.WMovingObjectPosition;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.cui.CUIEvent;

public final class XCommandsLocalPlayer
extends LocalPlayer {
    public WPlayer player;
    public int blockrightx;
    public int blockrighty;
    public int blockrightz;
    public int blockleftx;
    public int blocklefty;
    public int blockleftz;
    public boolean hide = false;

    public XCommandsLocalPlayer(ServerInterface serverInterface, WPlayer wPlayer) {
        super(serverInterface);
        this.player = wPlayer;
    }

    public String[] getGroups() {
        return new String[0];
    }

    public BlockBag getInventoryBlockBag() {
        return null;
    }

    public int getItemInHand() {
        WItemStack wItemStack = this.player.getCurrentItem();
        return wItemStack == null ? 0 : wItemStack.getItemID();
    }

    public String getName() {
        return this.player.getUsername();
    }

    public double getPitch() {
        return this.player.getPitch();
    }

    public WorldVector getPosition() {
        return new WorldVector(this.getWorld(), this.player.getPosX(), this.player.getPosY() - 1.0, this.player.getPosZ());
    }

    public LocalWorld getWorld() {
        return new XCommandsLocalWorld(this.player.getWorld());
    }

    public double getYaw() {
        return this.player.getYaw();
    }

    public void giveItem(int n2, int n3) {
        WItemStack wItemStack = WItemStack.instantiate(n2, n3, 0);
        this.player.addItemStackToInventory(wItemStack);
    }

    public boolean hasPermission(String string) {
        return true;
    }

    public void print(String string) {
        if (string.contains("position set to") && this.hide) {
            return;
        }
        this.player.sendMessage(string);
    }

    public void printError(String string) {
        this.player.sendError(string);
    }

    public void printRaw(String string) {
        this.player.sendMessage2(string);
    }

    public void printDebug(String string) {
        this.player.getPlayerHelper().sendDebug(string);
    }

    public void setPosition(Vector vector, float f2, float f3) {
        this.player.setRotation(f3, f2);
        this.player.setPositionAndUpdate(vector.getX(), vector.getY(), vector.getZ());
    }

    public WorldVector getBlockTrace(int n2) {
        WMovingObjectPosition wMovingObjectPosition = this.player.rayTrace(n2, 1.0f);
        return new WorldVector(this.getWorld(), wMovingObjectPosition.blockx, wMovingObjectPosition.blocky, wMovingObjectPosition.blockz);
    }

    public WorldVector getSolidBlockTrace(int n2) {
        return this.getBlockTrace(n2);
    }

    public void dispatchCUIEvent(CUIEvent cUIEvent) {
        if (Proxy.INSTANCE.getSide() == EnumSide.SERVER) {
            return;
        }
        try {
            PluginManager.getPluginManager().callPluginMethods(PlayerHelper.PLUGIN_HANDLECUIEVENT, cUIEvent.getTypeId(), cUIEvent.getParameters());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

