/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.waypoint;

import com.q3hardcore.xcommands.util.Settings;
import com.q3hardcore.xcommands.waypoint.Waypoint;
import com.q3hardcore.xcommands.waypoint.WaypointException;
import com.q3hardcore.xcommands.wrapper.Coordinate;
import com.q3hardcore.xcommands.wrapper.WWorld;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class WaypointHelper {
    public static boolean addWaypoint(File file, Waypoint waypoint) {
        Settings settings = new Settings(file);
        boolean bl2 = WaypointHelper.hasWaypoint(file, waypoint.getName());
        settings.set(waypoint.getName(), waypoint.toString());
        settings.save("Waypoints");
        return bl2;
    }

    public static void removeWaypoint(File file, String string) {
        Settings settings = new Settings(file);
        settings.remove(string);
        settings.save("Waypoints");
    }

    public static Waypoint getWaypoint(File file, String string) throws WaypointException {
        Settings settings = new Settings(file);
        return WaypointHelper.resolveWaypoint(string, settings.getString(string, "INVALID WAYPOINT"));
    }

    public static boolean hasWaypoint(File file, String string) {
        Settings settings = new Settings(file);
        boolean bl2 = true;
        if (settings.getString(string, "INVALID WAYPOINT").equals("INVALID WAYPOINT")) {
            bl2 = false;
        }
        return bl2;
    }

    public static List resolveWaypoints(File file) {
        Settings settings = new Settings(file);
        ArrayList<Waypoint> arrayList = new ArrayList<Waypoint>();
        for (String string : settings.stringPropertyNames()) {
            String string2 = settings.getString(string, "INVALID WAYPOINT");
            try {
                arrayList.add(WaypointHelper.resolveWaypoint(string, string2));
            }
            catch (WaypointException waypointException) {
                System.out.println("Waypoint " + string + " is invalid.");
            }
        }
        return arrayList;
    }

    private static Waypoint resolveWaypoint(String string, String string2) throws WaypointException {
        int n2;
        int n3;
        int n4;
        int n5;
        if (string2.equals("INVALID WAYPOINT")) {
            System.out.println("Waypoint " + string + " has no data.");
            throw new WaypointException();
        }
        String[] stringArray = string2.split(",");
        if (stringArray.length != 5) {
            throw new WaypointException();
        }
        String string3 = stringArray[0];
        try {
            n5 = Integer.valueOf(stringArray[1]);
            n4 = Integer.valueOf(stringArray[2]);
            n3 = Integer.valueOf(stringArray[3]);
            n2 = Integer.valueOf(stringArray[4]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new WaypointException();
        }
        return new Waypoint(string, string3, new Coordinate(n5, n4, n3), n2);
    }

    public static File getWaypointFile(WWorld wWorld) {
        return new File(wWorld.getWorldDir(), "/waypoints.txt");
    }
}

