/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public final class Settings
extends Properties {
    private static final long serialVersionUID = -4103955526034147832L;
    private File settings;

    public Settings() {
    }

    public Settings(File file) {
        this(file, true);
    }

    public Settings(File file, boolean bl2) {
        this.settings = file;
        if (bl2) {
            this.load(file);
        }
    }

    public void set(String string, boolean bl2) {
        this.setProperty(string, new Boolean(bl2).toString());
    }

    public boolean getBoolean(String string, boolean bl2) {
        String string2 = this.getProperty(string);
        try {
            return string2 != null && !string2.trim().equalsIgnoreCase("") ? new Boolean(string2) : bl2;
        }
        catch (Exception exception) {
            return bl2;
        }
    }

    public void set(String string, int n2) {
        this.setProperty(string, new Integer(n2).toString());
    }

    public int getInteger(String string, int n2) {
        String string2 = this.getProperty(string);
        try {
            return this.isEmpty(string2) ? n2 : new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public void set(String string, char c2) {
        this.setProperty(string, new Character(c2).toString());
    }

    public char getCharacter(String string, char c2) {
        String string2 = this.getProperty(string);
        try {
            return this.isEmpty(string2) ? c2 : string2.charAt(0);
        }
        catch (NumberFormatException numberFormatException) {
            return c2;
        }
    }

    public void set(String string, double d2) {
        this.setProperty(string, new Double(d2).toString());
    }

    public double getDouble(String string, double d2) {
        String string2 = this.getProperty(string);
        try {
            return this.isEmpty(string2) ? d2 : new Double(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return d2;
        }
    }

    public void set(String string, float f2) {
        this.setProperty(string, new Float(f2).toString());
    }

    public float getFloat(String string, float f2) {
        String string2 = this.getProperty(string);
        try {
            return this.isEmpty(string2) ? f2 : new Float(string2).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return f2;
        }
    }

    public void set(String string, String string2) {
        this.setProperty(string, string2);
    }

    public String getString(String string, String string2) {
        String string3 = this.getProperty(string);
        return this.isEmpty(string3) ? string2 : string3;
    }

    public boolean save() {
        return this.save("");
    }

    public boolean save(String string) {
        return this.save(this.settings, string);
    }

    public boolean save(File file, String string) {
        if (file != null && !file.isDirectory()) {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                super.store(fileOutputStream, string);
                fileOutputStream.close();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public boolean load() {
        return this.load(this.settings);
    }

    public boolean load(File file) {
        if (file != null && !file.isDirectory()) {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                    return true;
                }
                super.load(new FileInputStream(file));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public File getFile() {
        return this.settings;
    }

    public void setFile(File file) {
        this.settings = file;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().equalsIgnoreCase("");
    }
}

