/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.plugin;

import com.q3hardcore.xcommands.core.Helper;
import com.q3hardcore.xcommands.plugin.Plugin;
import com.q3hardcore.xcommands.wrapper.WMathHelper;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import com.q3hardcore.xcommands.wrapper.WStructureBoundingBox;
import com.q3hardcore.xcommands.wrapper.WStructureComponent;
import com.q3hardcore.xcommands.wrapper.WStructureStart;
import com.q3hardcore.xcommands.wrapper.WWorld;
import com.q3hardcore.xcommands.wrapper.WWorldType;
import com.q3hardcore.xcommands.wrapper.lists.LComponentScatteredFeature;
import com.q3hardcore.xcommands.wrapper.lists.LStructureStarts;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class spc_structuregen
extends Plugin {
    private static final List structures = new ArrayList();

    @Override
    public String getName() {
        return "StructureGen";
    }

    @Override
    public List getCommands() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("structure");
        return arrayList;
    }

    @Override
    public String[] getHelp(String string) {
        if (string != null && string.equals("structure")) {
            String[] stringArray = new String[]{"Generates structures.", "<STRUCTURE|list>", "village"};
            return stringArray;
        }
        return null;
    }

    @Override
    public boolean handleCommand(WPlayer wPlayer, String[] stringArray) {
        WWorld wWorld = wPlayer.getWorld();
        if (stringArray != null && stringArray.length >= 1 && !stringArray[0].equalsIgnoreCase("structure")) {
            return false;
        }
        if (stringArray.length > 1) {
            WStructureStart wStructureStart;
            if (stringArray[1].equalsIgnoreCase("list")) {
                String string = stringArray.length > 2 ? stringArray[2] : "1";
                if (!Helper.printFormattedList(wPlayer, "Structures", structures, string, 26)) {
                    wPlayer.sendError("Invalid page number specified.");
                }
                return true;
            }
            int n2 = WMathHelper.floor_double(wPlayer.getPosX() / 16.0);
            int n3 = WMathHelper.floor_double(wPlayer.getPosZ() / 16.0);
            Random random = new Random(wWorld.getSeed());
            long l2 = random.nextLong() / 2L * 2L + 1L;
            long l3 = random.nextLong() / 2L * 2L + 1L;
            random.setSeed((long)n2 * l2 + (long)n3 * l3 ^ wWorld.getSeed());
            boolean bl2 = false;
            boolean bl3 = wWorld.getWorldInfo().getTerrainType().equals(WWorldType.FLAT);
            boolean bl4 = false;
            if (stringArray.length > 2) {
                if (stringArray[2].equalsIgnoreCase("forceflat")) {
                    bl3 = true;
                } else if (stringArray[2].equalsIgnoreCase("forcenormal")) {
                    bl3 = false;
                } else if (stringArray[2].equalsIgnoreCase("forcemin")) {
                    bl4 = true;
                }
            }
            if (stringArray[1].equalsIgnoreCase("mineshaft")) {
                wStructureStart = new LStructureStarts.Mineshaft(wWorld, random, n2, n3);
            } else if (stringArray[1].equalsIgnoreCase("netherbridge")) {
                wStructureStart = new LStructureStarts.NetherBridge(wWorld, random, n2, n3);
            } else if (stringArray[1].equalsIgnoreCase("biomefeature")) {
                wStructureStart = new LStructureStarts.BiomeFeature(wWorld, random, n2, n3);
            } else if (stringArray[1].equalsIgnoreCase("pyramid")) {
                wStructureStart = new LStructureStarts.BiomeFeature(wWorld, random, n2, n3);
                LComponentScatteredFeature.DesertPyramid desertPyramid = new LComponentScatteredFeature.DesertPyramid(random, n2 * 16, n3 * 16);
                spc_structuregen.setStructureComponent(wStructureStart, desertPyramid);
            } else if (stringArray[1].equalsIgnoreCase("temple")) {
                wStructureStart = new LStructureStarts.BiomeFeature(wWorld, random, n2, n3);
                LComponentScatteredFeature.JungleTemple jungleTemple = new LComponentScatteredFeature.JungleTemple(random, n2 * 16, n3 * 16);
                spc_structuregen.setStructureComponent(wStructureStart, jungleTemple);
            } else if (stringArray[1].equalsIgnoreCase("hut")) {
                wStructureStart = new LStructureStarts.BiomeFeature(wWorld, random, n2, n3);
                LComponentScatteredFeature.SwampHut swampHut = new LComponentScatteredFeature.SwampHut(random, n2 * 16, n3 * 16);
                spc_structuregen.setStructureComponent(wStructureStart, swampHut);
            } else if (stringArray[1].equalsIgnoreCase("stronghold")) {
                wStructureStart = new LStructureStarts.Stronghold(wWorld, random, n2, n3);
            } else if (stringArray[1].equalsIgnoreCase("village")) {
                int n4 = 0;
                if (bl3) {
                    n4 = 1;
                } else {
                    bl2 = true;
                }
                wStructureStart = new LStructureStarts.Village(wWorld, random, n2, n3, n4);
            } else {
                wPlayer.sendError("Invalid structure specified.");
                return true;
            }
            wPlayer.sendMessage(wPlayer.getPrettyPos());
            if (!wStructureStart.isValid()) {
                wPlayer.sendError("Structure could not be initialized.");
                return true;
            }
            WStructureBoundingBox wStructureBoundingBox = wStructureStart.getBoundingBox();
            if (!wStructureBoundingBox.isValid()) {
                wPlayer.sendError("Structure has no components.");
                return true;
            }
            if (bl3) {
                int n5 = wStructureBoundingBox.getMinY();
                wStructureBoundingBox.setMinY(wWorld.getTopSolidOrLiquidBlock(WMathHelper.floor_double(wPlayer.getPosX()), WMathHelper.floor_double(wPlayer.getPosZ())));
                wPlayer.sendMessage("Adjusted settings for flat world type.");
                if (wStructureBoundingBox.getMaxY() - wStructureBoundingBox.getMinY() < 10) {
                    wStructureBoundingBox.setMaxY(wStructureBoundingBox.getMinY() + (wStructureBoundingBox.getMaxY() - n5));
                    wPlayer.sendMessage("Expanding bounding box.");
                }
            }
            if (bl2) {
                wStructureBoundingBox.setMinY(wStructureBoundingBox.getMinY() - 1);
                if (wStructureBoundingBox.getMinX() == wStructureBoundingBox.getMaxX() - 5 && wStructureBoundingBox.getMinY() == wStructureBoundingBox.getMaxY() - 15 && wStructureBoundingBox.getMinZ() == wStructureBoundingBox.getMaxZ() - 5) {
                    wPlayer.sendError("Terrain unsuitable for village generation.");
                    return true;
                }
                int n6 = wStructureBoundingBox.getMaxY() - wStructureBoundingBox.getMinY();
                if (n6 >= 16 && wStructureBoundingBox.getMaxY() < 127) {
                    wPlayer.sendMessage("Expanding bounding box.");
                    wStructureBoundingBox.setMaxY(127);
                }
            }
            if (bl4) {
                wStructureBoundingBox.setMinY(1);
            }
            wPlayer.sendMessage("Generating structure.");
            try {
                wPlayer.sendMessage("Structure bounding box (min): " + wStructureBoundingBox.getMinX() + ", " + wStructureBoundingBox.getMinY() + ", " + wStructureBoundingBox.getMinZ());
                wPlayer.sendMessage("Structure bounding box (max): " + wStructureBoundingBox.getMaxX() + ", " + wStructureBoundingBox.getMaxY() + ", " + wStructureBoundingBox.getMaxZ());
                wStructureStart.generateStructure(wWorld, random, wStructureBoundingBox);
            }
            catch (Throwable throwable) {
                wPlayer.sendMessage("Structure generation failed.\n" + throwable.toString());
            }
        } else {
            wPlayer.sendError("Structure not specified.");
        }
        return true;
    }

    private static void setStructureComponent(WStructureStart wStructureStart, WStructureComponent wStructureComponent) {
        wStructureStart.clearComponents();
        wStructureStart.addComponent(wStructureComponent);
        wStructureStart.updateBoundingBox();
    }

    static {
        structures.add("biomefeature");
        structures.add("hut");
        structures.add("mineshaft");
        structures.add("netherbridge");
        structures.add("pyramid");
        structures.add("stronghold");
        structures.add("temple");
        structures.add("village");
    }
}

