/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.plugin;

import com.q3hardcore.xcommands.client.console.GuiConsole;
import com.q3hardcore.xcommands.client.util.KeyListener;
import com.q3hardcore.xcommands.client.wrapper.WMinecraft;
import com.q3hardcore.xcommands.core.Helper;
import com.q3hardcore.xcommands.plugin.Plugin;
import com.q3hardcore.xcommands.plugin.spc_kbhandler;
import com.q3hardcore.xcommands.proxy.EnumSide;
import com.q3hardcore.xcommands.proxy.Side;
import com.q3hardcore.xcommands.util.FontColour;
import com.q3hardcore.xcommands.util.Settings;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.input.Keyboard;

@Side(value=EnumSide.CLIENT)
public class spc_bind
extends Plugin
implements KeyListener {
    private static Settings BINDINGS = new Settings(new File(Helper.getModDir(), "bindings.properties"));
    private static final String[] BIND_PARAMS = new String[]{"Binds key", "[key] [command]", "g /c /god"};
    private static final String[] BINDID_PARAMS = new String[]{"Binds key", "[keyid] [command]", "g /c /god"};
    private static final String[] UNBIND_PARAMS = new String[]{"Unbinds key", "[key]", "g"};
    private static final String[] LISTBINDINGS_PARAMS = new String[]{"Displays current key bindings", "", ""};
    private boolean autobind;
    private boolean initialized = false;
    private static final List reservedKeys = new ArrayList();

    public spc_bind() {
        this.setTicking(true);
        this.setOwnerExclusive(true);
    }

    @Override
    public String getName() {
        return "Bind";
    }

    @Override
    public List getCommands() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("autobind");
        arrayList.add("bind");
        arrayList.add("unbind");
        arrayList.add("bindid");
        arrayList.add("unbindid");
        arrayList.add("listbindings");
        return arrayList;
    }

    @Override
    public void atUpdate(WPlayer wPlayer) {
        if (spc_kbhandler.getInstance() != null) {
            this.initialized = true;
            this.addKeyListeners();
            if (BINDINGS.getString("41", "0").equals("0") && this.autobind) {
                wPlayer.sendMessage("XCommands GUI can be opened by pressing '~'.");
                this.bind(41);
                BINDINGS.set("41", "/showchat");
                BINDINGS.save();
            }
            this.setTicking(false);
        }
    }

    @Override
    public boolean handleCommand(WPlayer wPlayer, String[] stringArray) {
        if (this.getCommands().contains(stringArray[0]) && !wPlayer.isPlayerOwner()) {
            wPlayer.sendError(Helper.ERRMSG_NOTOWNER);
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("bind") || stringArray[0].equalsIgnoreCase("bindid")) {
            int n2;
            String string;
            if (stringArray.length < 3) {
                wPlayer.sendError("Must specify key and command.");
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("bind")) {
                string = stringArray[1];
                n2 = Keyboard.getKeyIndex((String)string.toUpperCase());
            } else {
                try {
                    n2 = Integer.parseInt(stringArray[1]);
                    Keyboard.getKeyName((int)n2);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n2 = 0;
                }
            }
            String string2 = Keyboard.getKeyName((int)n2);
            if (n2 == 0) {
                wPlayer.sendError("Unknown keycode " + stringArray[1]);
                return true;
            }
            string = "";
            for (int i2 = 2; i2 < stringArray.length; ++i2) {
                string = string + stringArray[i2] + " ";
            }
            string = string.trim();
            if (BINDINGS.get(n2 + "") != null && BINDINGS.get(n2 + "").equals(string)) {
                wPlayer.sendError("Key is already bound to specified command.");
                return true;
            }
            if (string.equals("/showchat")) {
                if (reservedKeys.contains(n2)) {
                    wPlayer.sendError("Cannot bind selected key. (Reserved for XCommands GUI)");
                    return true;
                }
                if (n2 != 41) {
                    wPlayer.sendMessage("You can now use " + string2 + " to open XCommands GUI.");
                }
            }
            if (BINDINGS.get(n2 + "") == null) {
                this.bind(n2);
            }
            BINDINGS.set(n2 + "", string.trim());
            BINDINGS.save();
            wPlayer.sendMessage2("Key " + (Object)((Object)FontColour.AQUA) + stringArray[1] + (Object)((Object)FontColour.WHITE) + " was successfully bound.");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("unbind") || stringArray[0].equalsIgnoreCase("unbindid")) {
            if (stringArray.length < 2) {
                wPlayer.sendError("Must specify key.");
                return true;
            }
            int n3 = 0;
            if (stringArray[0].equalsIgnoreCase("unbind")) {
                String string = stringArray[1];
                if (string.equalsIgnoreCase("all")) {
                    BINDINGS.clear();
                    BINDINGS.save();
                    wPlayer.sendMessage("All bindings removed.");
                    return true;
                }
                n3 = Keyboard.getKeyIndex((String)string.toUpperCase());
            } else {
                try {
                    n3 = Integer.parseInt(stringArray[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n3 == 0) {
                wPlayer.sendError("Unknown keycode " + stringArray[1]);
                return true;
            }
            this.unbind(n3);
            if (BINDINGS.remove(n3 + "") == null) {
                wPlayer.sendError("No binding was found for key " + (Object)((Object)FontColour.AQUA) + stringArray[1]);
                return true;
            }
            BINDINGS.save();
            wPlayer.sendMessage2("Binding " + (Object)((Object)FontColour.AQUA) + stringArray[1] + (Object)((Object)FontColour.WHITE) + " was successfully removed.");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("autobind")) {
            boolean bl2 = BINDINGS.getBoolean("autobind", true);
            this.autobind = bl2 ^ true;
            BINDINGS.set("autobind", this.autobind);
            BINDINGS.save();
            wPlayer.sendMessage("Autobinding " + (this.autobind ? "enabled." : "disabled."));
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("listbindings")) {
            if (BINDINGS.keySet().isEmpty()) {
                wPlayer.sendError("No bindings.");
                return true;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object : BINDINGS.keySet()) {
                String string;
                try {
                    int n4 = Integer.parseInt(object.toString());
                    string = Keyboard.getKeyName((int)n4);
                }
                catch (NumberFormatException numberFormatException) {
                    string = object.toString();
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    wPlayer.sendError("Key binding " + object.toString() + " invalid.");
                    continue;
                }
                arrayList.add(string + ": " + BINDINGS.get(object));
            }
            Collections.sort(arrayList);
            String string = stringArray.length > 1 ? stringArray[1] : "1";
            if (!Helper.printFormattedList(wPlayer, "Key Bindings", arrayList, string, 28)) {
                wPlayer.sendError("Invalid page number specified.");
            }
            return true;
        }
        return false;
    }

    @Override
    public String[] getHelp(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("bind")) {
            return BIND_PARAMS;
        }
        if (string.equalsIgnoreCase("unbind")) {
            return UNBIND_PARAMS;
        }
        if (string.equalsIgnoreCase("bindid")) {
            return BINDID_PARAMS;
        }
        if (string.equalsIgnoreCase("listbindings")) {
            return LISTBINDINGS_PARAMS;
        }
        return null;
    }

    private void addKeyListeners() {
        Iterator<Object> iterator = BINDINGS.keySet().iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            try {
                String string = (String)object;
                if (string.equals("autobind")) {
                    this.autobind = BINDINGS.getBoolean("autobind", true);
                    bl2 = true;
                    continue;
                }
                this.bind(Integer.parseInt(string));
            }
            catch (Exception exception) {
                System.err.println("Invalid key specified in bindings: " + object);
                BINDINGS.remove(object);
            }
        }
        if (!bl2) {
            this.autobind = true;
        }
    }

    private void bind(int n2) {
        if (!spc_kbhandler.getInstance().addKeyPressedListener(n2, this)) {
            System.err.println("Invalid key specified in bindings: " + n2);
            BINDINGS.remove(n2);
        }
    }

    private void unbind(int n2) {
        spc_kbhandler.getInstance().removeKeyPressedListener(n2, this);
    }

    @Override
    public void keyPressed(int n2) {
        WMinecraft wMinecraft = WMinecraft.getMinecraft();
        String string = BINDINGS.getString(n2 + "", "");
        if (wMinecraft != null && wMinecraft.getCurrentScreen() != null) {
            return;
        }
        if (string.equals("/showchat")) {
            GuiConsole guiConsole = new GuiConsole(n2);
            guiConsole.setWorldAndResolution(wMinecraft, -1, -1);
            guiConsole.clearChat();
            wMinecraft.displayGuiScreen(guiConsole);
            return;
        }
        if (string.startsWith("!")) {
            string = string.substring(1);
        } else if (string.startsWith("/")) {
            string = "/c " + string;
        }
        if (string.equals("")) {
            return;
        }
        WMinecraft.getMinecraft().sendChatMessage(string);
    }

    @Override
    public void keyReleased(int n2) {
    }

    static {
        reservedKeys.add(1);
        reservedKeys.add(14);
        reservedKeys.add(28);
        reservedKeys.add(29);
        reservedKeys.add(30);
        reservedKeys.add(35);
        reservedKeys.add(45);
        reservedKeys.add(46);
        reservedKeys.add(47);
        reservedKeys.add(200);
        reservedKeys.add(208);
    }
}

