/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.core;

import com.q3hardcore.xcommands.core.Helper;
import com.q3hardcore.xcommands.core.PlayerHelper;
import com.q3hardcore.xcommands.plugin.Plugin;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PluginCommands {
    public static boolean processCommand(WPlayer wPlayer, String[] stringArray) {
        if (stringArray[0].equalsIgnoreCase("phelp")) {
            wPlayer.sendError("This command is unavailable, use /c /help instead.");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("plugin")) {
            if (stringArray.length < 2) {
                wPlayer.sendError("Not enough parameters.");
                return true;
            }
            if (stringArray[1].equalsIgnoreCase("version")) {
                if (stringArray.length >= 3) {
                    String string = stringArray[2];
                    for (int i2 = 3; i2 < stringArray.length; ++i2) {
                        string = string + " " + stringArray[i2];
                    }
                    Plugin[] pluginArray = PlayerHelper.PLUGIN_MANAGER.getPlugin(string);
                    if (pluginArray.length == 0) {
                        wPlayer.sendError("No such plugin.");
                        return true;
                    }
                    for (int i3 = 0; i3 < pluginArray.length; ++i3) {
                        wPlayer.sendMessage(pluginArray[i3].getName() + " " + pluginArray[i3].getVersion());
                    }
                } else {
                    wPlayer.sendMessage("SPC Plugin Continuation");
                }
                return true;
            }
            if (stringArray[1].equalsIgnoreCase("list")) {
                List list = PlayerHelper.PLUGIN_MANAGER.getPlugins();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Plugin plugin : list) {
                    String string = plugin.getName();
                    String string2 = plugin.getVersion();
                    String string3 = plugin.getEnabled() ? "enabled" : "disabled";
                    arrayList.add(string + " v" + string2 + ": " + string3);
                }
                Collections.sort(arrayList);
                String string = stringArray.length > 2 ? stringArray[2] : "1";
                if (!Helper.printFormattedList(wPlayer, "Plugins", arrayList, string, 27)) {
                    wPlayer.sendError("Invalid page number specified.");
                }
                return true;
            }
            if (stringArray[1].equalsIgnoreCase("enable")) {
                if (stringArray.length < 3) {
                    if (!PlayerHelper.PLUGIN_MANAGER.getEnabled()) {
                        PlayerHelper.PLUGIN_MANAGER.setEnabled(true);
                        wPlayer.sendMessage("Plugin Manager enabled.");
                    } else {
                        wPlayer.sendError("Plugin Manager already enabled.");
                    }
                    return true;
                }
                String string = stringArray[2];
                Plugin[] pluginArray = PlayerHelper.PLUGIN_MANAGER.getPlugin(string);
                if (pluginArray.length == 0) {
                    wPlayer.sendError("Couldn't find specified plugin.");
                    return true;
                }
                for (Plugin plugin : pluginArray) {
                    if (!plugin.getEnabled()) {
                        plugin.setEnabled(true);
                        wPlayer.sendMessage("Enabled " + plugin.getName());
                        continue;
                    }
                    wPlayer.sendError(plugin.getName() + " is already enabled.");
                }
                return true;
            }
            if (stringArray[1].equalsIgnoreCase("disable")) {
                if (stringArray.length < 3) {
                    if (PlayerHelper.PLUGIN_MANAGER.getEnabled()) {
                        PlayerHelper.PLUGIN_MANAGER.setEnabled(false);
                        wPlayer.sendMessage("Plugin Manager disabled.");
                    } else {
                        wPlayer.sendError("Plugin Manager already disabled.");
                    }
                    return true;
                }
                String string = stringArray[2];
                Plugin[] pluginArray = PlayerHelper.PLUGIN_MANAGER.getPlugin(string);
                if (pluginArray.length == 0) {
                    wPlayer.sendError("Couldn't find specified plugin.");
                    return true;
                }
                for (Plugin plugin : pluginArray) {
                    if (plugin.getEnabled()) {
                        plugin.setEnabled(false);
                        wPlayer.sendMessage("Disabled " + plugin.getName());
                        continue;
                    }
                    wPlayer.sendError(plugin.getName() + " is already disabled.");
                }
                return true;
            }
            wPlayer.sendError("Unknown plugin command.");
            return true;
        }
        boolean bl2 = false;
        try {
            bl2 = PlayerHelper.PLUGIN_MANAGER.handlePluginCommand(wPlayer, stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            wPlayer.sendError("Unhandled exception caused by command " + stringArray[0]);
            bl2 = true;
        }
        return bl2;
    }
}

