/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.core;

import com.q3hardcore.xcommands.proxy.Proxy;
import com.q3hardcore.xcommands.util.FontColour;
import com.q3hardcore.xcommands.util.Settings;
import com.q3hardcore.xcommands.wrapper.NumberInvalidException;
import com.q3hardcore.xcommands.wrapper.TriState;
import com.q3hardcore.xcommands.wrapper.WMinecraftServer;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public final class Helper {
    public static final String colors = "0123456789abcdef";
    public static int normalColor = 15;
    public static int errorColor = 4;
    private static Settings colorSettings;
    private static Settings coreSettings;
    protected static boolean dropItems;
    public static boolean triedLoadingWorldEdit;
    private static TriState hasWorldEdit;
    public static String ERRMSG_PARAM;
    public static String ERRMSG_PARSE;
    public static String ERRMSG_NOTSET;
    public static String ERRMSG_OSNOTSUPPORTED;
    public static String ERRMSG_NPCNOTFOUND;
    public static String ERRMSG_NOTOWNER;
    private static boolean settingsLoaded;
    protected static boolean debug;

    public static WPlayer getOwner() {
        if (WMinecraftServer.getServer() == null) {
            return null;
        }
        String string = WMinecraftServer.getServer().getServerOwner();
        return WMinecraftServer.getServer().getConfigurationManager().getPlayerForUsername(string);
    }

    protected static File getWorldEditJar() {
        return new File(Helper.getModDir(), "jars/WorldEdit.jar");
    }

    protected static File getRhinoJar() {
        return new File(Helper.getModDir(), "jars/rhino.jar");
    }

    public static File getModDir() {
        return new File(Helper.getMinecraftDir(), "mods/xcommands");
    }

    public static File getMinecraftDir() {
        try {
            return Proxy.INSTANCE.getMinecraftDir();
        }
        catch (Throwable throwable) {
            System.out.println("XCommands: Unable to get Minecraft directory.");
            return new File(".");
        }
    }

    public static void helpMessage(WPlayer wPlayer, String string, String string2, String string3, String string4) {
        wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + "===Help===================");
        wPlayer.sendMessage2((Object)((Object)FontColour.WHITE) + "Help for the " + (Object)((Object)FontColour.AQUA) + string + (Object)((Object)FontColour.WHITE) + " command.");
        if (string2 != null) {
            wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + "Description: " + (Object)((Object)FontColour.WHITE) + string2);
        }
        if (string3 != null) {
            wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + "Syntax: " + (Object)((Object)FontColour.WHITE) + string3);
        }
        if (string4 != null) {
            wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + "Example: " + (Object)((Object)FontColour.WHITE) + string4);
        }
        wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + "==========================");
    }

    public static String getServerVersion() {
        try {
            return WMinecraftServer.getServer().getVersion();
        }
        catch (Exception exception) {
            return XCommandsHelper.getMinecraftVersion();
        }
    }

    protected static void loadSettings() {
        try {
            coreSettings = new Settings(new File(Helper.getModDir(), "settings.txt"));
            colorSettings = new Settings(new File(Helper.getModDir(), "colors.txt"));
            normalColor = colorSettings.getInteger("normalColor", 15);
            errorColor = colorSettings.getInteger("errorColor", 4);
            Helper.updateColorSettings();
            debug = coreSettings.getBoolean("debug", false);
            Helper.updateCoreSettings();
            settingsLoaded = true;
        }
        catch (Exception exception) {
            System.err.println("Couldn't load settings for XCommands.");
        }
    }

    private static boolean areSettingsLoaded() {
        return settingsLoaded;
    }

    public static void updateColorSettings() {
        if (colorSettings != null) {
            colorSettings.set("normalColor", normalColor);
            colorSettings.set("errorColor", errorColor);
            colorSettings.save("XCommands Color Settings");
        } else {
            System.out.println("No color settings found.");
        }
    }

    protected static void updateCoreSettings() {
        if (coreSettings != null) {
            coreSettings.set("debug", debug);
            coreSettings.save("XCommands Settings");
        } else {
            System.out.println("No core settings found.");
        }
    }

    public static boolean createDirs() {
        try {
            File file;
            if (!Helper.getModDir().exists()) {
                System.out.println("XCommands: Creating mods folder.");
                Helper.getModDir().mkdirs();
            }
            if (!(file = new File(Helper.getModDir(), "jars")).exists()) {
                file.mkdir();
                System.out.println("XCommands: Creating jars folder.");
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    protected static String convertInput(String string) {
        if (string == null) {
            return string;
        }
        String[] stringArray = string.split(" ");
        String string2 = stringArray[0];
        return (string2 + " " + Helper.join(stringArray, 1, stringArray.length)).trim();
    }

    public static String join(String[] stringArray, int n2, int n3) {
        String string = "";
        for (int i2 = n2; i2 < n3 || i2 < stringArray.length; ++i2) {
            string = string + stringArray[i2] + " ";
        }
        return string.trim();
    }

    public static boolean toggleItemDrops() {
        dropItems = !dropItems;
        boolean bl2 = dropItems;
        return bl2;
    }

    public static boolean extractFile(File file, String string, File file2) {
        try {
            JarFile jarFile = new JarFile(file);
            ZipEntry zipEntry = jarFile.getEntry(string);
            File file3 = new File(file2, zipEntry.getName());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(zipEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
            byte[] byArray = new byte[4096];
            while (true) {
                int n2;
                if ((n2 = bufferedInputStream.read(byArray)) <= 0) {
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                    bufferedInputStream.close();
                    return true;
                }
                bufferedOutputStream.write(byArray, 0, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static String getColor(int n2) {
        if (n2 >= 0 && n2 < colors.length()) {
            return "\u00a7" + colors.charAt(n2);
        }
        System.out.println("Invalid color index specified.");
        return "";
    }

    public static boolean tryLoadingWorldEdit(List list) {
        boolean bl2;
        Serializable serializable;
        if (!Helper.getWorldEditJar().exists()) {
            System.out.println("Attemping to locate WorldEdit.jar file.");
            serializable = Helper.class.getResource("/WorldEdit.jar");
            if (serializable != null && ((URL)serializable).toString().startsWith("jar:")) {
                String string = ((URL)serializable).toString();
                try {
                    URL uRL = new URL(string.substring(4, string.lastIndexOf("!")));
                    File file = new File(uRL.toURI());
                    boolean bl3 = Helper.extractFile(file, "WorldEdit.jar", new File(Helper.getModDir(), "jars/"));
                    if (bl3) {
                        System.out.println("Extracted WorldEdit.jar");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (!Helper.addToClasspath(Helper.getWorldEditJar()) && ((File)(serializable = new File(Helper.getMinecraftDir(), "/bin/WorldEdit.jar"))).exists() && (bl2 = Helper.addToClasspath((File)serializable))) {
            list.add("WARNING: Using WorldEdit.jar from .minecraft/bin");
        }
        if (Helper.getRhinoJar().exists()) {
            Helper.addToClasspath(Helper.getRhinoJar());
        }
        triedLoadingWorldEdit = true;
        return Helper.getHasWorldEdit();
    }

    public static boolean getHasWorldEdit() {
        if (hasWorldEdit == TriState.ON) {
            return true;
        }
        if (hasWorldEdit == TriState.OFF) {
            return false;
        }
        try {
            Helper.class.getClassLoader().loadClass("com.sk89q.worldedit.ServerInterface");
            hasWorldEdit = TriState.ON;
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("WorldEdit support not available.");
            hasWorldEdit = TriState.OFF;
            return false;
        }
    }

    protected static boolean addToClasspath(File file) {
        if (!file.exists()) {
            System.out.println("File " + file.getName() + " doesn't exist!");
            return false;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)Helper.class.getClassLoader();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        try {
            Method method = clazz.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)uRLClassLoader, file.toURI().toURL());
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static boolean printFormattedList(WPlayer wPlayer, String string, List list, String string2, int n2) {
        int n3;
        string = "===" + string;
        while (string.length() < n2) {
            string = string + "=";
        }
        int n4 = 7;
        int n5 = (list.size() - 1) / n4;
        boolean bl2 = false;
        try {
            n3 = list.size() == 0 ? 0 : Helper.parseIntBounded(string2, 1, n5 + 1) - 1;
        }
        catch (NumberInvalidException numberInvalidException) {
            if (numberInvalidException.getMessage().equals("TOO BIG")) {
                wPlayer.sendError("Page number was too large. (Valid range: 1-" + (n5 + 1) + ")");
                return true;
            }
            if (numberInvalidException.getMessage().equals("TOO SMALL")) {
                wPlayer.sendError("Page number was too small. (Valid range: 1-" + (n5 + 1) + ")");
                return true;
            }
            return false;
        }
        wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + string);
        wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + "Page: " + (n3 + 1) + "/" + (n5 + 1));
        int n6 = Math.min((n3 + 1) * n4, list.size());
        for (int i2 = n3 * n4; i2 < n6; ++i2) {
            String string3 = (String)list.get(i2);
            wPlayer.sendPrettyMessage(string3);
        }
        wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + "==========================");
        return true;
    }

    public static int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberInvalidException("INVALID", string);
        }
    }

    public static int parseIntBounded(String string, int n2, int n3) {
        int n4 = Helper.parseInt(string);
        if (n4 < n2) {
            throw new NumberInvalidException("TOO SMALL", n4, n2);
        }
        if (n4 > n3) {
            throw new NumberInvalidException("TOO BIG", n4, n3);
        }
        return n4;
    }

    static {
        dropItems = true;
        triedLoadingWorldEdit = false;
        hasWorldEdit = TriState.UNDEFINED;
        ERRMSG_PARAM = "Invalid number of parameters.";
        ERRMSG_PARSE = "Could not parse input.";
        ERRMSG_NOTSET = "WorldEdit points not set.";
        ERRMSG_OSNOTSUPPORTED = "Your operating system does not support this function.";
        ERRMSG_NPCNOTFOUND = "The specified NPC was not found.";
        ERRMSG_NOTOWNER = "Command can only be used by server owner.";
        settingsLoaded = false;
        debug = false;
    }
}

