/*
 * Decompiled with CFR 0.152.
 */
import com.q3hardcore.xcommands.core.Helper;
import com.q3hardcore.xcommands.core.PlayerHelper;
import com.q3hardcore.xcommands.proxy.Proxy;
import com.q3hardcore.xcommands.util.DeathPos;
import com.q3hardcore.xcommands.util.ReflectionHelper;
import com.q3hardcore.xcommands.wrapper.Coordinate;
import com.q3hardcore.xcommands.wrapper.WDamageSource;
import com.q3hardcore.xcommands.wrapper.WEntityLiving;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import com.q3hardcore.xcommands.wrapper.WStructureStart;
import com.q3hardcore.xcommands.wrapper.WWorld;
import com.q3hardcore.xcommands.wrapper.WWorldProvider;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;

public final class XCommandsHelper {
    private static boolean errorOccured = false;
    private static boolean didCheck = false;
    public static final boolean hasXCommands = XCommandsHelper.getHasXCommands();
    public static final boolean hasForge = XCommandsHelper.getHasForge();
    public static final boolean hasFML = XCommandsHelper.getHasFML();
    public static final boolean hasModLoader = XCommandsHelper.getHasModLoader();
    public static final boolean hasSPC = XCommandsHelper.getHasSPC();
    private static boolean hasNothing = false;
    private static boolean cachedWorldEditLoaded = false;

    public static void damageEntity(WEntityLiving wEntityLiving, WDamageSource wDamageSource, int n2) {
        wEntityLiving.getRaw().d(wDamageSource.getMinecraftDamageSource(), n2);
    }

    public static File getSaveDirectory(ajt ajt2) {
        return ajt2.b();
    }

    public static void generateLightBrightnessTable(WWorldProvider wWorldProvider) {
        wWorldProvider.getRaw().a();
    }

    public static agy getStructureNetherBridgeStart(WWorld wWorld, Random random, int n2, int n3) {
        return new aet(wWorld.getRaw(), random, n2, n3);
    }

    public static agy getStructureStrongholdStart(WWorld wWorld, Random random, int n2, int n3) {
        return new afw(wWorld.getRaw(), random, n2, n3);
    }

    public static agy getStructureVillageStart(WWorld wWorld, Random random, int n2, int n3, int n4) {
        return new aha(wWorld.getRaw(), random, n2, n3, n4);
    }

    public static void updateBoundingBox(WStructureStart wStructureStart) {
        wStructureStart.getRaw().c();
    }

    public static String getMinecraftVersion() {
        return new c(null).a();
    }

    public static boolean hasWorldEdit() {
        try {
            Class<?> clazz = Class.forName("com.q3hardcore.xcommands.core.Helper");
            Method method = clazz.getDeclaredMethod("getHasWorldEdit", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            System.out.println("Helper class invalid.");
            return false;
        }
        catch (Throwable throwable) {
            if (!errorOccured) {
                System.out.println("Failed to check for WorldEdit.");
                throwable.printStackTrace();
                errorOccured = true;
            }
            return false;
        }
    }

    public static boolean checkWorldEditLoaded(List list) {
        if (!hasXCommands) {
            list.add("ERROR: XCommands installed incorrectly.");
            return false;
        }
        if (!Helper.triedLoadingWorldEdit) {
            System.out.println("XCommands: Loading WorldEdit.");
            cachedWorldEditLoaded = Helper.tryLoadingWorldEdit(list);
        }
        return cachedWorldEditLoaded;
    }

    public static void checkNoclip(WPlayer wPlayer) {
        if (wPlayer.getNoclip() && !wPlayer.getCapabilities().getIsFlying()) {
            wPlayer.setNoclip(false);
            Proxy.INSTANCE.setClientNoclip(false);
            wPlayer.sendMessage("Noclip auto-disabled. (Player not flying)");
            XCommandsHelper.ascendPlayer(wPlayer);
        }
    }

    public static boolean ascendPlayer(WPlayer wPlayer) {
        if (wPlayer.isClearBelow(wPlayer.getPosition())) {
            return false;
        }
        double d2 = wPlayer.getPosY() - 1.0;
        while (d2 < 260.0) {
            double d3 = d2;
            d2 = d3 + 1.0;
            if (!wPlayer.isClear(new Coordinate(wPlayer.getPosX(), d3, wPlayer.getPosZ()))) continue;
            wPlayer.setPositionAndUpdate(wPlayer.getPosX() + 0.5, d2 - 1.0, wPlayer.getPosZ() + 0.5);
            break;
        }
        return true;
    }

    public static void storeDeathPosition(WPlayer wPlayer) {
        String string = wPlayer.getUsername();
        String string2 = wPlayer.getWorld().getName();
        DeathPos.storePos(string, string2, wPlayer.getPosition(), wPlayer.getDimension());
        System.out.println("Stored death position for: " + string);
    }

    public static WPlayer instantiatePlayer(jc jc2) {
        try {
            return new WPlayer(jc2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static PlayerHelper instantiatePlayerHelper(WPlayer wPlayer) {
        try {
            return new PlayerHelper(wPlayer);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private static boolean getHasXCommands() {
        if (hasNothing) {
            return false;
        }
        try {
            Class clazz = ReflectionHelper.getClass("com.q3hardcore.xcommands.core.Helper");
            if (clazz == null) {
                throw new Exception("Helper class not found");
            }
            jc.class.getField("serverPlayerAPI");
            return true;
        }
        catch (Throwable throwable) {
            hasNothing = true;
            return false;
        }
    }

    private static boolean getHasForge() {
        if (hasNothing) {
            return false;
        }
        String string = XCommandsHelper.getModVersion("net.minecraftforge.common.MinecraftForge", "getBrandingVersion");
        if (string != null) {
            System.out.println("XCommands: " + string + " installed.");
            return true;
        }
        System.out.println("XCommands: Minecraft Forge not installed.");
        return false;
    }

    private static boolean getHasFML() {
        if (hasNothing) {
            return false;
        }
        Class clazz = ReflectionHelper.getClass("cpw.mods.fml.common.Loader");
        if (clazz == null) {
            System.out.println("XCommands: FML not installed.");
            return false;
        }
        String string = "FML";
        try {
            Method method = clazz.getDeclaredMethod("getFMLVersionString", new Class[0]);
            Method method2 = clazz.getDeclaredMethod("instance", new Class[0]);
            Object object = method2.invoke(null, new Object[0]);
            string = string + " " + method.invoke(object, new Object[0]).toString();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        System.out.println("XCommands: " + string + " installed.");
        return true;
    }

    private static boolean getHasModLoader() {
        if (hasNothing) {
            return false;
        }
        Class clazz = ReflectionHelper.getDefaultPackageClass("ModLoader");
        if (clazz == null) {
            System.out.println("XCommands: ModLoader not installed.");
            return false;
        }
        String string = "ModLoader";
        try {
            string = clazz.getField("VERSION").get(null).toString();
        }
        catch (Throwable throwable) {
            System.out.println("XCommands: Fake ModLoader installed.");
            return false;
        }
        System.out.println("XCommands: " + string + " installed.");
        return true;
    }

    private static boolean getHasSPC() {
        if (hasNothing) {
            return false;
        }
        String string = XCommandsHelper.getModVersion("com.sijobe.spc.core.Constants", "getVersion");
        if (string != null) {
            System.out.println("XCommands: SinglePlayerCommands " + string + " installed.");
            try {
                Double d2 = Double.parseDouble(string);
                if (d2 < 4.8) {
                    throw new RuntimeException("XCommands is not compatible with SPC " + string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return true;
        }
        System.out.println("XCommands: SinglePlayerCommands not installed.");
        return false;
    }

    public static boolean isPlayerNonCreativeClient(WPlayer wPlayer) {
        boolean bl2;
        try {
            bl2 = !wPlayer.getCapabilities().getIsCreativeMode();
        }
        catch (Throwable throwable) {
            bl2 = false;
        }
        return bl2;
    }

    public static String getModVersion(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.getDeclaredMethod(string2, new Class[0]).invoke(null, new Object[0]).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

