/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import com.google.common.collect.Maps;
import cpw.mods.fml.client.CopySubimageTextureHelper;
import cpw.mods.fml.client.TextureHelper;
import cpw.mods.fml.common.FMLLog;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public class TextureFXManager {
    private static final TextureFXManager INSTANCE = new TextureFXManager();
    private Minecraft client;
    private Map<Integer, TextureHolder> texturesById = Maps.newHashMap();
    private Map<String, TextureHolder> texturesByName = Maps.newHashMap();
    private TextureHelper helper;

    void setClient(Minecraft client) {
        this.client = client;
    }

    public BufferedImage loadImageFromTexturePack(bge renderEngine, String path) throws IOException {
        InputStream image = this.client.D.e().a(path);
        if (image == null) {
            throw new RuntimeException(String.format("The requested image path %s is not found", path));
        }
        BufferedImage result = ImageIO.read(image);
        if (result == null) {
            throw new RuntimeException(String.format("The requested image path %s appears to be corrupted", path));
        }
        return result;
    }

    public static TextureFXManager instance() {
        return INSTANCE;
    }

    public void fixTransparency(BufferedImage loadedImage, String textureName) {
        if (textureName.matches("^/mob/.*_eyes.*.png$")) {
            for (int x2 = 0; x2 < loadedImage.getWidth(); ++x2) {
                for (int y2 = 0; y2 < loadedImage.getHeight(); ++y2) {
                    int argb = loadedImage.getRGB(x2, y2);
                    if ((argb & 0xFF000000) != 0 || argb == 0) continue;
                    loadedImage.setRGB(x2, y2, 0);
                }
            }
        }
    }

    public void bindTextureToName(String name, int index) {
        TextureHolder holder = new TextureHolder();
        holder.textureId = index;
        holder.textureName = name;
        this.texturesById.put(index, holder);
        this.texturesByName.put(name, holder);
    }

    public void setTextureDimensions(int index, int j2, int k2) {
        TextureHolder holder = this.texturesById.get(index);
        if (holder == null) {
            return;
        }
        holder.x = j2;
        holder.y = k2;
    }

    public Dimension getTextureDimensions(String texture) {
        return this.texturesByName.containsKey(texture) ? new Dimension(this.texturesByName.get(texture).x, this.texturesByName.get(texture).y) : new Dimension(1, 1);
    }

    public TextureHelper getHelper() {
        if (this.helper == null) {
            ContextCapabilities capabilities = GLContext.getCapabilities();
            boolean has43 = false;
            try {
                has43 = capabilities.getClass().getField("GL_ARB_copy_image").getBoolean(capabilities);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                FMLLog.info("Forge Mod Loader has detected an older LWJGL version, new advanced texture animation features are disabled", new Object[0]);
            }
            FMLLog.info("Not using advanced OpenGL 4.3 advanced capability for animations : OpenGL 4.3 is %s", has43 ? "available" : "not available");
            this.helper = new CopySubimageTextureHelper();
        }
        return this.helper;
    }

    private class TextureHolder {
        private int textureId;
        private String textureName;
        private int x;
        private int y;

        private TextureHolder() {
        }
    }
}

