/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import java.util.Set;

public class CustomColorizer {
    private static int[] grassColors = null;
    private static int[] waterColors = null;
    private static int[] foliageColors = null;
    private static int[] foliagePineColors = null;
    private static int[] foliageBirchColors = null;
    private static int[] swampFoliageColors = null;
    private static int[] swampGrassColors = null;
    private static int[][] blockPalettes = null;
    private static int[][] paletteColors = null;
    private static int[] skyColors = null;
    private static int[] fogColors = null;
    private static int[] underwaterColors = null;
    private static float[][][] lightMapsColorsRgb = null;
    private static int[] lightMapsHeight = null;
    private static float[][] sunRgbs = new float[16][3];
    private static float[][] torchRgbs = new float[16][3];
    private static int[] redstoneColors = null;
    private static int[] stemColors = null;
    private static int[] myceliumParticleColors = null;
    private static boolean useDefaultColorMultiplier = true;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static arc fogColorNether = null;
    private static arc fogColorEnd = null;
    private static arc skyColorEnd = null;
    private static final int TYPE_NONE = 0;
    private static final int TYPE_GRASS = 1;
    private static final int TYPE_FOLIAGE = 2;
    private static Random random = new Random();

    public static void update(bge var0) {
        grassColors = null;
        waterColors = null;
        foliageColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        redstoneColors = null;
        stemColors = null;
        myceliumParticleColors = null;
        lightMapsColorsRgb = null;
        lightMapsHeight = null;
        lilyPadColor = -1;
        particleWaterColor = -1;
        particlePortalColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        blockPalettes = null;
        paletteColors = null;
        useDefaultColorMultiplier = true;
        grassColors = CustomColorizer.getCustomColors("/misc/grasscolor.png", var0, 65536);
        foliageColors = CustomColorizer.getCustomColors("/misc/foliagecolor.png", var0, 65536);
        waterColors = CustomColorizer.getCustomColors("/misc/watercolorX.png", var0, 65536);
        if (Config.isCustomColors()) {
            foliagePineColors = CustomColorizer.getCustomColors("/misc/pinecolor.png", var0, 65536);
            foliageBirchColors = CustomColorizer.getCustomColors("/misc/birchcolor.png", var0, 65536);
            swampGrassColors = CustomColorizer.getCustomColors("/misc/swampgrasscolor.png", var0, 65536);
            swampFoliageColors = CustomColorizer.getCustomColors("/misc/swampfoliagecolor.png", var0, 65536);
            skyColors = CustomColorizer.getCustomColors("/misc/skycolor0.png", var0, 65536);
            fogColors = CustomColorizer.getCustomColors("/misc/fogcolor0.png", var0, 65536);
            underwaterColors = CustomColorizer.getCustomColors("/misc/underwatercolor.png", var0, 65536);
            redstoneColors = CustomColorizer.getCustomColors("/misc/redstonecolor.png", var0, 16);
            stemColors = CustomColorizer.getCustomColors("/misc/stemcolor.png", var0, 8);
            myceliumParticleColors = CustomColorizer.getCustomColors("/misc/myceliumparticlecolor.png", var0, -1);
            int[][] var1 = new int[3][];
            lightMapsColorsRgb = new float[3][][];
            lightMapsHeight = new int[3];
            for (int var2 = 0; var2 < var1.length; ++var2) {
                String var3 = "/environment/lightmap" + (var2 - 1) + ".png";
                int[] var100 = CustomColorizer.getCustomColors(var3, var0, -1);
                int[] nArray = var1[var2] = var100 != null ? var100 : CustomColorizer.getCustomColors("/environment/lightmap0.png", var0, -1);
                if (var1[var2] != null) {
                    CustomColorizer.lightMapsColorsRgb[var2] = CustomColorizer.toRgb(var1[var2]);
                }
                CustomColorizer.lightMapsHeight[var2] = CustomColorizer.getTextureHeight(var0, var3, 32);
            }
            CustomColorizer.readColorProperties("/color.properties", var0);
            CustomColorizer.updateUseDefaultColorMultiplier();
        }
    }

    private static int getTextureHeight(bge var0, String var1, int var2) {
        try {
            BufferedImage var3 = var0.readTextureImage(var1);
            return var3 == null ? var2 : var3.getHeight();
        }
        catch (IOException var4) {
            return var2;
        }
    }

    private static float[][] toRgb(int[] var0) {
        float[][] var1 = new float[var0.length][3];
        for (int var2 = 0; var2 < var0.length; ++var2) {
            int var3 = var0[var2];
            float var4 = (float)(var3 >> 16 & 0xFF) / 255.0f;
            float var5 = (float)(var3 >> 8 & 0xFF) / 255.0f;
            float var6 = (float)(var3 & 0xFF) / 255.0f;
            float[] var7 = var1[var2];
            var7[0] = var4;
            var7[1] = var5;
            var7[2] = var6;
        }
        return var1;
    }

    private static void readColorProperties(String var0, bge var1) {
        try {
            InputStream var2 = var1.getTexturePack().e().a(var0);
            if (var2 == null) {
                return;
            }
            Config.log("Loading " + var0);
            Properties var3 = new Properties();
            var3.load(var2);
            lilyPadColor = CustomColorizer.readColor(var3, "lilypad");
            particleWaterColor = CustomColorizer.readColor(var3, new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColorizer.readColor(var3, "particle.portal");
            fogColorNether = CustomColorizer.readColorVec3(var3, "fog.nether");
            fogColorEnd = CustomColorizer.readColorVec3(var3, "fog.end");
            skyColorEnd = CustomColorizer.readColorVec3(var3, "sky.end");
            CustomColorizer.readCustomPalettes(var3, var1);
        }
        catch (FileNotFoundException var4) {
            return;
        }
        catch (IOException var5) {
            var5.printStackTrace();
        }
    }

    private static void readCustomPalettes(Properties var0, bge var1) {
        String var7;
        blockPalettes = new int[256][1];
        for (int var2 = 0; var2 < 256; ++var2) {
            CustomColorizer.blockPalettes[var2][0] = -1;
        }
        String var17 = "palette.block.";
        HashMap<String, String> var3 = new HashMap<String, String>();
        Set<Object> var4 = var0.keySet();
        for (String string : var4) {
            var7 = var0.getProperty(string);
            if (!string.startsWith(var17)) continue;
            var3.put(string, var7);
        }
        String[] stringArray = var3.keySet().toArray(new String[var3.size()]);
        paletteColors = new int[stringArray.length][];
        for (int var19 = 0; var19 < stringArray.length; ++var19) {
            var7 = stringArray[var19];
            String var8 = var0.getProperty(var7);
            Config.log("Block palette: " + var7 + " = " + var8);
            String var9 = var7.substring(var17.length());
            int[] var10 = CustomColorizer.getCustomColors(var9, var1, 65536);
            CustomColorizer.paletteColors[var19] = var10;
            String[] var11 = Config.tokenize(var8, " ,;");
            for (int var12 = 0; var12 < var11.length; ++var12) {
                int var20;
                String var13 = var11[var12];
                int var14 = -1;
                if (var13.contains(":")) {
                    String[] var15 = Config.tokenize(var13, ":");
                    var13 = var15[0];
                    String var16 = var15[1];
                    var14 = Config.parseInt(var16, -1);
                    if (var14 < 0 || var14 > 15) {
                        Config.log("Invalid block metadata: " + var13 + " in palette: " + var7);
                        continue;
                    }
                }
                if ((var20 = Config.parseInt(var13, -1)) >= 0 && var20 <= 255) {
                    if (var20 == apa.y.cz || var20 == apa.ab.cz || var20 == apa.O.cz || var20 == apa.by.cz) continue;
                    if (var14 == -1) {
                        CustomColorizer.blockPalettes[var20][0] = var19;
                        continue;
                    }
                    if (blockPalettes[var20].length < 16) {
                        CustomColorizer.blockPalettes[var20] = new int[16];
                        Arrays.fill(blockPalettes[var20], -1);
                    }
                    CustomColorizer.blockPalettes[var20][var14] = var19;
                    continue;
                }
                Config.log("Invalid block index: " + var20 + " in palette: " + var7);
            }
        }
    }

    private static int readColor(Properties var0, String[] var1) {
        for (int var2 = 0; var2 < var1.length; ++var2) {
            String var3 = var1[var2];
            int var4 = CustomColorizer.readColor(var0, var3);
            if (var4 < 0) continue;
            return var4;
        }
        return -1;
    }

    private static int readColor(Properties var0, String var1) {
        String var2 = var0.getProperty(var1);
        if (var2 == null) {
            return -1;
        }
        try {
            int var3 = Integer.parseInt(var2, 16) & 0xFFFFFF;
            Config.log("Custom color: " + var1 + " = " + var2);
            return var3;
        }
        catch (NumberFormatException var4) {
            Config.log("Invalid custom color: " + var1 + " = " + var2);
            return -1;
        }
    }

    private static arc readColorVec3(Properties var0, String var1) {
        int var2 = CustomColorizer.readColor(var0, var1);
        if (var2 < 0) {
            return null;
        }
        int var3 = var2 >> 16 & 0xFF;
        int var4 = var2 >> 8 & 0xFF;
        int var5 = var2 & 0xFF;
        float var6 = (float)var3 / 255.0f;
        float var7 = (float)var4 / 255.0f;
        float var8 = (float)var5 / 255.0f;
        return arc.a(var6, var7, var8);
    }

    private static int[] getCustomColors(String var0, bge var1, int var2) {
        try {
            InputStream var3 = var1.getTexturePack().e().a(var0);
            if (var3 == null) {
                return null;
            }
            int[] var4 = var1.a(var0);
            if (var4 == null) {
                return null;
            }
            if (var2 > 0 && var4.length != var2) {
                Config.log("Invalid custom colors length: " + var4.length + ", path: " + var0);
                return null;
            }
            Config.log("Loading custom colors: " + var0);
            return var4;
        }
        catch (FileNotFoundException var5) {
            return null;
        }
        catch (IOException var6) {
            var6.printStackTrace();
            return null;
        }
    }

    public static void updateUseDefaultColorMultiplier() {
        useDefaultColorMultiplier = foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null && blockPalettes == null && Config.isSwampColors() && Config.isSmoothBiomes();
    }

    public static int getColorMultiplier(apa var0, aak var1, int var2, int var3, int var4) {
        int var10;
        if (useDefaultColorMultiplier) {
            return var0.c(var1, var2, var3, var4);
        }
        int[] var5 = null;
        int[] var6 = null;
        if (blockPalettes != null) {
            int var7 = var0.cz;
            if (var7 >= 0 && var7 < 256) {
                int var13;
                int[] var8 = blockPalettes[var7];
                boolean var9 = true;
                if (var8.length > 1) {
                    var10 = var1.h(var2, var3, var4);
                    var13 = var8[var10];
                } else {
                    var13 = var8[0];
                }
                if (var13 >= 0) {
                    var5 = paletteColors[var13];
                }
            }
            if (var5 != null) {
                if (Config.isSmoothBiomes()) {
                    return CustomColorizer.getSmoothColorMultiplier(var0, var1, var2, var3, var4, var5, var5, 0, 0);
                }
                return CustomColorizer.getCustomColor(var5, var1, var2, var3, var4);
            }
        }
        boolean var11 = Config.isSwampColors();
        boolean var12 = false;
        int var14 = 0;
        var10 = 0;
        if (var0 != apa.y && var0 != apa.ab) {
            if (var0 == apa.O) {
                var14 = 2;
                var12 = Config.isSmoothBiomes();
                var10 = var1.h(var2, var3, var4);
                if ((var10 & 3) == 1) {
                    var5 = foliagePineColors;
                } else if ((var10 & 3) == 2) {
                    var5 = foliageBirchColors;
                } else {
                    var5 = foliageColors;
                    var6 = var11 ? swampFoliageColors : var5;
                }
            } else if (var0 == apa.by) {
                var14 = 2;
                var12 = Config.isSmoothBiomes();
                var5 = foliageColors;
                var6 = var11 ? swampFoliageColors : var5;
            }
        } else {
            var14 = 1;
            var12 = Config.isSmoothBiomes();
            var5 = grassColors;
            var6 = var11 ? swampGrassColors : var5;
        }
        if (var12) {
            return CustomColorizer.getSmoothColorMultiplier(var0, var1, var2, var3, var4, var5, var6, var14, var10);
        }
        if (var6 != var5 && var1.a(var2, var4) == aav.h) {
            var5 = var6;
        }
        return var5 != null ? CustomColorizer.getCustomColor(var5, var1, var2, var3, var4) : var0.c(var1, var2, var3, var4);
    }

    private static int getSmoothColorMultiplier(apa var0, aak var1, int var2, int var3, int var4, int[] var5, int[] var6, int var7, int var8) {
        int var13;
        int var12;
        int var9 = 0;
        int var10 = 0;
        int var11 = 0;
        for (var12 = var2 - 1; var12 <= var2 + 1; ++var12) {
            for (var13 = var4 - 1; var13 <= var4 + 1; ++var13) {
                int var17;
                int[] var14 = var5;
                if (var6 != var5 && var1.a(var12, var13) == aav.h) {
                    var14 = var6;
                }
                boolean var15 = false;
                if (var14 == null) {
                    switch (var7) {
                        case 1: {
                            var17 = var1.a(var12, var13).k();
                            break;
                        }
                        case 2: {
                            if ((var8 & 3) == 1) {
                                var17 = zx.a();
                                break;
                            }
                            if ((var8 & 3) == 2) {
                                var17 = zx.b();
                                break;
                            }
                            var17 = var1.a(var12, var13).l();
                            break;
                        }
                        default: {
                            var17 = var0.c(var1, var12, var3, var13);
                            break;
                        }
                    }
                } else {
                    var17 = CustomColorizer.getCustomColor(var14, var1, var12, var3, var13);
                }
                var9 += var17 >> 16 & 0xFF;
                var10 += var17 >> 8 & 0xFF;
                var11 += var17 & 0xFF;
            }
        }
        var12 = var9 / 9;
        var13 = var10 / 9;
        int var16 = var11 / 9;
        return var12 << 16 | var13 << 8 | var16;
    }

    public static int getFluidColor(apa var0, aak var1, int var2, int var3, int var4) {
        return var0.cO != aif.h ? var0.c(var1, var2, var3, var4) : (waterColors != null ? (Config.isSmoothBiomes() ? CustomColorizer.getSmoothColor(waterColors, var1, var2, var3, var4, 3, 1) : CustomColorizer.getCustomColor(waterColors, var1, var2, var3, var4)) : (!Config.isSwampColors() ? 0xFFFFFF : var0.c(var1, var2, var3, var4)));
    }

    private static int getCustomColor(int[] var0, aak var1, int var2, int var3, int var4) {
        aav var5 = var1.a(var2, var4);
        double var6 = kx.a(var5.j(), 0.0f, 1.0f);
        double var8 = kx.a(var5.i(), 0.0f, 1.0f);
        int var10 = (int)((1.0 - var6) * 255.0);
        int var11 = (int)((1.0 - (var8 *= var6)) * 255.0);
        return var0[var11 << 8 | var10] & 0xFFFFFF;
    }

    public static void updatePortalFX(bet var0) {
        if (particlePortalColor >= 0) {
            int var1 = particlePortalColor;
            int var2 = var1 >> 16 & 0xFF;
            int var3 = var1 >> 8 & 0xFF;
            int var4 = var1 & 0xFF;
            float var5 = (float)var2 / 255.0f;
            float var6 = (float)var3 / 255.0f;
            float var7 = (float)var4 / 255.0f;
            var0.j = var5;
            var0.au = var6;
            var0.av = var7;
        }
    }

    public static void updateMyceliumFX(bet var0) {
        if (myceliumParticleColors != null) {
            int var1 = myceliumParticleColors[random.nextInt(myceliumParticleColors.length)];
            int var2 = var1 >> 16 & 0xFF;
            int var3 = var1 >> 8 & 0xFF;
            int var4 = var1 & 0xFF;
            float var5 = (float)var2 / 255.0f;
            float var6 = (float)var3 / 255.0f;
            float var7 = (float)var4 / 255.0f;
            var0.j = var5;
            var0.au = var6;
            var0.av = var7;
        }
    }

    public static void updateReddustFX(bet var0, aak var1, double var2, double var4, double var6) {
        int var8;
        int var9;
        if (redstoneColors != null && (var9 = CustomColorizer.getRedstoneColor(var8 = var1.h((int)var2, (int)var4, (int)var6))) != -1) {
            int var10 = var9 >> 16 & 0xFF;
            int var11 = var9 >> 8 & 0xFF;
            int var12 = var9 & 0xFF;
            float var13 = (float)var10 / 255.0f;
            float var14 = (float)var11 / 255.0f;
            float var15 = (float)var12 / 255.0f;
            var0.j = var13;
            var0.au = var14;
            var0.av = var15;
        }
    }

    public static int getRedstoneColor(int var0) {
        return redstoneColors == null ? -1 : (var0 >= 0 && var0 <= 15 ? redstoneColors[var0] & 0xFFFFFF : -1);
    }

    public static void updateWaterFX(bet var0, aak var1) {
        if (waterColors != null) {
            int var2 = (int)var0.u;
            int var3 = (int)var0.v;
            int var4 = (int)var0.w;
            int var5 = CustomColorizer.getFluidColor(apa.F, var1, var2, var3, var4);
            int var6 = var5 >> 16 & 0xFF;
            int var7 = var5 >> 8 & 0xFF;
            int var8 = var5 & 0xFF;
            float var9 = (float)var6 / 255.0f;
            float var10 = (float)var7 / 255.0f;
            float var11 = (float)var8 / 255.0f;
            if (particleWaterColor >= 0) {
                int var12 = particleWaterColor >> 16 & 0xFF;
                int var13 = particleWaterColor >> 8 & 0xFF;
                int var14 = particleWaterColor & 0xFF;
                var9 *= (float)var12 / 255.0f;
                var10 *= (float)var13 / 255.0f;
                var11 *= (float)var14 / 255.0f;
            }
            var0.j = var9;
            var0.au = var10;
            var0.av = var11;
        }
    }

    public static int getLilypadColor() {
        return lilyPadColor < 0 ? apa.bD.o() : lilyPadColor;
    }

    public static arc getFogColorNether(arc var0) {
        return fogColorNether == null ? var0 : fogColorNether;
    }

    public static arc getFogColorEnd(arc var0) {
        return fogColorEnd == null ? var0 : fogColorEnd;
    }

    public static arc getSkyColorEnd(arc var0) {
        return skyColorEnd == null ? var0 : skyColorEnd;
    }

    public static arc getSkyColor(arc var0, aak var1, double var2, double var4, double var6) {
        if (skyColors == null) {
            return var0;
        }
        int var8 = CustomColorizer.getSmoothColor(skyColors, var1, var2, var4, var6, 10, 1);
        int var9 = var8 >> 16 & 0xFF;
        int var10 = var8 >> 8 & 0xFF;
        int var11 = var8 & 0xFF;
        float var12 = (float)var9 / 255.0f;
        float var13 = (float)var10 / 255.0f;
        float var14 = (float)var11 / 255.0f;
        float var15 = (float)var0.c / 0.5f;
        float var16 = (float)var0.d / 0.66275f;
        float var17 = (float)var0.e;
        return arc.a(var12 *= var15, var13 *= var16, var14 *= var17);
    }

    public static arc getFogColor(arc var0, aak var1, double var2, double var4, double var6) {
        if (fogColors == null) {
            return var0;
        }
        int var8 = CustomColorizer.getSmoothColor(fogColors, var1, var2, var4, var6, 10, 1);
        int var9 = var8 >> 16 & 0xFF;
        int var10 = var8 >> 8 & 0xFF;
        int var11 = var8 & 0xFF;
        float var12 = (float)var9 / 255.0f;
        float var13 = (float)var10 / 255.0f;
        float var14 = (float)var11 / 255.0f;
        float var15 = (float)var0.c / 0.753f;
        float var16 = (float)var0.d / 0.8471f;
        float var17 = (float)var0.e;
        return arc.a(var12 *= var15, var13 *= var16, var14 *= var17);
    }

    public static arc getUnderwaterColor(aak var0, double var1, double var3, double var5) {
        if (underwaterColors == null) {
            return null;
        }
        int var7 = CustomColorizer.getSmoothColor(underwaterColors, var0, var1, var3, var5, 10, 1);
        int var8 = var7 >> 16 & 0xFF;
        int var9 = var7 >> 8 & 0xFF;
        int var10 = var7 & 0xFF;
        float var11 = (float)var8 / 255.0f;
        float var12 = (float)var9 / 255.0f;
        float var13 = (float)var10 / 255.0f;
        return arc.a(var11, var12, var13);
    }

    public static int getSmoothColor(int[] var0, aak var1, double var2, double var4, double var6, int var8, int var9) {
        int var20;
        int var19;
        int var18;
        if (var0 == null) {
            return -1;
        }
        int var10 = (int)Math.floor(var2);
        int var11 = (int)Math.floor(var4);
        int var12 = (int)Math.floor(var6);
        int var13 = var8 * var9 / 2;
        int var14 = 0;
        int var15 = 0;
        int var16 = 0;
        int var17 = 0;
        for (var18 = var10 - var13; var18 <= var10 + var13; var18 += var9) {
            for (var19 = var12 - var13; var19 <= var12 + var13; var19 += var9) {
                var20 = CustomColorizer.getCustomColor(var0, var1, var18, var11, var19);
                var14 += var20 >> 16 & 0xFF;
                var15 += var20 >> 8 & 0xFF;
                var16 += var20 & 0xFF;
                ++var17;
            }
        }
        var18 = var14 / var17;
        var19 = var15 / var17;
        var20 = var16 / var17;
        return var18 << 16 | var19 << 8 | var20;
    }

    public static int mixColors(int var0, int var1, float var2) {
        if (var2 <= 0.0f) {
            return var1;
        }
        if (var2 >= 1.0f) {
            return var0;
        }
        float var3 = 1.0f - var2;
        int var4 = var0 >> 16 & 0xFF;
        int var5 = var0 >> 8 & 0xFF;
        int var6 = var0 & 0xFF;
        int var7 = var1 >> 16 & 0xFF;
        int var8 = var1 >> 8 & 0xFF;
        int var9 = var1 & 0xFF;
        int var10 = (int)((float)var4 * var2 + (float)var7 * var3);
        int var11 = (int)((float)var5 * var2 + (float)var8 * var3);
        int var12 = (int)((float)var6 * var2 + (float)var9 * var3);
        return var10 << 16 | var11 << 8 | var12;
    }

    private static int averageColor(int var0, int var1) {
        int var2 = var0 >> 16 & 0xFF;
        int var3 = var0 >> 8 & 0xFF;
        int var4 = var0 & 0xFF;
        int var5 = var1 >> 16 & 0xFF;
        int var6 = var1 >> 8 & 0xFF;
        int var7 = var1 & 0xFF;
        int var8 = (var2 + var5) / 2;
        int var9 = (var3 + var6) / 2;
        int var10 = (var4 + var7) / 2;
        return var8 << 16 | var9 << 8 | var10;
    }

    public static int getStemColorMultiplier(aor var0, aak var1, int var2, int var3, int var4) {
        if (stemColors == null) {
            return var0.c(var1, var2, var3, var4);
        }
        int var5 = var1.h(var2, var3, var4);
        if (var5 < 0) {
            var5 = 0;
        }
        if (var5 >= stemColors.length) {
            var5 = stemColors.length - 1;
        }
        return stemColors[var5];
    }

    public static boolean updateLightmap(aab var0, bfq var1, int[] var2, boolean var3) {
        if (var0 == null) {
            return false;
        }
        if (lightMapsColorsRgb == null) {
            return false;
        }
        if (!Config.isCustomColors()) {
            return false;
        }
        int var4 = var0.t.h;
        if (var4 >= -1 && var4 <= 1) {
            int var5 = var4 + 1;
            float[][] var6 = lightMapsColorsRgb[var5];
            if (var6 == null) {
                return false;
            }
            int var7 = lightMapsHeight[var5];
            if (var3 && var7 < 64) {
                return false;
            }
            int var8 = var6.length / var7;
            if (var8 < 16) {
                Config.dbg("Invalid lightmap width: " + var8 + " for: /environment/lightmap" + var4 + ".png");
                CustomColorizer.lightMapsColorsRgb[var5] = null;
                return false;
            }
            int var9 = 0;
            if (var3) {
                var9 = var8 * 16 * 2;
            }
            float var10 = 1.1666666f * (var0.b(1.0f) - 0.2f);
            if (var0.q > 0) {
                var10 = 1.0f;
            }
            var10 = Config.limitTo1(var10);
            float var11 = var10 * (float)(var8 - 1);
            float var12 = Config.limitTo1(var1.e + 0.5f) * (float)(var8 - 1);
            float var13 = Config.limitTo1(Config.getGameSettings().ak);
            boolean var14 = var13 > 1.0E-4f;
            CustomColorizer.getLightMapColumn(var6, var11, var9, var8, sunRgbs);
            CustomColorizer.getLightMapColumn(var6, var12, var9 + 16 * var8, var8, torchRgbs);
            float[] var15 = new float[3];
            for (int var16 = 0; var16 < 16; ++var16) {
                for (int var17 = 0; var17 < 16; ++var17) {
                    int var18;
                    for (var18 = 0; var18 < 3; ++var18) {
                        float var19 = Config.limitTo1(sunRgbs[var16][var18] + torchRgbs[var17][var18]);
                        if (var14) {
                            float var20 = 1.0f - var19;
                            var20 = 1.0f - var20 * var20 * var20 * var20;
                            var19 = var13 * var20 + (1.0f - var13) * var19;
                        }
                        var15[var18] = var19;
                    }
                    var18 = (int)(var15[0] * 255.0f);
                    int var22 = (int)(var15[1] * 255.0f);
                    int var21 = (int)(var15[2] * 255.0f);
                    var2[var16 * 16 + var17] = 0xFF000000 | var18 << 16 | var22 << 8 | var21;
                }
            }
            return true;
        }
        return false;
    }

    private static void getLightMapColumn(float[][] var0, float var1, int var2, int var3, float[][] var4) {
        int var6;
        int var5 = (int)Math.floor(var1);
        if (var5 == (var6 = (int)Math.ceil(var1))) {
            for (int var14 = 0; var14 < 16; ++var14) {
                float[] var15 = var0[var2 + var14 * var3 + var5];
                float[] var16 = var4[var14];
                for (int var17 = 0; var17 < 3; ++var17) {
                    var16[var17] = var15[var17];
                }
            }
        } else {
            float var7 = 1.0f - (var1 - (float)var5);
            float var8 = 1.0f - ((float)var6 - var1);
            for (int var9 = 0; var9 < 16; ++var9) {
                float[] var10 = var0[var2 + var9 * var3 + var5];
                float[] var11 = var0[var2 + var9 * var3 + var6];
                float[] var12 = var4[var9];
                for (int var13 = 0; var13 < 3; ++var13) {
                    var12[var13] = var10[var13] * var7 + var11[var13] * var8;
                }
            }
        }
    }
}

