/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexProgram;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class Shaders {
    public static boolean isInitialized = false;
    private static int renderDisplayWidth = 0;
    private static int renderDisplayHeight = 0;
    public static int renderWidth = 0;
    public static int renderHeight = 0;
    private static Minecraft mc = null;
    public static boolean isRenderingWorld = false;
    public static boolean isRenderingSky = false;
    public static boolean isCompositeRendered = false;
    public static boolean isRenderingDfb = false;
    public static boolean isShadowPass = false;
    private static float[] sunPosition = new float[3];
    private static float[] moonPosition = new float[3];
    private static float[] clearColor = new float[3];
    private static long worldTime = 0L;
    private static long lastWorldTime = 0L;
    private static long diffWorldTime = 0L;
    private static float sunAngle = 0.0f;
    private static float shadowAngle = 0.0f;
    private static float rainStrength = 0.0f;
    private static float wetness = 0.0f;
    public static float wetnessHalfLife = 600.0f;
    public static float drynessHalfLife = 200.0f;
    private static boolean usewetness = false;
    private static int isEyeInWater = 0;
    private static int eyeBrightness = 0;
    private static float eyeBrightnessFadeX = 0.0f;
    private static float eyeBrightnessFadeY = 0.0f;
    private static float eyePosY = 0.0f;
    private static boolean lightmapEnabled = false;
    private static boolean fogEnabled = true;
    public static int entityAttrib = -1;
    public static boolean useEntityHurtFlash;
    public static int uniformEntityHurt;
    public static int uniformEntityFlash;
    private static FloatBuffer previousProjection;
    private static FloatBuffer projection;
    private static FloatBuffer projectionInverse;
    private static FloatBuffer previousModelView;
    private static FloatBuffer modelView;
    private static FloatBuffer modelViewInverse;
    private static double[] previousCameraPosition;
    private static double[] cameraPosition;
    private static int shadowPassInterval;
    private static int shadowMapWidth;
    private static int shadowMapHeight;
    private static float shadowMapFOV;
    private static float shadowMapHalfPlane;
    private static boolean shadowMapIsOrtho;
    private static int gbufferFormat_gdepth;
    private static int gbufferFormat_gaux4;
    private static int gbufferFormat_gnormal;
    private static int shadowPassCounter;
    private static int preShadowPassThirdPersonView;
    public static boolean shouldSkipDefaultShadow;
    private static int sfb;
    private static int sfbColorTexture;
    private static int sfbDepthTexture;
    private static int sfbWaterDepthTexture;
    private static int sfbRenderBuffer;
    private static int sfbDepthBuffer;
    private static FloatBuffer shadowProjection;
    private static FloatBuffer shadowProjectionInverse;
    private static FloatBuffer shadowModelView;
    private static FloatBuffer shadowModelViewInverse;
    private static final int MaxColorBuffers = 8;
    private static final int MaxDrawBuffers = 8;
    private static int usedColorBuffers;
    private static int usedColorAttachs;
    private static int usedDrawBuffers;
    private static IntBuffer dfbDrawBuffers;
    private static IntBuffer dfbTextures;
    private static IntBuffer drawBuffersLast;
    private static IntBuffer drawBuffersAll;
    private static IntBuffer drawBuffersClear0;
    private static IntBuffer drawBuffersClear1;
    private static IntBuffer drawBuffersClearColor;
    private static int dfb;
    private static int dfbDepthTexture;
    public static int activeProgram;
    public static final int ProgramNone = 0;
    public static final int ProgramBasic = 1;
    public static final int ProgramTextured = 2;
    public static final int ProgramTexturedLit = 3;
    public static final int ProgramSkyBasic = 4;
    public static final int ProgramSkyTextured = 5;
    public static final int ProgramTerrain = 6;
    public static final int ProgramEntities = 7;
    public static final int ProgramHand = 8;
    public static final int ProgramWater = 9;
    public static final int ProgramWeather = 10;
    public static final int ProgramComposite = 11;
    public static final int ProgramComposite1 = 12;
    public static final int ProgramComposite2 = 13;
    public static final int ProgramComposite3 = 14;
    public static final int ProgramComposite4 = 15;
    public static final int ProgramComposite5 = 16;
    public static final int ProgramComposite6 = 17;
    public static final int ProgramComposite7 = 18;
    public static final int ProgramFinal = 19;
    public static final int ProgramCount = 20;
    public static final int MaxCompositePasses = 8;
    private static final String[] programNames;
    private static final int[] programBackups;
    private static int[] programs;
    private static int[] programsRef;
    private static String newDrawBufSetting;
    private static String[] programsDrawBufSettings;
    private static IntBuffer[] programsDrawBuffers;
    private static IntBuffer activeDrawBuffers;
    private static String newColorAtmSetting;
    private static String[] programsColorAtmSettings;
    private static String activeColorAtmSettings;
    public static Properties loadedShaders;
    public static Properties shadersConfig;
    public static bge renderEngine;
    public static HashMap textureIdMap;
    public static HashMap textureIdByNameMap;
    public static HashMap textureIdByUrlMap;
    public static HashMap defaultTextureImageMap;
    public static BufferedImage defaultTextureImage_d;
    public static BufferedImage defaultTextureImage_n;
    public static BufferedImage defaultTextureImage_s;
    public static BufferedImage transparentImage;
    public static int[] defaultTextureIdArray;
    public static int[] terrainTextureIdArray;
    public static boolean normalMapEnabled;
    private static ByteBuffer tempDirectByteBuffer;
    private static IntBuffer tempDirectIntBuffer;
    public static boolean dtweak;
    public static boolean configCloudShadow;
    public static float configHandDepthMul;
    static IShaderPack shaderPack;
    static File currentshader;
    static String currentshadername;
    static String packNameNone;
    static String packNameDefault;
    static String shaderpacksdirname;
    static String optionsfilename;
    static File shadersdir;
    static File shaderpacksdir;
    static File configFile;
    public static final boolean enableShadersOption = true;
    private static final boolean enableShadersDebug = true;
    static final String ofVersion = "OptiFine_1.5.2_HD_U_D2";
    public static final int version = 1014502;

    private Shaders() {
    }

    public static void loadConfig() {
        try {
            if (!shaderpacksdir.exists()) {
                shaderpacksdir.mkdir();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        shadersConfig = new Properties();
        shadersConfig.setProperty("shaderPack", "");
        if (configFile.exists()) {
            try {
                FileReader reader = new FileReader(configFile);
                shadersConfig.load(reader);
                reader.close();
            }
            catch (Exception e3) {
                // empty catch block
            }
        }
        if (!configFile.exists()) {
            try {
                Shaders.storeConfig();
            }
            catch (Exception e4) {
                // empty catch block
            }
        }
        Object value = null;
        dtweak = Boolean.parseBoolean(shadersConfig.getProperty("dtweak", "false"));
        configCloudShadow = Boolean.parseBoolean(shadersConfig.getProperty("cloudShadow", "true"));
        configHandDepthMul = Float.parseFloat(shadersConfig.getProperty("handDepthMul", "0.125"));
        currentshadername = shadersConfig.getProperty("shaderPack", packNameDefault);
        Shaders.loadShaderPack();
    }

    public static void storeConfig() {
        System.out.println("Shaders.storeConfig");
        shadersConfig.setProperty("dtweak", Boolean.toString(dtweak));
        shadersConfig.setProperty("cloudShadow", Boolean.toString(configCloudShadow));
        shadersConfig.setProperty("handDepthMul", Float.toString(configHandDepthMul));
        try {
            FileWriter writer = new FileWriter(configFile);
            shadersConfig.store(writer, null);
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setShaderPack(String par1name) {
        currentshadername = par1name;
        shadersConfig.setProperty("shaderPack", par1name);
    }

    public static void loadShaderPack() {
        String packName;
        if (shaderPack != null) {
            shaderPack.close();
            shaderPack = null;
        }
        if (!(packName = shadersConfig.getProperty("shaderPack", packNameDefault)).isEmpty() && !packName.equals(packNameNone)) {
            if (packName.equals(packNameDefault)) {
                shaderPack = new ShaderPackDefault();
            } else {
                try {
                    File packFile = new File(shaderpacksdir, packName);
                    if (packFile.isDirectory()) {
                        shaderPack = new ShaderPackFolder(packName, packFile);
                    } else if (packFile.isFile() && packName.toLowerCase().endsWith(".zip")) {
                        shaderPack = new ShaderPackZip(packName, packFile);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (shaderPack == null) {
            shaderPack = new ShaderPackNone();
        }
    }

    static ArrayList listofShaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(packNameNone);
        list.add(packNameDefault);
        try {
            if (!shaderpacksdir.exists()) {
                shaderpacksdir.mkdir();
            }
            File[] listOfFiles = shaderpacksdir.listFiles();
            for (int i2 = 0; i2 < listOfFiles.length; ++i2) {
                File file = listOfFiles[i2];
                String name = file.getName();
                if (!file.isDirectory() && (!file.isFile() || !name.toLowerCase().endsWith(".zip"))) continue;
                list.add(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    static String versiontostring(int vv2) {
        String vs2 = Integer.toString(vv2);
        return Integer.toString(Integer.parseInt(vs2.substring(1, 3))) + "." + Integer.toString(Integer.parseInt(vs2.substring(3, 5))) + "." + Integer.toString(Integer.parseInt(vs2.substring(5)));
    }

    static void checkOptifine() {
        try {
            System.out.println("[Shaders] Required OptiFine version : OptiFine_1.5.2_HD_U_D2");
            String configVersion = (String)Config.class.getDeclaredField("VERSION").get(null);
            System.out.println("[Shaders] Detected OptiFine version : " + configVersion);
            if (configVersion.equals(ofVersion)) {
                System.out.println("[Shaders] ShadersMod loaded. version: " + Shaders.versiontostring(1014502));
            } else {
                System.err.println("[Shaders] Wrong OptiFine version!");
                System.exit(-1);
            }
        }
        catch (Exception e2) {
            System.err.println("[Shaders] OptiFine missing or wrong version! Install OptiFine OptiFine_1.5.2_HD_U_D2 first and then the ShadersMod!");
            System.exit(-1);
        }
    }

    public static int checkGLError(String location) {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            String str = "GL Error " + errorCode + ": " + GLU.gluErrorString((int)errorCode) + " @" + location;
            System.err.println(str);
        }
        return errorCode;
    }

    public static int checkGLError(String location, String info) {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            String str = "GL Error " + errorCode + ": " + GLU.gluErrorString((int)errorCode) + " @" + location + " " + info;
            System.err.println(str);
        }
        return errorCode;
    }

    public static void init() {
        if (!isInitialized) {
            int i2;
            mc = Minecraft.x();
            Shaders.checkGLError("Shaders.init pre");
            ContextCapabilities capabilities = GLContext.getCapabilities();
            System.out.println("[Shaders] OpenGL 2.0 = " + capabilities.OpenGL20 + "    OpenGL 2.1 = " + capabilities.OpenGL21 + "    OpenGL 3.0 = " + capabilities.OpenGL30 + "    OpenGL 3.2 = " + capabilities.OpenGL32);
            if (!capabilities.OpenGL20) {
                Shaders.printChatAndLogError("[Shaders] No OpenGL 2.0.");
            }
            if (!capabilities.OpenGL21) {
                Shaders.printChatAndLogError("[Shaders] No OpenGL 2.1.");
            }
            if (!capabilities.GL_EXT_framebuffer_object) {
                Shaders.printChatAndLogError("[Shaders] No EXT_framebuffer_object.");
            }
            if (!capabilities.OpenGL20 || !capabilities.GL_EXT_framebuffer_object) {
                System.out.println("[Shaders] Your GPU is not compatible with the Shaders mod.");
                System.exit(-1);
            }
            if (tempDirectByteBuffer == null) {
                tempDirectByteBuffer = ByteBuffer.allocateDirect(16);
                tempDirectIntBuffer = tempDirectByteBuffer.asIntBuffer();
            }
            if (dfbDrawBuffers == null) {
                dfbDrawBuffers = BufferUtils.createIntBuffer((int)8);
            }
            if (dfbTextures == null) {
                dfbTextures = BufferUtils.createIntBuffer((int)8);
            }
            int maxDrawBuffers = GL11.glGetInteger((int)34852);
            int maxColorAttach = GL11.glGetInteger((int)36063);
            System.out.println("[Shaders] GL_MAX_DRAW_BUFFERS = " + maxDrawBuffers);
            System.out.println("[Shaders] GL_MAX_COLOR_ATTACHMENTS_EXT = " + maxColorAttach);
            System.out.println("[Shaders] GL_MAX_TEXTURE_IMAGE_UNITS = " + GL11.glGetInteger((int)34930));
            usedColorBuffers = 4;
            usedColorAttachs = 1;
            usedDrawBuffers = 1;
            gbufferFormat_gdepth = 6408;
            gbufferFormat_gaux4 = 6408;
            gbufferFormat_gnormal = 6408;
            for (i2 = 0; i2 < 20; ++i2) {
                int pr2;
                if (programNames[i2] == "") {
                    Shaders.programsRef[i2] = 0;
                    Shaders.programs[i2] = 0;
                    Shaders.programsDrawBufSettings[i2] = null;
                    Shaders.programsColorAtmSettings[i2] = null;
                    continue;
                }
                newDrawBufSetting = null;
                newColorAtmSetting = null;
                Shaders.programs[i2] = Shaders.programsRef[i2] = (pr2 = Shaders.setupProgram(i2, "/shaders/" + programNames[i2] + ".vsh", "/shaders/" + programNames[i2] + ".fsh"));
                Shaders.programsDrawBufSettings[i2] = pr2 != 0 ? newDrawBufSetting : null;
                Shaders.programsColorAtmSettings[i2] = pr2 != 0 ? newColorAtmSetting : null;
            }
            for (int p2 = 0; p2 < 20; ++p2) {
                if (p2 == 19) {
                    Shaders.programsDrawBuffers[p2] = null;
                    continue;
                }
                if (programs[p2] == 0) {
                    Shaders.programsDrawBuffers[p2] = dfbDrawBuffers;
                    continue;
                }
                String str = programsDrawBufSettings[p2];
                if (str != null) {
                    IntBuffer intbuf = BufferUtils.createIntBuffer((int)8);
                    int numDB = str.length();
                    if (numDB > usedDrawBuffers) {
                        usedDrawBuffers = numDB;
                    }
                    if (numDB > maxDrawBuffers) {
                        numDB = maxDrawBuffers;
                    }
                    Shaders.programsDrawBuffers[p2] = intbuf;
                    intbuf.limit(usedColorBuffers);
                    for (int i3 = 0; i3 < numDB; ++i3) {
                        char c2;
                        int d2 = 0;
                        if (str.length() > i3 && (c2 = str.charAt(i3)) >= '0' && c2 <= '7') {
                            int ca2 = c2 - 48;
                            d2 = ca2 + 36064;
                            if (ca2 > usedColorAttachs) {
                                usedColorAttachs = ca2;
                            }
                            if (ca2 > usedColorBuffers) {
                                usedColorBuffers = ca2;
                            }
                        }
                        intbuf.put(i3, d2);
                    }
                    continue;
                }
                Shaders.programsDrawBuffers[p2] = dfbDrawBuffers;
                usedDrawBuffers = usedColorBuffers;
            }
            usedColorAttachs = usedColorBuffers;
            dfbDrawBuffers.limit(usedColorBuffers);
            dfbTextures.limit(usedColorBuffers);
            for (i2 = 0; i2 < usedColorBuffers; ++i2) {
                dfbDrawBuffers.put(i2, 36064 + i2);
            }
            if (usedDrawBuffers > maxDrawBuffers) {
                Shaders.printChatAndLogError("[Shaders] Not enough draw buffers! Requires " + usedDrawBuffers + ".  Has " + maxDrawBuffers + ".");
            }
            for (i2 = 0; i2 < 20; ++i2) {
                int n2 = i2;
                while (programs[n2] == 0 && programBackups[n2] != n2) {
                    n2 = programBackups[n2];
                }
                if (n2 == i2) continue;
                Shaders.programs[i2] = programs[n2];
                Shaders.programsDrawBufSettings[i2] = programsDrawBufSettings[n2];
                Shaders.programsDrawBuffers[i2] = programsDrawBuffers[n2];
            }
            Shaders.resize();
            Shaders.setupShadowMap();
            isInitialized = true;
            Shaders.checkGLError("Shaders.init");
        }
    }

    private static IntBuffer fillIntBufferZero(IntBuffer buf) {
        int limit = buf.limit();
        for (int i2 = buf.position(); i2 < limit; ++i2) {
            buf.put(i2, 0);
        }
        return buf;
    }

    public static void uninit() {
        if (isInitialized) {
            Shaders.checkGLError("Shaders.uninit pre");
            for (int i2 = 0; i2 < 20; ++i2) {
                if (programsRef[i2] != 0) {
                    ARBShaderObjects.glDeleteObjectARB((int)programsRef[i2]);
                    Shaders.checkGLError("del programRef[" + i2 + "] " + programsRef[i2]);
                }
                Shaders.programsRef[i2] = 0;
                Shaders.programs[i2] = 0;
                Shaders.programsDrawBufSettings[i2] = null;
                Shaders.programsDrawBuffers[i2] = null;
            }
            if (dfb != 0) {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)dfb);
                dfb = 0;
                Shaders.checkGLError("del dfb");
            }
            if (sfb != 0) {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)sfb);
                sfb = 0;
                Shaders.checkGLError("del sfb");
            }
            if (dfbDepthTexture != 0) {
                GL11.glDeleteTextures((int)dfbDepthTexture);
                dfbDepthTexture = 0;
                Shaders.checkGLError("del dfbDepthTexture");
            }
            if (dfbTextures != null) {
                GL11.glDeleteTextures((IntBuffer)dfbTextures);
                Shaders.fillIntBufferZero(dfbTextures);
                Shaders.checkGLError("del dfbTextures");
            }
            if (sfbDepthTexture != 0) {
                GL11.glDeleteTextures((int)sfbDepthTexture);
                sfbDepthTexture = 0;
                Shaders.checkGLError("del shadow depth");
            }
            if (sfbWaterDepthTexture != 0) {
                GL11.glDeleteTextures((int)sfbWaterDepthTexture);
                sfbWaterDepthTexture = 0;
                Shaders.checkGLError("del shadow water");
            }
            if (dfbDrawBuffers != null) {
                Shaders.fillIntBufferZero(dfbDrawBuffers);
            }
            shadowPassInterval = 0;
            shouldSkipDefaultShadow = false;
            isInitialized = false;
            Shaders.checkGLError("Shaders.uninit");
        }
    }

    private static void resize() {
        renderDisplayWidth = Shaders.mc.c;
        renderDisplayHeight = Shaders.mc.d;
        renderWidth = Shaders.mc.c;
        renderHeight = Shaders.mc.d;
        Shaders.setupFrameBuffer();
    }

    private static void setupFrameBuffer() {
        if (dfb != 0) {
            EXTFramebufferObject.glDeleteFramebuffersEXT((int)dfb);
            GL11.glDeleteTextures((int)dfbDepthTexture);
            GL11.glDeleteTextures((IntBuffer)dfbTextures);
        }
        dfb = EXTFramebufferObject.glGenFramebuffersEXT();
        dfbDepthTexture = GL11.glGenTextures();
        GL11.glGenTextures((IntBuffer)dfbTextures);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        ByteBuffer buffer = ByteBuffer.allocateDirect(renderWidth * renderHeight * 4 * 4);
        GL11.glBindTexture((int)3553, (int)dfbDepthTexture);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)34891, (int)6409);
        GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)renderWidth, (int)renderHeight, (int)0, (int)6402, (int)5126, (ByteBuffer)buffer);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)dfbDepthTexture, (int)0);
        Shaders.checkGLError("FT d");
        for (int i2 = 0; i2 < usedColorBuffers; ++i2) {
            GL11.glBindTexture((int)3553, (int)dfbTextures.get(i2));
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            if (i2 == 1 && gbufferFormat_gdepth != 6408) {
                GL11.glTexImage2D((int)3553, (int)0, (int)gbufferFormat_gdepth, (int)renderWidth, (int)renderHeight, (int)0, (int)6408, (int)5126, (ByteBuffer)buffer);
            } else if (i2 == 2 && gbufferFormat_gnormal != 6408) {
                GL11.glTexImage2D((int)3553, (int)0, (int)gbufferFormat_gaux4, (int)renderWidth, (int)renderHeight, (int)0, (int)6408, (int)5126, (ByteBuffer)buffer);
            } else if (i2 == 7 && gbufferFormat_gaux4 != 6408) {
                GL11.glTexImage2D((int)3553, (int)0, (int)gbufferFormat_gaux4, (int)renderWidth, (int)renderHeight, (int)0, (int)6408, (int)5126, (ByteBuffer)buffer);
            } else {
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)renderWidth, (int)renderHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
            }
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)dfbDrawBuffers.get(i2), (int)3553, (int)dfbTextures.get(i2), (int)0);
            Shaders.checkGLError("FT c");
        }
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status == 36058) {
            Shaders.printChatAndLogError("Failed using multiple internal formats in frame buffer.");
            for (int i3 = 0; i3 < usedColorBuffers; ++i3) {
                GL11.glBindTexture((int)3553, (int)dfbTextures.get(i3));
                if (i3 == 1 && gbufferFormat_gdepth != 6408) {
                    GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)renderWidth, (int)renderHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
                } else if (i3 == 2 && gbufferFormat_gnormal != 6408) {
                    GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)renderWidth, (int)renderHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
                } else if (i3 == 7 && gbufferFormat_gaux4 != 6408) {
                    GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)renderWidth, (int)renderHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
                }
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)dfbDrawBuffers.get(i3), (int)3553, (int)dfbTextures.get(i3), (int)0);
                Shaders.checkGLError("FT c");
            }
            status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
            if (status == 36053) {
                Shaders.printChatAndLogError("Using low quality workaround!");
            }
        }
        if (status != 36053) {
            Shaders.printChatAndLogError("Failed creating framebuffer! (Status " + status + ")");
        }
    }

    private static void setupShadowMap() {
        Shaders.setupShadowFrameBuffer();
    }

    private static void setupShadowFrameBuffer() {
        if (shadowPassInterval <= 0) {
            return;
        }
        Shaders.setupShadowRenderTexture();
        EXTFramebufferObject.glDeleteFramebuffersEXT((int)sfb);
        sfb = EXTFramebufferObject.glGenFramebuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sfb);
        GL11.glDrawBuffer((int)0);
        GL11.glReadBuffer((int)0);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbDepthTexture, (int)0);
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status != 36053) {
            Shaders.printChatAndLogError("Failed creating shadow framebuffer! (Status " + status + ")");
        }
    }

    private static void setupShadowRenderTexture() {
        if (shadowPassInterval <= 0) {
            return;
        }
        GL11.glDeleteTextures((int)sfbDepthTexture);
        GL11.glDeleteTextures((int)sfbWaterDepthTexture);
        sfbDepthTexture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)sfbDepthTexture);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        ByteBuffer buffer = ByteBuffer.allocateDirect(shadowMapWidth * shadowMapHeight * 4);
        GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)shadowMapWidth, (int)shadowMapHeight, (int)0, (int)6402, (int)5126, (ByteBuffer)buffer);
        sfbWaterDepthTexture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)sfbWaterDepthTexture);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        ByteBuffer waterbuffer = ByteBuffer.allocateDirect(shadowMapWidth * shadowMapHeight * 4);
        GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)shadowMapWidth, (int)shadowMapHeight, (int)0, (int)6402, (int)5126, (ByteBuffer)waterbuffer);
    }

    private static String printChatAndLogError(String str) {
        Shaders.mc.w.b().a(str);
        System.err.println(str);
        return str;
    }

    public static void setRenderEngine(bge var1) {
        mc = Minecraft.x();
        if (renderEngine != null) {
            System.out.println("Shaders: Multiple RenderEngine!");
        }
        renderEngine = var1;
        defaultTextureImage_d = new BufferedImage(1, 1, 2);
        defaultTextureImage_d.setRGB(0, 0, -8355712);
        defaultTextureImage_n = new BufferedImage(1, 1, 2);
        defaultTextureImage_n.setRGB(0, 0, -8421378);
        defaultTextureImage_s = new BufferedImage(1, 1, 2);
        defaultTextureImage_s.setRGB(0, 0, -16777216);
        transparentImage = new BufferedImage(1, 1, 2);
        transparentImage.setRGB(0, 0, 0);
        defaultTextureIdArray = new int[3];
        Shaders.defaultTextureIdArray[0] = renderEngine.a(defaultTextureImage_d);
        Shaders.defaultTextureIdArray[1] = renderEngine.a(defaultTextureImage_n);
        Shaders.defaultTextureIdArray[2] = renderEngine.a(defaultTextureImage_s);
        textureIdMap.put(-1, defaultTextureIdArray);
        terrainTextureIdArray = defaultTextureIdArray;
        textureIdMap.put(0, terrainTextureIdArray);
        Shaders.checkOptifine();
        Shaders.loadConfig();
    }

    public static void bindNormalMap(int[] idArray) {
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)defaultTextureIdArray[1]);
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)defaultTextureIdArray[2]);
        GL13.glActiveTexture((int)33984);
    }

    public static void bindNormalMap(int textureId) {
        int[] idArray = (int[])textureIdMap.get(textureId);
        Shaders.bindNormalMap(idArray != null ? idArray : defaultTextureIdArray);
    }

    public static void bindTextures(int[] idArray) {
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)idArray[1]);
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)idArray[2]);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)idArray[0]);
    }

    public static void bindTextures(int textureId) {
        int[] idArray = (int[])textureIdMap.get(textureId);
        if (idArray != null) {
            Shaders.bindTextures(idArray);
        } else {
            Shaders.bindNormalMap(defaultTextureIdArray);
            GL11.glBindTexture((int)3553, (int)textureId);
        }
    }

    public static void enableVertexEnt(bgd tess) {
        if (entityAttrib >= 0) {
            ARBVertexProgram.glEnableVertexAttribArrayARB((int)entityAttrib);
            ARBVertexProgram.glVertexAttribPointerARB((int)entityAttrib, (int)2, (boolean)false, (boolean)false, (int)4, (ByteBuffer)((ByteBuffer)tess.shadersBuffer.position(0)));
        }
    }

    public static void disableVertexEnt() {
        if (entityAttrib >= 0) {
            ARBVertexProgram.glDisableVertexAttribArrayARB((int)entityAttrib);
        }
    }

    public static void beginRender(Minecraft minecraft, float f2, long l2) {
        if (isShadowPass) {
            return;
        }
        Shaders.checkGLError("pre beginRender");
        mc = minecraft;
        Shaders.mc.J.a("init");
        if (!isInitialized) {
            Shaders.init();
        }
        if (Shaders.mc.c != renderDisplayWidth || Shaders.mc.d != renderDisplayHeight) {
            Shaders.resize();
        }
        if ((diffWorldTime = ((worldTime = Shaders.mc.e.I()) - lastWorldTime) % 24000L) < 0L) {
            diffWorldTime += 24000L;
        }
        lastWorldTime = worldTime;
        rainStrength = minecraft.e.i(f2);
        float temp1 = (float)Math.exp(Math.log(0.5) * (double)diffWorldTime / (double)(wetness < rainStrength ? drynessHalfLife : wetnessHalfLife));
        wetness = wetness * temp1 + rainStrength * (1.0f - temp1);
        ng eye = Shaders.mc.h;
        eyePosY = (float)eye.v * f2 + (float)eye.V * (1.0f - f2);
        eyeBrightness = eye.b(f2);
        float eyeBrightnessHalfLife = 20.0f;
        float temp2 = (float)Math.exp(Math.log(0.5) * (double)diffWorldTime / (double)eyeBrightnessHalfLife);
        eyeBrightnessFadeX = eyeBrightnessFadeX * temp2 + (float)(eyeBrightness & 0xFFFF) * (1.0f - temp2);
        eyeBrightnessFadeY = eyeBrightnessFadeY * temp2 + (float)(eyeBrightness >> 16) * (1.0f - temp2);
        isEyeInWater = Shaders.mc.z.aa == 0 && !Shaders.mc.h.bz() && Shaders.mc.g.a(aif.h) ? 1 : 0;
        isRenderingWorld = true;
        isCompositeRendered = false;
        if (shadowPassInterval > 0 && --shadowPassCounter <= 0) {
            Shaders.mc.J.c("shadow pass");
            preShadowPassThirdPersonView = Shaders.mc.z.aa;
            Shaders.mc.z.aa = 1;
            isShadowPass = true;
            shadowPassCounter = shadowPassInterval;
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sfb);
            Shaders.useProgram(0);
            Shaders.mc.u.a(f2, l2);
            GL11.glFlush();
            isShadowPass = false;
            Shaders.mc.z.aa = preShadowPassThirdPersonView;
        }
        Shaders.mc.J.b();
        GL11.glViewport((int)0, (int)0, (int)renderWidth, (int)renderHeight);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
        Shaders.checkGLError("end beginRender");
    }

    public static void beginRenderPass(Minecraft minecraft, float f2, long l2) {
        if (isShadowPass) {
            return;
        }
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        isRenderingDfb = true;
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
        GL20.glDrawBuffers((int)0);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void setClearColor(float red, float green, float blue) {
        Shaders.clearColor[0] = red;
        Shaders.clearColor[1] = green;
        Shaders.clearColor[2] = blue;
        if (isShadowPass) {
            GL11.glClearColor((float)clearColor[0], (float)clearColor[1], (float)clearColor[2], (float)1.0f);
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbWaterDepthTexture, (int)0);
            GL11.glClear((int)256);
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbDepthTexture, (int)0);
            GL11.glClear((int)256);
            return;
        }
        GL20.glDrawBuffers((int)36064);
        GL11.glClearColor((float)clearColor[0], (float)clearColor[1], (float)clearColor[2], (float)1.0f);
        GL11.glClear((int)16640);
        GL20.glDrawBuffers((int)36065);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16640);
        for (int i2 = 2; i2 < usedColorBuffers; ++i2) {
            GL20.glDrawBuffers((int)(36064 + i2));
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16640);
        }
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
    }

    public static void setCamera(float f2) {
        ng viewEntity = Shaders.mc.h;
        double x2 = viewEntity.U + (viewEntity.u - viewEntity.U) * (double)f2;
        double y2 = viewEntity.V + (viewEntity.v - viewEntity.V) * (double)f2;
        double z2 = viewEntity.W + (viewEntity.w - viewEntity.W) * (double)f2;
        if (isShadowPass) {
            GL11.glViewport((int)0, (int)0, (int)shadowMapWidth, (int)shadowMapHeight);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            if (shadowMapIsOrtho) {
                GL11.glOrtho((double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)0.05f, (double)256.0);
            } else {
                GLU.gluPerspective((float)shadowMapFOV, (float)((float)shadowMapWidth / (float)shadowMapHeight), (float)0.05f, (float)256.0f);
            }
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float celestialAngle = Shaders.mc.e.c(f2);
            sunAngle = celestialAngle < 0.75f ? celestialAngle + 0.25f : celestialAngle - 0.75f;
            float angle = celestialAngle * -360.0f;
            if ((double)sunAngle <= 0.5) {
                GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                shadowAngle = sunAngle;
            } else {
                GL11.glRotatef((float)(angle + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                shadowAngle = sunAngle - 0.5f;
            }
            if (shadowMapIsOrtho) {
                GL11.glTranslatef((float)((float)x2 % 10.0f - 5.0f), (float)((float)y2 % 10.0f - 5.0f), (float)((float)z2 % 10.0f - 5.0f));
            }
            shadowProjection = BufferUtils.createFloatBuffer((int)16);
            GL11.glGetFloat((int)2983, (FloatBuffer)shadowProjection);
            shadowProjectionInverse = Shaders.invertMat4x(shadowProjection);
            shadowModelView = BufferUtils.createFloatBuffer((int)16);
            GL11.glGetFloat((int)2982, (FloatBuffer)shadowModelView);
            shadowModelViewInverse = Shaders.invertMat4x(shadowModelView);
            return;
        }
        FloatBuffer newprojection = previousProjection;
        newprojection.clear();
        previousProjection = projection;
        projection = newprojection;
        GL11.glGetFloat((int)2983, (FloatBuffer)projection);
        projectionInverse = Shaders.invertMat4x(projection);
        previousModelView = modelView;
        modelView = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        modelViewInverse = Shaders.invertMat4x(modelView);
        Shaders.previousCameraPosition[0] = cameraPosition[0];
        Shaders.previousCameraPosition[1] = cameraPosition[1];
        Shaders.previousCameraPosition[2] = cameraPosition[2];
        Shaders.cameraPosition[0] = x2;
        Shaders.cameraPosition[1] = y2;
        Shaders.cameraPosition[2] = z2;
    }

    public static void setCelestialPosition() {
        FloatBuffer modelView = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        float[] mv2 = new float[16];
        modelView.get(mv2, 0, 16);
        float[] sunPos = Shaders.multiplyMat4xVec4(mv2, new float[]{0.0f, 100.0f, 0.0f, 0.0f});
        sunPosition = sunPos;
        float[] moonPos = Shaders.multiplyMat4xVec4(mv2, new float[]{0.0f, -100.0f, 0.0f, 0.0f});
        moonPosition = moonPos;
    }

    private static float[] multiplyMat4xVec4(float[] ta2, float[] tb2) {
        float[] mout = new float[]{ta2[0] * tb2[0] + ta2[4] * tb2[1] + ta2[8] * tb2[2] + ta2[12] * tb2[3], ta2[1] * tb2[0] + ta2[5] * tb2[1] + ta2[9] * tb2[2] + ta2[13] * tb2[3], ta2[2] * tb2[0] + ta2[6] * tb2[1] + ta2[10] * tb2[2] + ta2[14] * tb2[3], ta2[3] * tb2[0] + ta2[7] * tb2[1] + ta2[11] * tb2[2] + ta2[15] * tb2[3]};
        return mout;
    }

    private static FloatBuffer invertMat4x(FloatBuffer matin) {
        int i2;
        float[] m2 = new float[16];
        float[] inv = new float[16];
        for (i2 = 0; i2 < 16; ++i2) {
            m2[i2] = matin.get(i2);
        }
        inv[0] = m2[5] * m2[10] * m2[15] - m2[5] * m2[11] * m2[14] - m2[9] * m2[6] * m2[15] + m2[9] * m2[7] * m2[14] + m2[13] * m2[6] * m2[11] - m2[13] * m2[7] * m2[10];
        inv[4] = -m2[4] * m2[10] * m2[15] + m2[4] * m2[11] * m2[14] + m2[8] * m2[6] * m2[15] - m2[8] * m2[7] * m2[14] - m2[12] * m2[6] * m2[11] + m2[12] * m2[7] * m2[10];
        inv[8] = m2[4] * m2[9] * m2[15] - m2[4] * m2[11] * m2[13] - m2[8] * m2[5] * m2[15] + m2[8] * m2[7] * m2[13] + m2[12] * m2[5] * m2[11] - m2[12] * m2[7] * m2[9];
        inv[12] = -m2[4] * m2[9] * m2[14] + m2[4] * m2[10] * m2[13] + m2[8] * m2[5] * m2[14] - m2[8] * m2[6] * m2[13] - m2[12] * m2[5] * m2[10] + m2[12] * m2[6] * m2[9];
        inv[1] = -m2[1] * m2[10] * m2[15] + m2[1] * m2[11] * m2[14] + m2[9] * m2[2] * m2[15] - m2[9] * m2[3] * m2[14] - m2[13] * m2[2] * m2[11] + m2[13] * m2[3] * m2[10];
        inv[5] = m2[0] * m2[10] * m2[15] - m2[0] * m2[11] * m2[14] - m2[8] * m2[2] * m2[15] + m2[8] * m2[3] * m2[14] + m2[12] * m2[2] * m2[11] - m2[12] * m2[3] * m2[10];
        inv[9] = -m2[0] * m2[9] * m2[15] + m2[0] * m2[11] * m2[13] + m2[8] * m2[1] * m2[15] - m2[8] * m2[3] * m2[13] - m2[12] * m2[1] * m2[11] + m2[12] * m2[3] * m2[9];
        inv[13] = m2[0] * m2[9] * m2[14] - m2[0] * m2[10] * m2[13] - m2[8] * m2[1] * m2[14] + m2[8] * m2[2] * m2[13] + m2[12] * m2[1] * m2[10] - m2[12] * m2[2] * m2[9];
        inv[2] = m2[1] * m2[6] * m2[15] - m2[1] * m2[7] * m2[14] - m2[5] * m2[2] * m2[15] + m2[5] * m2[3] * m2[14] + m2[13] * m2[2] * m2[7] - m2[13] * m2[3] * m2[6];
        inv[6] = -m2[0] * m2[6] * m2[15] + m2[0] * m2[7] * m2[14] + m2[4] * m2[2] * m2[15] - m2[4] * m2[3] * m2[14] - m2[12] * m2[2] * m2[7] + m2[12] * m2[3] * m2[6];
        inv[10] = m2[0] * m2[5] * m2[15] - m2[0] * m2[7] * m2[13] - m2[4] * m2[1] * m2[15] + m2[4] * m2[3] * m2[13] + m2[12] * m2[1] * m2[7] - m2[12] * m2[3] * m2[5];
        inv[14] = -m2[0] * m2[5] * m2[14] + m2[0] * m2[6] * m2[13] + m2[4] * m2[1] * m2[14] - m2[4] * m2[2] * m2[13] - m2[12] * m2[1] * m2[6] + m2[12] * m2[2] * m2[5];
        inv[3] = -m2[1] * m2[6] * m2[11] + m2[1] * m2[7] * m2[10] + m2[5] * m2[2] * m2[11] - m2[5] * m2[3] * m2[10] - m2[9] * m2[2] * m2[7] + m2[9] * m2[3] * m2[6];
        inv[7] = m2[0] * m2[6] * m2[11] - m2[0] * m2[7] * m2[10] - m2[4] * m2[2] * m2[11] + m2[4] * m2[3] * m2[10] + m2[8] * m2[2] * m2[7] - m2[8] * m2[3] * m2[6];
        inv[11] = -m2[0] * m2[5] * m2[11] + m2[0] * m2[7] * m2[9] + m2[4] * m2[1] * m2[11] - m2[4] * m2[3] * m2[9] - m2[8] * m2[1] * m2[7] + m2[8] * m2[3] * m2[5];
        inv[15] = m2[0] * m2[5] * m2[10] - m2[0] * m2[6] * m2[9] - m2[4] * m2[1] * m2[10] + m2[4] * m2[2] * m2[9] + m2[8] * m2[1] * m2[6] - m2[8] * m2[2] * m2[5];
        float det = m2[0] * inv[0] + m2[1] * inv[4] + m2[2] * inv[8] + m2[3] * inv[12];
        FloatBuffer invout = BufferUtils.createFloatBuffer((int)16);
        if ((double)det == 0.0) {
            return invout;
        }
        for (i2 = 0; i2 < 16; ++i2) {
            invout.put(i2, inv[i2] / det);
        }
        return invout;
    }

    public static void drawComposite() {
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(0));
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(1));
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(2));
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(3));
        if (usedColorBuffers >= 5) {
            GL13.glActiveTexture((int)33991);
            GL11.glBindTexture((int)3553, (int)dfbTextures.get(4));
            if (usedColorBuffers >= 6) {
                GL13.glActiveTexture((int)33992);
                GL11.glBindTexture((int)3553, (int)dfbTextures.get(5));
                if (usedColorBuffers >= 7) {
                    GL13.glActiveTexture((int)33993);
                    GL11.glBindTexture((int)3553, (int)dfbTextures.get(6));
                    if (usedColorBuffers >= 8) {
                        GL13.glActiveTexture((int)33994);
                        GL11.glBindTexture((int)3553, (int)dfbTextures.get(7));
                    }
                }
            }
        }
        if (shadowPassInterval > 0) {
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)sfbDepthTexture);
            GL13.glActiveTexture((int)33989);
            GL11.glBindTexture((int)3553, (int)sfbWaterDepthTexture);
        }
        GL13.glActiveTexture((int)33990);
        GL11.glBindTexture((int)3553, (int)dfbDepthTexture);
        GL13.glActiveTexture((int)33984);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
    }

    public static void renderCompositeFinal() {
        if (isShadowPass) {
            Shaders.useProgram(0);
            return;
        }
        Shaders.checkGLError("pre-renderCompositeFinal");
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)519);
        GL11.glDepthMask((boolean)false);
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
        Shaders.checkGLError("pre-composite");
        for (int i2 = 0; i2 < 8; ++i2) {
            if (programs[11 + i2] == 0) continue;
            Shaders.useProgram(11 + i2);
            Shaders.checkGLError(programNames[11 + i2]);
            Shaders.drawComposite();
        }
        isRenderingDfb = false;
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        GL11.glViewport((int)0, (int)0, (int)Shaders.mc.c, (int)Shaders.mc.d);
        if (bfq.a) {
            boolean maskR = bfq.b != 0;
            GL11.glColorMask((boolean)maskR, (!maskR ? 1 : 0) != 0, (!maskR ? 1 : 0) != 0, (boolean)true);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glClearColor((float)clearColor[0], (float)clearColor[1], (float)clearColor[2], (float)1.0f);
        GL11.glClear((int)16640);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)519);
        GL11.glDepthMask((boolean)false);
        Shaders.checkGLError("pre-final");
        Shaders.useProgram(19);
        Shaders.checkGLError("final");
        Shaders.drawComposite();
        Shaders.checkGLError("renderCompositeFinal");
        isCompositeRendered = true;
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glDepthFunc((int)515);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        Shaders.useProgram(0);
    }

    public static void endRender() {
        if (isShadowPass) {
            Shaders.useProgram(0);
            return;
        }
        if (!isCompositeRendered) {
            Shaders.renderCompositeFinal();
        }
        isRenderingWorld = false;
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glEnable((int)3042);
        Shaders.useProgram(0);
        Shaders.checkGLError("endRender end");
    }

    public static void beginSky() {
        isRenderingSky = true;
        Shaders.useProgram(5);
        bgd.a.setEntity(-2, 0);
    }

    public static void endSky() {
        isRenderingSky = false;
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
        bgd.a.setEntity(-1, 0);
    }

    public static void beginTerrain() {
        if (isRenderingWorld) {
            Shaders.useProgram(6);
            Shaders.bindNormalMap(terrainTextureIdArray);
        }
    }

    public static void endTerrain() {
        if (isRenderingWorld) {
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void beginBlockDestroyProgress() {
        if (isRenderingWorld) {
            Shaders.useProgram(6);
        }
    }

    public static void endBlockDestroyProgress() {
        if (isRenderingWorld) {
            Shaders.useProgram(3);
        }
    }

    public static void beginEntities() {
        if (isRenderingWorld) {
            Shaders.useProgram(7);
            if (programs[activeProgram] != 0) {
                uniformEntityHurt = ARBShaderObjects.glGetUniformLocationARB((int)programs[activeProgram], (CharSequence)"entityHurt");
                uniformEntityFlash = ARBShaderObjects.glGetUniformLocationARB((int)programs[activeProgram], (CharSequence)"entityFlash");
                useEntityHurtFlash = uniformEntityHurt != -1 || uniformEntityFlash != -1;
                ARBShaderObjects.glUniform1iARB((int)uniformEntityHurt, (int)0);
                ARBShaderObjects.glUniform1iARB((int)uniformEntityFlash, (int)0);
            } else {
                useEntityHurtFlash = false;
            }
        }
    }

    public static void endEntities() {
        if (isRenderingWorld) {
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void setEntityHurtFlash(int hurt, int flash) {
        if (isRenderingWorld) {
            ARBShaderObjects.glUniform1iARB((int)uniformEntityHurt, (int)hurt);
            ARBShaderObjects.glUniform1iARB((int)uniformEntityFlash, (int)(flash >> 24));
        }
    }

    public static void beginLivingDamage() {
        if (isRenderingWorld) {
            Shaders.bindTextures(defaultTextureIdArray);
            if (!isShadowPass) {
                // empty if block
            }
        }
    }

    public static void endLivingDamage() {
        if (!isRenderingWorld || !isShadowPass) {
            // empty if block
        }
    }

    public static void beginLitParticles() {
        bgd.a.b(0.0f, 0.0f, 0.0f);
        Shaders.useProgram(3);
    }

    public static void beginParticles() {
        bgd.a.b(0.0f, 0.0f, 0.0f);
        Shaders.useProgram(3);
    }

    public static void endParticles() {
        bgd.a.b(0.0f, 0.0f, 0.0f);
        Shaders.useProgram(3);
    }

    public static void beginWater() {
        if (isRenderingWorld) {
            Shaders.useProgram(9);
            Shaders.bindNormalMap(terrainTextureIdArray);
            if (isShadowPass) {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbWaterDepthTexture, (int)0);
            }
        }
    }

    public static void endWater() {
        if (isRenderingWorld) {
            if (isShadowPass) {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbDepthTexture, (int)0);
            }
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void beginWeather() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        Shaders.useProgram(10);
    }

    public static void endWeather() {
        GL11.glDisable((int)3042);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void beginHand() {
        Shaders.useProgram(8);
    }

    public static void endHand() {
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void beginFPOverlay() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public static void endFPOverlay() {
        GL11.glDisable((int)3042);
    }

    public static void glEnableWrapper(int cap) {
        if (cap == 3553) {
            Shaders.sglEnableT2D(cap);
        } else if (cap == 2912) {
            Shaders.sglEnableFog(cap);
        } else {
            GL11.glEnable((int)cap);
        }
    }

    public static void glDisableWrapper(int cap) {
        if (cap == 3553) {
            Shaders.sglDisableT2D(cap);
        } else if (cap == 2912) {
            Shaders.sglDisableFog(cap);
        } else {
            GL11.glDisable((int)cap);
        }
    }

    public static void sglEnableT2D(int cap) {
        GL11.glEnable((int)cap);
        if (isRenderingSky) {
            Shaders.useProgram(5);
        } else if (activeProgram == 1) {
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void sglDisableT2D(int cap) {
        GL11.glDisable((int)cap);
        if (isRenderingSky) {
            Shaders.useProgram(4);
        } else if (activeProgram == 2 || activeProgram == 3) {
            Shaders.useProgram(1);
        }
    }

    public static void sglEnableFog(int cap) {
        GL11.glEnable((int)cap);
        fogEnabled = true;
        if (programs[activeProgram] != 0) {
            Shaders.setProgramUniform1i("fogMode", GL11.glGetInteger((int)2917));
        }
    }

    public static void sglDisableFog(int cap) {
        GL11.glDisable((int)cap);
        fogEnabled = false;
        if (programs[activeProgram] != 0) {
            Shaders.setProgramUniform1i("fogMode", 0);
        }
    }

    public static void enableLightmap() {
        lightmapEnabled = true;
        if (activeProgram == 2) {
            Shaders.useProgram(3);
        }
    }

    public static void disableLightmap() {
        lightmapEnabled = false;
        if (activeProgram == 3) {
            Shaders.useProgram(2);
        }
    }

    private static int setupProgram(int iprogram, String vShaderPath, String fShaderPath) {
        int program = ARBShaderObjects.glCreateProgramObjectARB();
        if (program != 0) {
            int vShader = Shaders.createVertShader(vShaderPath);
            int fShader = Shaders.createFragShader(fShaderPath);
            if (vShader != 0 || fShader != 0) {
                if (vShader != 0) {
                    ARBShaderObjects.glAttachObjectARB((int)program, (int)vShader);
                }
                if (fShader != 0) {
                    ARBShaderObjects.glAttachObjectARB((int)program, (int)fShader);
                }
                if (entityAttrib >= 0) {
                    ARBVertexShader.glBindAttribLocationARB((int)program, (int)entityAttrib, (CharSequence)"mc_Entity");
                }
                ARBShaderObjects.glLinkProgramARB((int)program);
                if (vShader != 0) {
                    ARBShaderObjects.glDetachObjectARB((int)program, (int)vShader);
                    ARBShaderObjects.glDeleteObjectARB((int)vShader);
                }
                if (fShader != 0) {
                    ARBShaderObjects.glDetachObjectARB((int)program, (int)fShader);
                    ARBShaderObjects.glDeleteObjectARB((int)fShader);
                }
                ARBShaderObjects.glValidateProgramARB((int)program);
                Shaders.printLogInfo(program, vShaderPath + "," + fShaderPath);
                int valid = GL20.glGetProgram((int)program, (int)35715);
                if (valid == 1) {
                    System.out.println("Program " + programNames[iprogram] + " loaded");
                } else {
                    Shaders.printChatAndLogError("[Shaders] Error : Invalid program " + programNames[iprogram]);
                    ARBShaderObjects.glDeleteObjectARB((int)program);
                    program = 0;
                }
            } else {
                ARBShaderObjects.glDeleteObjectARB((int)program);
                program = 0;
            }
        }
        return program;
    }

    private static int createVertShader(String filename) {
        BufferedReader reader;
        int vertShader = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
        if (vertShader == 0) {
            return 0;
        }
        String vertexCode = "";
        try {
            reader = new BufferedReader(new InputStreamReader(shaderPack.getResourceAsStream(filename)));
        }
        catch (Exception e2) {
            try {
                reader = new BufferedReader(new FileReader(new File(filename)));
            }
            catch (Exception e22) {
                System.out.println("Couldn't open " + filename);
                ARBShaderObjects.glDeleteObjectARB((int)vertShader);
                return 0;
            }
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                vertexCode = vertexCode + line + "\n";
                if (!line.matches("attribute [_a-zA-Z0-9]+ mc_Entity.*")) continue;
                entityAttrib = 10;
            }
        }
        catch (Exception e3) {
            System.out.println("Couldn't read " + filename + "!");
            ARBShaderObjects.glDeleteObjectARB((int)vertShader);
            return 0;
        }
        try {
            reader.close();
        }
        catch (Exception e4) {
            System.out.println("Couldn't close " + filename + "!");
        }
        ARBShaderObjects.glShaderSourceARB((int)vertShader, (CharSequence)vertexCode);
        ARBShaderObjects.glCompileShaderARB((int)vertShader);
        Shaders.printLogInfo(vertShader, filename);
        return vertShader;
    }

    private static int createFragShader(String filename) {
        BufferedReader reader;
        int fragShader = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
        if (fragShader == 0) {
            return 0;
        }
        StringBuilder fragCode = new StringBuilder(0x100000);
        try {
            reader = new BufferedReader(new InputStreamReader(shaderPack.getResourceAsStream(filename)));
        }
        catch (Exception e2) {
            try {
                reader = new BufferedReader(new FileReader(new File(filename)));
            }
            catch (Exception e22) {
                System.out.println("Couldn't open " + filename);
                ARBShaderObjects.glDeleteObjectARB((int)fragShader);
                return 0;
            }
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                fragCode.append(line).append('\n');
                if (line.matches("#version .*")) continue;
                if (line.matches("uniform [ _a-zA-Z0-9]+ shadow;.*")) {
                    shadowPassInterval = 1;
                    shouldSkipDefaultShadow = true;
                    continue;
                }
                if (line.matches("uniform [ _a-zA-Z0-9]+ gdepth;.*")) {
                    gbufferFormat_gdepth = 34837;
                    continue;
                }
                if (usedColorBuffers < 5 && line.matches("uniform [ _a-zA-Z0-9]+ gaux1;.*")) {
                    usedColorBuffers = 5;
                    continue;
                }
                if (usedColorBuffers < 6 && line.matches("uniform [ _a-zA-Z0-9]+ gaux2;.*")) {
                    usedColorBuffers = 6;
                    continue;
                }
                if (usedColorBuffers < 7 && line.matches("uniform [ _a-zA-Z0-9]+ gaux3;.*")) {
                    usedColorBuffers = 7;
                    continue;
                }
                if (usedColorBuffers < 8 && line.matches("uniform [ _a-zA-Z0-9]+ gaux4;.*")) {
                    usedColorBuffers = 8;
                    continue;
                }
                if (usedColorBuffers < 5 && line.matches("uniform [ _a-zA-Z0-9]+ colortex4;.*")) {
                    usedColorBuffers = 5;
                    continue;
                }
                if (usedColorBuffers < 6 && line.matches("uniform [ _a-zA-Z0-9]+ colortex5;.*")) {
                    usedColorBuffers = 6;
                    continue;
                }
                if (usedColorBuffers < 7 && line.matches("uniform [ _a-zA-Z0-9]+ colortex6;.*")) {
                    usedColorBuffers = 7;
                    continue;
                }
                if (usedColorBuffers < 8 && line.matches("uniform [ _a-zA-Z0-9]+ colortex7;.*")) {
                    usedColorBuffers = 8;
                    continue;
                }
                if (line.matches("/\\* SHADOWRES:[0-9]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Shadow map resolution: " + parts[2]);
                    shadowMapWidth = shadowMapHeight = Integer.parseInt(parts[2]);
                    continue;
                }
                if (line.matches("/\\* SHADOWFOV:[0-9\\.]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Shadow map field of view: " + parts[2]);
                    shadowMapFOV = Float.parseFloat(parts[2]);
                    shadowMapIsOrtho = false;
                    continue;
                }
                if (line.matches("/\\* SHADOWHPL:[0-9\\.]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Shadow map half-plane: " + parts[2]);
                    shadowMapHalfPlane = Float.parseFloat(parts[2]);
                    shadowMapIsOrtho = true;
                    continue;
                }
                if (line.matches("/\\* WETNESSHL:[0-9\\.]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Wetness halflife: " + parts[2]);
                    wetnessHalfLife = Float.parseFloat(parts[2]);
                    continue;
                }
                if (line.matches("/\\* DRYNESSHL:[0-9\\.]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Dryness halflife: " + parts[2]);
                    drynessHalfLife = Float.parseFloat(parts[2]);
                    continue;
                }
                if (line.matches("/\\* GNORMALFORMAT:RGBA32F \\*/.*")) {
                    System.out.println("gnormal format : RGB32AF");
                    gbufferFormat_gnormal = 34836;
                    continue;
                }
                if (line.matches("/\\* GNORMALFORMAT:RGB32F \\*/.*")) {
                    System.out.println("gnormal format : RGB32F");
                    gbufferFormat_gnormal = 34837;
                    continue;
                }
                if (line.matches("/\\* GAUX4FORMAT:RGBA32F \\*/.*")) {
                    System.out.println("gaux4 format : RGB32AF");
                    gbufferFormat_gaux4 = 34836;
                    continue;
                }
                if (line.matches("/\\* GAUX4FORMAT:RGB32F \\*/.*")) {
                    System.out.println("gaux4 format : RGB32F");
                    gbufferFormat_gaux4 = 34837;
                    continue;
                }
                if (!line.matches("/\\* DRAWBUFFERS:[0-7N]* \\*/.*")) continue;
                parts = line.split("(:| )", 4);
                newDrawBufSetting = parts[2];
            }
        }
        catch (Exception e3) {
            System.out.println("Couldn't read " + filename + "!");
            ARBShaderObjects.glDeleteObjectARB((int)fragShader);
            return 0;
        }
        try {
            reader.close();
        }
        catch (Exception e4) {
            System.out.println("Couldn't close " + filename + "!");
        }
        ARBShaderObjects.glShaderSourceARB((int)fragShader, (CharSequence)fragCode);
        ARBShaderObjects.glCompileShaderARB((int)fragShader);
        Shaders.printLogInfo(fragShader, filename);
        return fragShader;
    }

    private static boolean printLogInfo(int obj, String name) {
        IntBuffer iVal = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)obj, (int)35716, (IntBuffer)iVal);
        int length = iVal.get();
        if (length > 1) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer((int)length);
            iVal.flip();
            ARBShaderObjects.glGetInfoLogARB((int)obj, (IntBuffer)iVal, (ByteBuffer)infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            if (infoBytes[length - 1] == 0) {
                infoBytes[length - 1] = 10;
            }
            String out = new String(infoBytes);
            System.out.println("Info log: " + name + "\n" + out);
            return false;
        }
        return true;
    }

    public static void useProgram(int program) {
        Shaders.checkGLError("pre-useProgram");
        if (activeProgram == program) {
            return;
        }
        if (isShadowPass) {
            activeProgram = 0;
            ARBShaderObjects.glUseProgramObjectARB((int)0);
            normalMapEnabled = false;
            return;
        }
        activeProgram = program;
        ARBShaderObjects.glUseProgramObjectARB((int)programs[program]);
        if (programs[program] == 0) {
            normalMapEnabled = false;
            return;
        }
        if (Shaders.checkGLError("useProgram ", programNames[program]) != 0) {
            Shaders.programs[program] = 0;
        }
        IntBuffer drawBuffers = programsDrawBuffers[program];
        if (isRenderingDfb && activeDrawBuffers != drawBuffers) {
            activeDrawBuffers = drawBuffers;
            GL20.glDrawBuffers((IntBuffer)drawBuffers);
            Shaders.checkGLError(programNames[program] + " draw buffers = " + programsDrawBufSettings[program]);
        }
        switch (program) {
            case 2: {
                normalMapEnabled = false;
                Shaders.setProgramUniform1i("texture", 0);
                Shaders.setProgramUniform1i("shadow", 8);
                Shaders.setProgramUniform1i("watershadow", 9);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                normalMapEnabled = true;
                Shaders.setProgramUniform1i("texture", 0);
                Shaders.setProgramUniform1i("lightmap", 1);
                Shaders.setProgramUniform1i("normals", 2);
                Shaders.setProgramUniform1i("specular", 3);
                Shaders.setProgramUniform1i("shadow", 8);
                Shaders.setProgramUniform1i("watershadow", 9);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                normalMapEnabled = false;
                Shaders.setProgramUniform1i("gcolor", 0);
                Shaders.setProgramUniform1i("gdepth", 1);
                Shaders.setProgramUniform1i("gnormal", 2);
                Shaders.setProgramUniform1i("composite", 3);
                Shaders.setProgramUniform1i("gaux1", 7);
                Shaders.setProgramUniform1i("gaux2", 8);
                Shaders.setProgramUniform1i("gaux3", 9);
                Shaders.setProgramUniform1i("gaux4", 10);
                Shaders.setProgramUniform1i("colortex0", 0);
                Shaders.setProgramUniform1i("colortex1", 1);
                Shaders.setProgramUniform1i("colortex2", 2);
                Shaders.setProgramUniform1i("colortex3", 3);
                Shaders.setProgramUniform1i("colortex4", 7);
                Shaders.setProgramUniform1i("colortex5", 8);
                Shaders.setProgramUniform1i("colortex6", 9);
                Shaders.setProgramUniform1i("colortex7", 10);
                Shaders.setProgramUniform1i("shadow", 4);
                Shaders.setProgramUniform1i("watershadow", 5);
                Shaders.setProgramUniform1i("gdepthtex", 6);
                Shaders.setProgramUniform1i("depthtex0", 6);
                Shaders.setProgramUniformMatrix4ARB("gbufferPreviousProjection", false, previousProjection);
                Shaders.setProgramUniformMatrix4ARB("gbufferProjection", false, projection);
                Shaders.setProgramUniformMatrix4ARB("gbufferProjectionInverse", false, projectionInverse);
                Shaders.setProgramUniformMatrix4ARB("gbufferPreviousModelView", false, previousModelView);
                if (shadowPassInterval <= 0) break;
                Shaders.setProgramUniformMatrix4ARB("shadowProjection", false, shadowProjection);
                Shaders.setProgramUniformMatrix4ARB("shadowProjectionInverse", false, shadowProjectionInverse);
                Shaders.setProgramUniformMatrix4ARB("shadowModelView", false, shadowModelView);
                Shaders.setProgramUniformMatrix4ARB("shadowModelViewInverse", false, shadowModelViewInverse);
                break;
            }
            default: {
                normalMapEnabled = false;
            }
        }
        wm stack = Shaders.mc.g.bK.h();
        Shaders.setProgramUniform1i("heldItemId", stack == null ? -1 : stack.c);
        Shaders.setProgramUniform1i("heldBlockLightValue", stack == null || stack.c >= 256 ? 0 : apa.v[stack.c]);
        Shaders.setProgramUniform1i("fogMode", fogEnabled ? GL11.glGetInteger((int)2917) : 0);
        Shaders.setProgramUniform1i("worldTime", (int)worldTime % 24000);
        Shaders.setProgramUniform1f("sunAngle", sunAngle);
        Shaders.setProgramUniform1f("shadowAngle", shadowAngle);
        Shaders.setProgramUniform1f("rainStrength", rainStrength);
        Shaders.setProgramUniform1f("aspectRatio", (float)renderWidth / (float)renderHeight);
        Shaders.setProgramUniform1f("viewWidth", renderWidth);
        Shaders.setProgramUniform1f("viewHeight", renderHeight);
        Shaders.setProgramUniform1f("near", 0.05f);
        Shaders.setProgramUniform1f("far", 32 << 3 - Shaders.mc.z.e);
        Shaders.setProgramUniform3f("sunPosition", sunPosition[0], sunPosition[1], sunPosition[2]);
        Shaders.setProgramUniform3f("moonPosition", moonPosition[0], moonPosition[1], moonPosition[2]);
        Shaders.setProgramUniform3f("previousCameraPosition", (float)previousCameraPosition[0], (float)previousCameraPosition[1], (float)previousCameraPosition[2]);
        Shaders.setProgramUniform3f("cameraPosition", (float)cameraPosition[0], (float)cameraPosition[1], (float)cameraPosition[2]);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelView", false, modelView);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelViewInverse", false, modelViewInverse);
        Shaders.setProgramUniform1f("wetness", wetness);
        Shaders.setProgramUniform1f("eyeAltitude", eyePosY);
        Shaders.setProgramUniform2i("eyeBrightness", eyeBrightness & 0xFFFF, eyeBrightness >> 16);
        Shaders.setProgramUniform2i("eyeBrightnessSmooth", Math.round(eyeBrightnessFadeX), Math.round(eyeBrightnessFadeY));
        Shaders.setProgramUniform1i("isEyeInWater", isEyeInWater);
        Shaders.setProgramUniform1i("hideGUI", Shaders.mc.z.Z ? 1 : 0);
        Shaders.checkGLError("useProgram ", programNames[program]);
    }

    public static void setProgramUniform1i(String name, int x2) {
        int gp2 = programs[activeProgram];
        if (gp2 != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp2, (CharSequence)name);
            ARBShaderObjects.glUniform1iARB((int)uniform, (int)x2);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniform2i(String name, int x2, int y2) {
        int gp2 = programs[activeProgram];
        if (gp2 != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp2, (CharSequence)name);
            ARBShaderObjects.glUniform2iARB((int)uniform, (int)x2, (int)y2);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniform1f(String name, float x2) {
        int gp2 = programs[activeProgram];
        if (gp2 != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp2, (CharSequence)name);
            ARBShaderObjects.glUniform1fARB((int)uniform, (float)x2);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniform3f(String name, float x2, float y2, float z2) {
        int gp2 = programs[activeProgram];
        if (gp2 != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp2, (CharSequence)name);
            ARBShaderObjects.glUniform3fARB((int)uniform, (float)x2, (float)y2, (float)z2);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniformMatrix4ARB(String name, boolean transpose, FloatBuffer matrix) {
        int gp2 = programs[activeProgram];
        if (gp2 != 0 && matrix != null) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp2, (CharSequence)name);
            ARBShaderObjects.glUniformMatrix4ARB((int)uniform, (boolean)transpose, (FloatBuffer)matrix);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    static {
        uniformEntityHurt = -1;
        uniformEntityFlash = -1;
        previousProjection = BufferUtils.createFloatBuffer((int)16);
        projection = BufferUtils.createFloatBuffer((int)16);
        projectionInverse = null;
        previousModelView = null;
        modelView = null;
        modelViewInverse = null;
        previousCameraPosition = new double[3];
        cameraPosition = new double[3];
        shadowPassInterval = 0;
        shadowMapWidth = 4096;
        shadowMapHeight = 4096;
        shadowMapFOV = 90.0f;
        shadowMapHalfPlane = 160.0f;
        shadowMapIsOrtho = true;
        gbufferFormat_gdepth = 6408;
        gbufferFormat_gaux4 = 6408;
        gbufferFormat_gnormal = 6408;
        shadowPassCounter = 0;
        shouldSkipDefaultShadow = false;
        sfb = 0;
        sfbColorTexture = 0;
        sfbDepthTexture = 0;
        sfbWaterDepthTexture = 0;
        sfbRenderBuffer = 0;
        sfbDepthBuffer = 0;
        shadowProjection = null;
        shadowProjectionInverse = null;
        shadowModelView = null;
        shadowModelViewInverse = null;
        usedColorBuffers = 0;
        usedColorAttachs = 0;
        usedDrawBuffers = 0;
        dfbDrawBuffers = null;
        dfbTextures = null;
        drawBuffersLast = null;
        drawBuffersAll = null;
        drawBuffersClear0 = null;
        drawBuffersClear1 = null;
        drawBuffersClearColor = null;
        dfb = 0;
        dfbDepthTexture = 0;
        activeProgram = 0;
        programNames = new String[]{"", "gbuffers_basic", "gbuffers_textured", "gbuffers_textured_lit", "gbuffers_skybasic", "gbuffers_skytextured", "gbuffers_terrain", "gbuffers_entities", "gbuffers_hand", "gbuffers_water", "gbuffers_weather", "composite", "composite1", "composite2", "composite3", "composite4", "composite5", "composite6", "composite7", "final"};
        programBackups = new int[]{0, 0, 1, 2, 1, 2, 3, 3, 3, 6, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        programs = new int[20];
        programsRef = new int[20];
        newDrawBufSetting = null;
        programsDrawBufSettings = new String[20];
        programsDrawBuffers = new IntBuffer[20];
        activeDrawBuffers = null;
        newColorAtmSetting = null;
        programsColorAtmSettings = new String[20];
        activeColorAtmSettings = null;
        loadedShaders = null;
        shadersConfig = null;
        renderEngine = null;
        textureIdMap = new HashMap();
        textureIdByNameMap = new HashMap();
        textureIdByUrlMap = new HashMap();
        defaultTextureImageMap = new HashMap();
        defaultTextureImage_d = null;
        defaultTextureImage_n = null;
        defaultTextureImage_s = null;
        transparentImage = null;
        defaultTextureIdArray = null;
        terrainTextureIdArray = null;
        normalMapEnabled = false;
        tempDirectByteBuffer = null;
        tempDirectIntBuffer = null;
        dtweak = false;
        configCloudShadow = true;
        configHandDepthMul = 0.125f;
        shaderPack = null;
        packNameNone = "(none)";
        packNameDefault = "(internal)";
        shaderpacksdirname = "shaderpacks";
        optionsfilename = "optionsshaders.txt";
        shadersdir = new File(Minecraft.b(), "shaders");
        shaderpacksdir = new File(Minecraft.b(), shaderpacksdirname);
        configFile = new File(Minecraft.b(), optionsfilename);
    }
}

