/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.io.File;
import java.io.PrintWriter;
import java.util.Scanner;
import org.lwjgl.input.Keyboard;
import reifnsk.minimap.ReiMinimap;

public enum KeyInput {
    \u4e3b\u83dc\u5355\u70ed\u952e(50),
    \u5f00\u5173\u5c0f\u5730\u56fe(0),
    \u5207\u6362\u96f7\u8fbe\u7c7b\u578b(0),
    \u8c03\u6574\u7f29\u653e\u5927\u5c0f(44),
    \u5f00\u5173\u5927\u5730\u56fe(45),
    \u5f00\u5173\u5927\u5730\u56fe\u6807\u8bc6(0),
    \u5f00\u5173\u6807\u8bc6\u53ef\u89c1(0),
    \u5f00\u5173\u6807\u8bc6\u540d\u79f0(0),
    \u8c03\u6574\u6807\u8bc6\u7ef4\u5ea6(0),
    \u5f00\u5173\u5b9e\u4f53\u96f7\u8fbe(0),
    \u6dfb\u52a0\u6807\u8bc6(46),
    \u6253\u5f00\u6807\u8bc6\u5217\u8868(0),
    \u653e\u5927\u5730\u56fe(0),
    \u7f29\u5c0f\u5730\u56fe(0);

    private static File configFile;
    private final int defaultKeyIndex;
    private String label;
    private int keyIndex;
    private boolean keyDown;
    private boolean oldKeyDown;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private KeyInput() {
        void keyIndex;
        this.defaultKeyIndex = keyIndex;
        this.keyIndex = keyIndex;
        this.label = ReiMinimap.capitalize(this.name());
    }

    /*
     * WARNING - void declaration
     */
    private KeyInput() {
        void keyIndex;
        void label;
        this.label = label;
        this.defaultKeyIndex = keyIndex;
        this.keyIndex = keyIndex;
    }

    public void setKey(int keyIndex) {
        if (keyIndex == 1) {
            keyIndex = 0;
        }
        if (keyIndex == 0 && this == \u4e3b\u83dc\u5355\u70ed\u952e) {
            return;
        }
        if (keyIndex != 0) {
            for (KeyInput temp : KeyInput.values()) {
                if (temp.keyIndex != keyIndex) continue;
                if (temp == \u4e3b\u83dc\u5355\u70ed\u952e && this.keyIndex == 0) {
                    return;
                }
                temp.keyIndex = this.keyIndex;
                temp.keyDown = false;
                temp.oldKeyDown = false;
                break;
            }
        }
        this.keyIndex = keyIndex;
        this.keyDown = false;
        this.oldKeyDown = false;
    }

    public int getKey() {
        return this.keyIndex;
    }

    public String label() {
        return this.label;
    }

    public String getKeyName() {
        String keyName = Keyboard.getKeyName((int)this.keyIndex);
        return keyName == null ? String.format("#%02X", this.keyIndex) : ReiMinimap.capitalize(keyName);
    }

    public void setKey(String keyName) {
        int key = Keyboard.getKeyIndex((String)keyName);
        if (keyName.startsWith("#")) {
            try {
                key = Integer.parseInt(keyName.substring(1), 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setKey(key);
    }

    public boolean isKeyDown() {
        return this.keyDown;
    }

    public boolean isKeyPush() {
        return this.keyDown && !this.oldKeyDown;
    }

    public boolean isKeyPushUp() {
        return !this.keyDown && this.oldKeyDown;
    }

    public static void update() {
        for (KeyInput input : KeyInput.values()) {
            input.oldKeyDown = input.keyDown;
            input.keyDown = input.keyIndex != 0 && Keyboard.isKeyDown((int)input.keyIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveKeyConfig() {
        PrintWriter out = null;
        try {
            out = new PrintWriter(configFile);
            for (KeyInput key : KeyInput.values()) {
                out.println(key.toString());
            }
        }
        catch (Exception e2) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadKeyConfig() {
        Scanner in = null;
        try {
            in = new Scanner(configFile);
            while (in.hasNextLine()) {
                try {
                    String[] strs = in.nextLine().split(":");
                    KeyInput.valueOf(ReiMinimap.toUpperCase(strs[0].trim())).setKey(ReiMinimap.toUpperCase(strs[1].trim()));
                }
                catch (Exception e2) {}
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void setDefault() {
        this.keyIndex = this.defaultKeyIndex;
    }

    public boolean isDefault() {
        return this.keyIndex == this.defaultKeyIndex;
    }

    public String toString() {
        return ReiMinimap.capitalize(this.name()) + ": " + this.getKeyName();
    }

    static {
        configFile = new File(ReiMinimap.directory, "keyconfig.txt");
        KeyInput.loadKeyConfig();
        KeyInput.saveKeyConfig();
    }
}

