/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import cpw.mods.fml.relauncher.ArgsWrapper;
import cpw.mods.fml.relauncher.Downloader;
import cpw.mods.fml.relauncher.DummyDownloader;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.RelaunchClassLoader;
import cpw.mods.fml.relauncher.RelaunchLibraryManager;
import java.applet.Applet;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class FMLRelauncher {
    private static FMLRelauncher INSTANCE;
    public static String logFileNamePattern;
    private static String side;
    private RelaunchClassLoader classLoader;
    private Object newApplet;
    private Class<? super Object> appletClass;
    JDialog popupWindow;

    public static void handleClientRelaunch(ArgsWrapper wrap) {
        logFileNamePattern = "ForgeModLoader-client-%g.log";
        side = "CLIENT";
        FMLRelauncher.instance().relaunchClient(wrap);
    }

    public static void handleServerRelaunch(ArgsWrapper wrap) {
        logFileNamePattern = "ForgeModLoader-server-%g.log";
        side = "SERVER";
        FMLRelauncher.instance().relaunchServer(wrap);
    }

    static FMLRelauncher instance() {
        if (INSTANCE == null) {
            INSTANCE = new FMLRelauncher();
        }
        return INSTANCE;
    }

    private FMLRelauncher() {
        URLClassLoader ucl = (URLClassLoader)this.getClass().getClassLoader();
        this.classLoader = new RelaunchClassLoader(ucl.getURLs());
    }

    private void showWindow(boolean showIt) {
        if (RelaunchLibraryManager.downloadMonitor != null) {
            return;
        }
        try {
            if (showIt) {
                RelaunchLibraryManager.downloadMonitor = new Downloader();
                this.popupWindow = (JDialog)RelaunchLibraryManager.downloadMonitor.makeDialog();
            } else {
                RelaunchLibraryManager.downloadMonitor = new DummyDownloader();
            }
        }
        catch (Throwable e2) {
            if (RelaunchLibraryManager.downloadMonitor == null) {
                RelaunchLibraryManager.downloadMonitor = new DummyDownloader();
                e2.printStackTrace();
            } else {
                RelaunchLibraryManager.downloadMonitor.makeHeadless();
            }
            this.popupWindow = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relaunchClient(ArgsWrapper wrap) {
        Class<? super Object> client;
        this.showWindow(true);
        try {
            File minecraftHome = this.computeExistingClientHome();
            this.setupHome(minecraftHome);
            client = this.setupNewClientHome(minecraftHome);
        }
        finally {
            if (this.popupWindow != null) {
                this.popupWindow.setVisible(false);
                this.popupWindow.dispose();
            }
        }
        if (RelaunchLibraryManager.downloadMonitor.shouldStopIt()) {
            System.exit(1);
        }
        try {
            ReflectionHelper.findMethod(client, null, new String[]{"fmlReentry"}, ArgsWrapper.class).invoke(null, wrap);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private Class<? super Object> setupNewClientHome(File minecraftHome) {
        Class<? super Object> client = ReflectionHelper.getClass(this.classLoader, "net.minecraft.client.Minecraft");
        ReflectionHelper.setPrivateValue(client, null, minecraftHome, "field_71463_am", "an", "minecraftDir");
        return client;
    }

    private void relaunchServer(ArgsWrapper wrap) {
        this.showWindow(false);
        File minecraftHome = new File(".");
        this.setupHome(minecraftHome);
        Class<? super Object> server = ReflectionHelper.getClass(this.classLoader, "net.minecraft.server.MinecraftServer");
        try {
            ReflectionHelper.findMethod(server, null, new String[]{"fmlReentry"}, ArgsWrapper.class).invoke(null, wrap);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void setupHome(File minecraftHome) {
        FMLInjectionData.build(minecraftHome, this.classLoader);
        FMLRelaunchLog.minecraftHome = minecraftHome;
        FMLRelaunchLog.info("Forge Mod Loader version %s.%s.%s.%s for Minecraft %s loading", FMLInjectionData.major, FMLInjectionData.minor, FMLInjectionData.rev, FMLInjectionData.build, FMLInjectionData.mccversion, FMLInjectionData.mcpversion);
        FMLRelaunchLog.info("Java is %s, version %s, running on %s:%s:%s, installed at %s", System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.home"));
        FMLRelaunchLog.fine("Java classpath at launch is %s", System.getProperty("java.class.path"));
        FMLRelaunchLog.fine("Java library path at launch is %s", System.getProperty("java.library.path"));
        try {
            RelaunchLibraryManager.handleLaunch(minecraftHome, this.classLoader);
        }
        catch (Throwable t2) {
            if (this.popupWindow != null) {
                try {
                    String logFile = new File(minecraftHome, "ForgeModLoader-client-0.log").getCanonicalPath();
                    JOptionPane.showMessageDialog(this.popupWindow, String.format("<html><div align=\"center\"><font size=\"+1\">There was a fatal error starting up minecraft and FML</font></div><br/>Minecraft cannot launch in it's current configuration<br/>Please consult the file <i><a href=\"file:///%s\">%s</a></i> for further information</html>", logFile, logFile), "Fatal FML error", 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RuntimeException(t2);
        }
    }

    private File computeExistingClientHome() {
        Class<? super Object> mcMaster = ReflectionHelper.getClass(this.getClass().getClassLoader(), "net.minecraft.client.Minecraft");
        String str = System.getProperty("minecraft.applet.TargetDirectory");
        if (str != null) {
            str = str.replace('/', File.separatorChar);
            ReflectionHelper.setPrivateValue(mcMaster, null, new File(str), "minecraftDir", "an", "minecraftDir");
        }
        Method setupHome = ReflectionHelper.findMethod(mcMaster, null, new String[]{"getMinecraftDir", "getMinecraftDir", "b"}, new Class[0]);
        try {
            setupHome.invoke(null, new Object[0]);
        }
        catch (Exception e2) {
            // empty catch block
        }
        File minecraftHome = (File)ReflectionHelper.getPrivateValue(mcMaster, null, "minecraftDir", "an", "minecraftDir");
        return minecraftHome;
    }

    public static void appletEntry(Applet minecraftApplet) {
        side = "CLIENT";
        logFileNamePattern = "ForgeModLoader-client-%g.log";
        FMLRelauncher.instance().relaunchApplet(minecraftApplet);
    }

    private void relaunchApplet(Applet minecraftApplet) {
        block11: {
            this.showWindow(true);
            if (minecraftApplet.getClass().getClassLoader() == this.classLoader) {
                if (this.popupWindow != null) {
                    this.popupWindow.setVisible(false);
                    this.popupWindow.dispose();
                }
                try {
                    this.newApplet = minecraftApplet;
                    this.appletClass = ReflectionHelper.getClass(this.classLoader, "net.minecraft.client.MinecraftApplet");
                    ReflectionHelper.findMethod(this.appletClass, this.newApplet, new String[]{"fmlInitReentry"}, new Class[0]).invoke(this.newApplet, new Object[0]);
                    return;
                }
                catch (Exception e2) {
                    System.out.println("FMLRelauncher.relaunchApplet");
                    e2.printStackTrace();
                    throw new RuntimeException(e2);
                }
            }
            File mcDir = this.computeExistingClientHome();
            this.setupHome(mcDir);
            this.setupNewClientHome(mcDir);
            Class<? super Object> parentAppletClass = ReflectionHelper.getClass(this.getClass().getClassLoader(), "java.applet.Applet");
            try {
                this.appletClass = ReflectionHelper.getClass(this.classLoader, "net.minecraft.client.MinecraftApplet");
                this.newApplet = this.appletClass.newInstance();
                Object appletContainer = ReflectionHelper.getPrivateValue(ReflectionHelper.getClass(this.getClass().getClassLoader(), "java.awt.Component"), minecraftApplet, "parent");
                String launcherClassName = System.getProperty("minecraft.applet.WrapperClass", "net.minecraft.Launcher");
                Class<? super Object> launcherClass = ReflectionHelper.getClass(this.getClass().getClassLoader(), launcherClassName);
                if (launcherClass.isInstance(appletContainer)) {
                    ReflectionHelper.findMethod(ReflectionHelper.getClass(this.getClass().getClassLoader(), "java.awt.Container"), minecraftApplet, new String[]{"removeAll"}, new Class[0]).invoke(appletContainer, new Object[0]);
                    ReflectionHelper.findMethod(launcherClass, appletContainer, new String[]{"replace"}, parentAppletClass).invoke(appletContainer, this.newApplet);
                    break block11;
                }
                FMLRelaunchLog.severe("Found unknown applet parent %s, unable to inject!\n", appletContainer.getClass().getName());
                throw new RuntimeException();
            }
            catch (Exception e3) {
                throw new RuntimeException(e3);
            }
            finally {
                if (this.popupWindow != null) {
                    this.popupWindow.setVisible(false);
                    this.popupWindow.dispose();
                }
            }
        }
    }

    public static void appletStart(Applet applet) {
        FMLRelauncher.instance().startApplet(applet);
    }

    private void startApplet(Applet applet) {
        if (applet.getClass().getClassLoader() == this.classLoader) {
            if (this.popupWindow != null) {
                this.popupWindow.setVisible(false);
                this.popupWindow.dispose();
            }
            if (RelaunchLibraryManager.downloadMonitor.shouldStopIt()) {
                System.exit(1);
            }
            try {
                ReflectionHelper.findMethod(this.appletClass, this.newApplet, new String[]{"fmlStartReentry"}, new Class[0]).invoke(this.newApplet, new Object[0]);
            }
            catch (Exception e2) {
                System.out.println("FMLRelauncher.startApplet");
                e2.printStackTrace();
                throw new RuntimeException(e2);
            }
        }
    }

    public static String side() {
        return side;
    }
}

