/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.worldedit;

import com.q3hardcore.xcommands.wrapper.WBiome;
import com.sk89q.worldedit.BiomeType;
import java.util.HashMap;

public class XCommandsBiomeType
implements BiomeType {
    private WBiome biome;
    private static final HashMap cachedValues = new HashMap();

    public XCommandsBiomeType(WBiome wBiome) {
        this.biome = wBiome;
    }

    public String getName() {
        return this.biome.getBiomeName();
    }

    public int getBiomeID() {
        return this.biome.getBiomeID();
    }

    public static BiomeType valueOf(String string) throws IllegalArgumentException {
        XCommandsBiomeType.updateValues();
        if (string == null) {
            throw new IllegalArgumentException("Name specified was null");
        }
        String string2 = string.toLowerCase();
        if (cachedValues.containsKey(string2)) {
            return (BiomeType)cachedValues.get(string2);
        }
        throw new IllegalArgumentException("Unknown biome name specified");
    }

    public static BiomeType[] values() {
        XCommandsBiomeType.updateValues();
        return cachedValues.values().toArray(new BiomeType[0]);
    }

    private static void updateValues() {
        if (cachedValues.isEmpty() || cachedValues.size() != WBiome.getBiomeList().length) {
            WBiome[] wBiomeArray;
            System.out.println("XCommands/WE: Loading biome type pairings");
            cachedValues.clear();
            for (WBiome wBiome : wBiomeArray = WBiome.getBiomeList()) {
                if (wBiome == null) continue;
                cachedValues.put(wBiome.getBiomeName().toLowerCase(), new XCommandsBiomeType(wBiome));
            }
        }
    }
}

