/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionHelper {
    private static final String blacklistedClass = "java.lang.Object";

    public static Method getMethod(Class clazz, String string, Class ... classArray) {
        return ReflectionHelper.getMethod(clazz, new String[]{string}, classArray);
    }

    public static Method getMethod(Class clazz, String[] stringArray, Class ... classArray) {
        if (clazz == null) {
            System.err.println("No class specified.");
            return null;
        }
        if (stringArray == null || stringArray.length < 1) {
            System.err.println("No methodNames specified.");
            return null;
        }
        Method method = null;
        for (String string : stringArray) {
            try {
                method = clazz.getDeclaredMethod(string, classArray);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (method == null) {
            System.err.println(clazz.getName() + " does not have method " + stringArray[0]);
            return null;
        }
        try {
            method.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return method;
    }

    public static Constructor getConstructor(Class clazz, Class ... classArray) {
        if (clazz == null) {
            System.err.println("No class specified.");
            return null;
        }
        Constructor constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (constructor == null) {
            System.err.println(clazz.getName() + "does not have specified constructor");
            return null;
        }
        try {
            constructor.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return constructor;
    }

    public static Field getFinalField(Class clazz, String ... stringArray) {
        Field field = ReflectionHelper.internalGetField(stringArray, clazz);
        if (field == null) {
            System.err.println(clazz.getName() + " does not have field " + stringArray[0]);
            return null;
        }
        try {
            Field field2 = Field.class.getDeclaredField("modifiers");
            field2.setAccessible(true);
            field2.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return field;
    }

    public static Method getPublicMethodWithParamsLength(Class clazz, String string, int n2) {
        if (clazz == null) {
            System.err.println("No class specified.");
            return null;
        }
        try {
            Method[] methodArray;
            for (Method method : methodArray = clazz.getMethods()) {
                boolean bl2 = method.getName().equals(string);
                if (!bl2 || method.getParameterTypes().length != n2) continue;
                return method;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.err.println(clazz.getName() + " does not have method " + string);
        return null;
    }

    public static Class getBaseClass(Class clazz) {
        Class clazz2;
        if (clazz == null) {
            System.err.println("No class specified.");
            return null;
        }
        while ((clazz2 = clazz.getSuperclass()) != null && !clazz2.getName().equals(blacklistedClass)) {
            clazz = clazz2;
        }
        return clazz;
    }

    public static Class getDefaultPackageClass(String string) {
        if (string == null) {
            System.err.println("No class name specified.");
            return null;
        }
        return ReflectionHelper.getClass(string, "net.minecraft.src." + string);
    }

    public static Class getClass(String ... stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            System.err.println("No class name(s) specified.");
            return null;
        }
        Class<?> clazz = null;
        for (String string : stringArray) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (clazz == null) {
            return null;
        }
        return clazz;
    }

    public static boolean getBoolean(Field field, Object object) {
        if (field == null) {
            System.err.println("Null field");
            return false;
        }
        try {
            return field.getBoolean(object);
        }
        catch (Exception exception) {
            System.err.println(field.getType() + " not assignable from " + Boolean.TYPE);
            return false;
        }
    }

    public static double getDouble(Field field, Object object) {
        if (field == null) {
            System.err.println("Null field");
            return -1.0;
        }
        try {
            return field.getDouble(object);
        }
        catch (Exception exception) {
            System.err.println(field.getType() + " not assignable from " + Double.TYPE);
            return -1.0;
        }
    }

    public static int getInt(Field field, Object object) {
        if (field == null) {
            System.err.println("Null field");
            return -1;
        }
        try {
            return field.getInt(object);
        }
        catch (Exception exception) {
            System.err.println(field.getType() + " not assignable from " + Integer.TYPE);
            return -1;
        }
    }

    public static String getString(Field field, Object object) {
        if (field == null) {
            System.err.println("Null field");
            return "";
        }
        try {
            return field.get(object).toString();
        }
        catch (Exception exception) {
            System.err.println(field.getType() + " not convertable to String");
            return "";
        }
    }

    public static boolean setField(Field field, Object object, Object object2) {
        if (field == null) {
            System.err.println("Null field");
            return false;
        }
        try {
            field.set(object, object2);
        }
        catch (Exception exception) {
            System.err.println(field.getType() + " not assignable from " + object2.getClass());
            return false;
        }
        return true;
    }

    public static Field getField(Class clazz, String ... stringArray) {
        Field field = ReflectionHelper.internalGetField(stringArray, clazz);
        if (field == null) {
            System.err.println(clazz.getName() + " does not have field " + stringArray[0]);
            return null;
        }
        try {
            field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return field;
    }

    public static Field getField(Object object, String ... stringArray) {
        if (object != null) {
            return ReflectionHelper.getField(object.getClass(), stringArray);
        }
        return null;
    }

    private static Field internalGetField(String[] stringArray, Class clazz) {
        if (clazz == null) {
            System.err.println("No class specified.");
            return null;
        }
        if (stringArray == null || stringArray.length < 1) {
            System.err.println("No field name(s) specified.");
            return null;
        }
        Field field = null;
        for (String string : stringArray) {
            try {
                field = clazz.getDeclaredField(string);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        return field;
    }
}

