/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.plugin;

import com.q3hardcore.xcommands.plugin.Plugin;
import com.q3hardcore.xcommands.util.DeathPos;
import com.q3hardcore.xcommands.util.FontColour;
import com.q3hardcore.xcommands.wrapper.Coordinate;
import com.q3hardcore.xcommands.wrapper.PosKey;
import com.q3hardcore.xcommands.wrapper.WChunkCoords;
import com.q3hardcore.xcommands.wrapper.WChunkPosition;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class spc_waypoint
extends Plugin {
    private HashMap prevPositions = new HashMap();

    @Override
    public String getName() {
        return "Waypoint";
    }

    @Override
    public List getCommands() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("deathpositions");
        arrayList.add("gethome");
        arrayList.add("getspawn");
        arrayList.add("home");
        arrayList.add("markpos");
        arrayList.add("deathpos");
        arrayList.add("return");
        arrayList.add("setspawn");
        arrayList.add("sethome");
        arrayList.add("spawnpoint");
        arrayList.add("stronghold");
        arrayList.add("tp");
        return arrayList;
    }

    @Override
    public String[] getHelp(String string) {
        if (string != null && string.equals("setspawn")) {
            String[] stringArray = new String[]{"Set spawn point.", "x y z", "100 64 30"};
            return stringArray;
        }
        if (string != null && string.equals("stronghold")) {
            String[] stringArray = new String[]{"Teleports player to nearest stronghold.", "", ""};
            return stringArray;
        }
        return null;
    }

    @Override
    public boolean handleCommand(WPlayer wPlayer, String[] stringArray) {
        if (stringArray[0].equalsIgnoreCase("setspawn")) {
            int n2;
            int n3;
            int n4;
            if (stringArray.length == 1) {
                n4 = (int)wPlayer.getPosX();
                n3 = (int)wPlayer.getPosY();
                n2 = (int)wPlayer.getPosZ();
            } else {
                if (stringArray.length != 4) {
                    wPlayer.sendError("Must be in format X Y Z.");
                    return true;
                }
                try {
                    n4 = (int)Double.parseDouble(stringArray[1]);
                    n3 = (int)Double.parseDouble(stringArray[2]);
                    n2 = (int)Double.parseDouble(stringArray[3]);
                }
                catch (Exception exception) {
                    wPlayer.sendError("Invalid position.");
                    return true;
                }
            }
            int n5 = spc_waypoint.getSpawnX(wPlayer);
            int n6 = spc_waypoint.getSpawnY(wPlayer);
            int n7 = spc_waypoint.getSpawnZ(wPlayer);
            String string = "(Previously: " + n5 + "," + n6 + "," + n7 + ")";
            wPlayer.getWorld().getWorldInfo().setSpawnPosition(n4, n3, n2);
            wPlayer.sendMessage("Spawn set at (" + n4 + "," + n3 + "," + n2 + ") " + string);
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("getspawn")) {
            int n8 = spc_waypoint.getSpawnX(wPlayer);
            int n9 = spc_waypoint.getSpawnY(wPlayer);
            int n10 = spc_waypoint.getSpawnZ(wPlayer);
            wPlayer.sendMessage("Current spawn position (" + n8 + "," + n9 + "," + n10 + ")");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("sethome")) {
            int n11;
            int n12;
            int n13;
            if (stringArray.length == 1) {
                n13 = (int)wPlayer.getPosX();
                n12 = (int)wPlayer.getPosY();
                n11 = (int)wPlayer.getPosZ();
            } else {
                if (stringArray.length != 4) {
                    wPlayer.sendError("Must be in format X Y Z.");
                    return true;
                }
                try {
                    n13 = (int)Double.parseDouble(stringArray[1]);
                    n12 = (int)Double.parseDouble(stringArray[2]);
                    n11 = (int)Double.parseDouble(stringArray[3]);
                }
                catch (Exception exception) {
                    wPlayer.sendError("Invalid position.");
                    return true;
                }
            }
            WChunkCoords wChunkCoords = WChunkCoords.instantiate(n13, n12, n11);
            wPlayer.setSpawnChunk(wChunkCoords, true);
            wPlayer.sendMessage("Home set at (" + n13 + "," + n12 + "," + n11 + ")");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("gethome")) {
            WChunkCoords wChunkCoords = this.getSpawnChunk(wPlayer);
            if (wChunkCoords.getRaw() == null) {
                wPlayer.sendError("Player has no home.");
                return true;
            }
            int n14 = wChunkCoords.posX;
            int n15 = wChunkCoords.posY;
            int n16 = wChunkCoords.posZ;
            wPlayer.sendMessage("Current home position (" + n14 + "," + n15 + "," + n16 + ")");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("spawnpoint")) {
            this.setCurrentPosition(wPlayer);
            int n17 = spc_waypoint.getSpawnX(wPlayer);
            int n18 = spc_waypoint.getSpawnZ(wPlayer);
            int n19 = wPlayer.getWorld().getTopSolidOrLiquidBlock(n17, n18);
            this.teleportPlayerTo(wPlayer, (double)n17 + 0.5, n19, (double)n18 + 0.5);
            wPlayer.sendMessage("Teleported to spawn point.");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("home")) {
            this.setCurrentPosition(wPlayer);
            WChunkCoords wChunkCoords = this.getSpawnChunk(wPlayer);
            if (wChunkCoords.getRaw() == null) {
                wPlayer.sendError("Player has no home.");
                return true;
            }
            this.teleportPlayerTo(wPlayer, (double)wChunkCoords.posX + 0.5, (double)wChunkCoords.posY + 1.0, (double)wChunkCoords.posZ + 0.5);
            wPlayer.sendMessage("Teleported home.");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("markpos")) {
            this.setCurrentPosition(wPlayer);
            wPlayer.sendMessage("Current position marked.");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("stronghold")) {
            WChunkPosition wChunkPosition = new WChunkPosition(wPlayer.getWorld().getRaw().b("Stronghold", (int)wPlayer.getPosX(), (int)wPlayer.getPosY(), (int)wPlayer.getPosZ()));
            if (wChunkPosition.y > -1) {
                this.setCurrentPosition(wPlayer);
                this.teleportPlayerTo(wPlayer, wChunkPosition.x, wChunkPosition.y, wChunkPosition.z);
                wPlayer.sendMessage("Teleported to nearest stronghold.");
            } else {
                wPlayer.sendError("Couldn't find stronghold.");
            }
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("return")) {
            if (!this.prevPositions.containsKey(this.getPosKey(wPlayer))) {
                wPlayer.sendError("No position stored.");
                return true;
            }
            Coordinate coordinate = (Coordinate)this.prevPositions.get(this.getPosKey(wPlayer));
            if (coordinate.getY() <= 0.0) {
                wPlayer.sendError("Previous position is at: " + coordinate.toPrettyString());
                return true;
            }
            this.teleportPlayerTo(wPlayer, coordinate.getX(), coordinate.getY(), coordinate.getZ());
            this.setCurrentPosition(wPlayer);
            wPlayer.sendMessage("Returned to last position.");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("deathpos")) {
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = DeathPos.getPos(wPlayer.getUsername(), wPlayer.getWorld().getName());
            Coordinate coordinate = (Coordinate)simpleImmutableEntry.getKey();
            if (coordinate.getY() <= 0.0) {
                wPlayer.sendError("No position stored.");
                return true;
            }
            if (wPlayer.getDimension() != ((Integer)simpleImmutableEntry.getValue()).intValue()) {
                wPlayer.sendError("Incorrect dimension!");
                return true;
            }
            this.setCurrentPosition(wPlayer);
            this.teleportPlayerTo(wPlayer, coordinate.getX(), coordinate.getY(), coordinate.getZ());
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("deathpositions")) {
            HashMap hashMap = DeathPos.getDeathPositions();
            if (hashMap.isEmpty()) {
                wPlayer.sendError("No death positions stored yet.");
                return true;
            }
            Iterator iterator = hashMap.keySet().iterator();
            wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + "===Death Positions==========");
            while (iterator.hasNext()) {
                AbstractMap.SimpleImmutableEntry simpleImmutableEntry = (AbstractMap.SimpleImmutableEntry)iterator.next();
                String string = (String)simpleImmutableEntry.getKey();
                String string2 = (String)simpleImmutableEntry.getValue();
                AbstractMap.SimpleImmutableEntry simpleImmutableEntry2 = (AbstractMap.SimpleImmutableEntry)hashMap.get(simpleImmutableEntry);
                Coordinate coordinate = (Coordinate)simpleImmutableEntry2.getKey();
                int n20 = (Integer)simpleImmutableEntry2.getValue();
                wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + "Player: " + (Object)((Object)FontColour.WHITE) + string + (Object)((Object)FontColour.GREEN) + " World: " + (Object)((Object)FontColour.WHITE) + string2);
                wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + "Dimension: " + (Object)((Object)FontColour.WHITE) + n20 + (Object)((Object)FontColour.GREEN) + " Position: " + (Object)((Object)FontColour.WHITE) + coordinate.toPrettyString());
                if (!iterator.hasNext()) continue;
                wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + "--------------------------");
            }
            wPlayer.sendMessage2((Object)((Object)FontColour.GREEN) + "==========================");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("tp")) {
            if (stringArray.length > 3) {
                double d2;
                double d3;
                double d4;
                try {
                    d4 = Double.parseDouble(stringArray[1]);
                    d3 = Double.parseDouble(stringArray[2]);
                    d2 = Double.parseDouble(stringArray[3]);
                }
                catch (Exception exception) {
                    wPlayer.sendError("Invalid position.");
                    return true;
                }
                this.setCurrentPosition(wPlayer);
                this.teleportPlayerTo(wPlayer, d4, d3, d2);
            } else {
                wPlayer.sendError("Position must be in format X Y Z.");
            }
            return true;
        }
        return false;
    }

    public static int getSpawnX(WPlayer wPlayer) {
        return wPlayer.getWorld().getSpawnX();
    }

    public static int getSpawnY(WPlayer wPlayer) {
        return wPlayer.getWorld().getSpawnY();
    }

    public static int getSpawnZ(WPlayer wPlayer) {
        return wPlayer.getWorld().getSpawnZ();
    }

    private void teleportPlayerTo(WPlayer wPlayer, double d2, double d3, double d4) {
        wPlayer.setPositionAndUpdate(d2, d3, d4);
    }

    private void setCurrentPosition(WPlayer wPlayer) {
        this.prevPositions.put(this.getPosKey(wPlayer), wPlayer.getPosition());
    }

    private WChunkCoords getSpawnChunk(WPlayer wPlayer) {
        return wPlayer.getSpawnChunk();
    }

    private String getPosKey(WPlayer wPlayer) {
        return new PosKey(wPlayer.getSender().getCommandSenderName(), wPlayer.getWorld().getName(), wPlayer.getDimension()).toString();
    }
}

