/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.plugin;

import com.q3hardcore.xcommands.core.Helper;
import com.q3hardcore.xcommands.plugin.Plugin;
import com.q3hardcore.xcommands.wrapper.WEnchantment;
import com.q3hardcore.xcommands.wrapper.WItem;
import com.q3hardcore.xcommands.wrapper.WItemStack;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import com.q3hardcore.xcommands.wrapper.WStringTranslate;
import java.util.ArrayList;
import java.util.List;

public class spc_enchant
extends Plugin {
    @Override
    public String getName() {
        return "Enchant";
    }

    @Override
    public List getCommands() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("enchant");
        return arrayList;
    }

    @Override
    public String[] getHelp(String string) {
        if (string != null && string.equals("enchant")) {
            String[] stringArray = new String[]{"Enchants the currently selected item", "<list|remove|add TYPE [LEVEL]>", "add protection 10"};
            return stringArray;
        }
        return null;
    }

    @Override
    public boolean handleCommand(WPlayer wPlayer, String[] stringArray) {
        if (stringArray[0].equalsIgnoreCase("enchant")) {
            WItem wItem;
            int n2;
            if (stringArray.length < 2) {
                wPlayer.sendError(Helper.ERRMSG_PARAM);
                return true;
            }
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            if (stringArray[1].equalsIgnoreCase("forceadd")) {
                bl3 = true;
            } else if (stringArray[1].equalsIgnoreCase("forceremove")) {
                bl4 = true;
            } else {
                bl2 = false;
            }
            WEnchantment[] wEnchantmentArray = WEnchantment.getEnchantmentsList();
            if (stringArray[1].equalsIgnoreCase("list")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i2 = 0; i2 < wEnchantmentArray.length; ++i2) {
                    if (wEnchantmentArray[i2] == null) continue;
                    WEnchantment wEnchantment = wEnchantmentArray[i2];
                    String string = this.translateToLocal(wEnchantment.getName()).replace(' ', '_') + " (" + i2 + ")";
                    arrayList.add(string);
                }
                String string = stringArray.length > 2 ? stringArray[2] : "1";
                if (!Helper.printFormattedList(wPlayer, "Enchantments [name (id)]", arrayList, string, 29)) {
                    wPlayer.sendError("Invalid page number specified.");
                }
                return true;
            }
            if (wPlayer.getInventory().getCurrentItem() == null) {
                wPlayer.sendError("No currently selected item");
                return true;
            }
            if (wPlayer.getInventory().getCurrentItem().isStackable() && !bl2) {
                wPlayer.sendError("This item cannot be enchanted");
                return true;
            }
            if (stringArray[1].equalsIgnoreCase("remove") || bl4) {
                if (wPlayer.getInventory().getCurrentItem().isItemEnchanted()) {
                    wPlayer.getInventory().getCurrentItem().setStackTagCompound(null);
                    wPlayer.sendMessage("Enchantment(s) for the current item were removed");
                } else {
                    wPlayer.sendMessage("Current item doesn't have any enchantments");
                }
                return true;
            }
            if (stringArray.length < 3) {
                wPlayer.sendError(Helper.ERRMSG_PARAM);
                return true;
            }
            if (!stringArray[1].equalsIgnoreCase("add") && !bl3) {
                wPlayer.sendError(Helper.ERRMSG_PARSE);
                return true;
            }
            int n3 = -1;
            WEnchantment wEnchantment = null;
            try {
                n3 = Integer.parseInt(stringArray[2]);
                wEnchantment = wEnchantmentArray[n3];
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (Exception exception) {
                wPlayer.sendError("Unknown enchantment id " + n3);
                return true;
            }
            for (n2 = 0; n2 < wEnchantmentArray.length; ++n2) {
                WEnchantment wEnchantment2 = wEnchantmentArray[n2];
                if (wEnchantment2 == null || !stringArray[2].equalsIgnoreCase(this.translateToLocal(wEnchantment2.getName()).replace(' ', '_'))) continue;
                wEnchantment = wEnchantment2;
            }
            if (wEnchantment == null) {
                wPlayer.sendError("Could not find specified enchantment: " + stringArray[2]);
                return true;
            }
            n2 = 1;
            if (stringArray.length == 4) {
                try {
                    n2 = Integer.parseInt(stringArray[3]);
                }
                catch (Exception exception) {
                    wPlayer.sendError(Helper.ERRMSG_PARSE);
                    return true;
                }
                int n4 = wEnchantment.getMaxLevel();
                int n5 = wEnchantment.getMinLevel();
                if (bl3) {
                    n4 = 127;
                }
                if (n2 > n4) {
                    wPlayer.sendMessage("Enchantment level " + n2 + " was too high, clamping to " + n4 + ".");
                    n2 = n4;
                } else if (n2 < n5) {
                    wPlayer.sendMessage("Enchantment level " + n2 + " was too low, clamping to " + n5 + ".");
                    n2 = n5;
                }
            }
            WItemStack wItemStack = wPlayer.getInventory().getCurrentItem();
            if (!bl3 && (wItem = wItemStack.getItem()) != null && !wEnchantment.canEnchantItem(wItem)) {
                wPlayer.sendError("Incorrect type of enchantment for item.");
                return true;
            }
            wItemStack.addEnchantment(wEnchantment, n2);
            wPlayer.sendMessage("The " + wEnchantment.getTranslatedName(n2) + " enchantment was added to the current item.");
            return true;
        }
        return false;
    }

    private String translateToLocal(String string) {
        return WStringTranslate.getInstance().a(string);
    }
}

