/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.core;

import com.q3hardcore.xcommands.core.Helper;
import com.q3hardcore.xcommands.core.PlayerHelper;
import com.q3hardcore.xcommands.plugin.Plugin;
import com.q3hardcore.xcommands.proxy.EnumSide;
import com.q3hardcore.xcommands.proxy.Proxy;
import com.q3hardcore.xcommands.proxy.Side;
import com.q3hardcore.xcommands.wrapper.SideException;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class PluginManager {
    private Vector plugins = new Vector();
    private boolean enabled = true;
    private static PluginManager MANAGER;
    private static boolean jarsLoaded;
    private static boolean pluginsLoaded;

    public PluginManager() {
        MANAGER = this;
    }

    public static PluginManager getPluginManager() {
        return MANAGER;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    public boolean loadPlugins(WPlayer wPlayer) {
        String string = "";
        String string2 = "";
        try {
            String string3;
            try {
                string3 = PlayerHelper.class.getResource("/XCommandsHelper.class").toString();
            }
            catch (NullPointerException nullPointerException) {
                string3 = PlayerHelper.class.getResource("/net/minecraft/src/XCommandsHelper.class").toString();
            }
            if (string3.toLowerCase().startsWith("jar")) {
                System.out.println("Loading plugins from jar.");
                String string4 = string3.replaceAll("jar:", "").split("!")[0];
                JarFile jarFile = new JarFile(new File(new URL(string4).toURI()));
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    try {
                        Plugin plugin;
                        if (!jarEntry.getName().toLowerCase().contains("spc_")) continue;
                        if (!jarEntry.getName().startsWith("com/q3hardcore/xcommands/plugin/")) {
                            string2 = string2 + jarEntry.getName() + " ";
                            continue;
                        }
                        Package package_ = XCommandsHelper.class.getPackage();
                        if (package_ != null && package_.getName().equals("net.minecraft.src")) {
                            package_ = null;
                        }
                        if ((plugin = PluginManager.loadPlugin(jarEntry.getName(), package_ == null ? null : package_.getName())) != null) {
                            this.plugins.add(plugin);
                            continue;
                        }
                        string = string + jarEntry.getName() + " ";
                    }
                    catch (SideException sideException) {
                        System.out.println("Skipping plugin: " + jarEntry.getName());
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            } else {
                System.out.println("Loading plugins from folder.");
                String string5 = Plugin.class.getName().replace('.', '/') + ".class";
                URLClassLoader uRLClassLoader = (URLClassLoader)PlayerHelper.class.getClassLoader();
                URL uRL = uRLClassLoader.getResource(string5);
                File[] fileArray = new File(uRL.getFile()).getParentFile().listFiles();
                if (fileArray == null) {
                    fileArray = new File(uRL.toURI()).getParentFile().listFiles();
                }
                for (File file : fileArray) {
                    if (!file.isFile() || !file.getName().toLowerCase().startsWith("spc_")) continue;
                    try {
                        Package package_ = Plugin.class.getPackage();
                        Plugin plugin = PluginManager.loadPlugin(file.getName(), package_ == null ? null : package_.getName());
                        if (plugin != null) {
                            this.plugins.add(plugin);
                            continue;
                        }
                        string = string + file.getName() + " ";
                    }
                    catch (SideException sideException) {
                        System.out.println("Skipping plugin: " + file.getName());
                    }
                    catch (Throwable throwable) {
                        System.err.println("Encountered error with: " + file.toString());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        if (!string.equalsIgnoreCase("")) {
            wPlayer.sendError("Plugin(s) failed to load: " + string);
            wPlayer.sendError("Please refer to installation instructions.");
        }
        if (!string2.equalsIgnoreCase("")) {
            wPlayer.sendError("Skipped plugin(s): " + string2);
            wPlayer.sendError("Please don't report this error.");
        }
        pluginsLoaded = true;
        return true;
    }

    public static Plugin loadPlugin(String string, String string2) throws Exception {
        Class<?> clazz;
        String string3;
        if (!string.endsWith(".class")) {
            throw new Exception("Not a plugin.");
        }
        string = string.split("\\.")[0];
        string = string2 == null ? string : string2 + "." + string;
        int n2 = (string = string.replaceAll("/", ".")).lastIndexOf(".");
        if (n2 != -1) {
            try {
                string3 = string.substring(n2 + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                System.out.println("Plugin has invalid class name.");
                string3 = string;
            }
        } else {
            string3 = string;
        }
        System.out.println("Found plugin: " + string3);
        URLClassLoader uRLClassLoader = (URLClassLoader)PlayerHelper.class.getClassLoader();
        try {
            clazz = uRLClassLoader.loadClass(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        if (clazz != null && Plugin.class.isAssignableFrom(clazz)) {
            Side side = clazz.getAnnotation(Side.class);
            if (side != null && Proxy.INSTANCE.getSide() != EnumSide.CLIENT && side.value() == EnumSide.CLIENT) {
                throw new SideException(EnumSide.CLIENT);
            }
            try {
                Plugin plugin = (Plugin)clazz.newInstance();
                return plugin != null ? plugin : null;
            }
            catch (Throwable throwable) {
                String string4 = throwable.getMessage();
                if (string4 != null) {
                    System.out.println("ERROR: " + throwable.getMessage());
                } else {
                    throwable.printStackTrace();
                }
                return null;
            }
        }
        throw new Exception("Not a plugin.");
    }

    public boolean callPluginMethods(Method method, Object ... objectArray) {
        if (method != null && objectArray != null && this.enabled) {
            boolean bl2 = false;
            Iterator iterator = this.plugins.iterator();
            boolean bl3 = false;
            if (method == PlayerHelper.PLUGIN_ATUPDATE) {
                bl3 = true;
            }
            while (iterator.hasNext()) {
                Object object;
                Plugin plugin = (Plugin)iterator.next();
                if (bl3 && !plugin.getTicking() || !plugin.getEnabled()) continue;
                if (objectArray.length > 0 && objectArray[0] instanceof WPlayer) {
                    object = (WPlayer)objectArray[0];
                    if (bl3 && plugin.getOwnerExclusive() && !((WPlayer)object).isPlayerOwner() && Proxy.INSTANCE.getSide() == EnumSide.CLIENT) continue;
                }
                try {
                    object = method.invoke((Object)plugin, objectArray);
                    if (!(object instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    System.out.println("Plugin failed: " + plugin.getName());
                    throwable.printStackTrace();
                }
            }
            return bl2;
        }
        return false;
    }

    public boolean handlePluginCommand(WPlayer wPlayer, String[] stringArray) throws Throwable {
        if (!this.enabled) {
            wPlayer.sendError("Plugin Manager is disabled.");
            return true;
        }
        if (stringArray.length < 1) {
            return false;
        }
        for (Plugin plugin : this.plugins) {
            if (plugin.getCommands() == null || !plugin.getCommands().contains(stringArray[0])) continue;
            if (!plugin.getEnabled()) {
                wPlayer.sendError("Plugin is disabled.");
                return true;
            }
            if (!plugin.handleCommand(wPlayer, stringArray)) {
                wPlayer.sendError("Plugin does not have command " + stringArray[0] + ".");
            }
            return true;
        }
        return false;
    }

    public String[] getCommands() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        for (Plugin plugin : this.plugins) {
            object = plugin.getCommands();
            if (object == null) continue;
            n2 += object.size();
            vector.add(object);
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        object = vector.iterator();
        while (object.hasNext()) {
            Iterator iterator = ((List)object.next()).iterator();
            while (iterator.hasNext()) {
                stringArray[n3] = (String)iterator.next();
                ++n3;
            }
        }
        return stringArray;
    }

    public String[] getHelp(String string) {
        if (string != null && !string.equalsIgnoreCase("")) {
            Plugin plugin;
            String[] stringArray;
            Iterator iterator = this.plugins.iterator();
            do {
                if (!iterator.hasNext()) {
                    return null;
                }
                plugin = (Plugin)iterator.next();
                stringArray = null;
            } while ((stringArray = plugin.getHelp(string)) == null);
            return stringArray;
        }
        return null;
    }

    public List getPlugins() {
        return this.plugins;
    }

    public Plugin[] getPlugin(String string) {
        Vector<Plugin> vector = new Vector<Plugin>();
        for (Plugin plugin : this.plugins) {
            if (plugin.getName() == null || !plugin.getName().equalsIgnoreCase(string)) continue;
            vector.add(plugin);
        }
        return vector.toArray(new Plugin[vector.size()]);
    }

    public static void loadJars() {
        if (jarsLoaded) {
            System.out.println("Jars already loaded!");
            return;
        }
        try {
            File file = new File(Helper.getModDir(), "jars");
            if (!file.exists()) {
                throw new Exception("XCommands: Jars folder missing.");
            }
            File[] fileArray = file.listFiles();
            Vector<String> vector = new Vector<String>();
            vector.add("minecraft.jar");
            vector.add("lwjgl.jar");
            vector.add("lwjgl_util.jar");
            vector.add("jinput.jar");
            vector.add("WorldEdit.jar");
            File[] fileArray2 = fileArray;
            int n2 = fileArray.length;
            System.out.println("XCommands: Scanning jars folder.");
            for (int i2 = 0; i2 < n2; ++i2) {
                File file2 = fileArray2[i2];
                String string = file2.getName();
                if (!vector.contains(string) && string.endsWith(".jar")) {
                    System.out.println("Adding " + string + " to classpath.");
                    Helper.addToClasspath(file2);
                    continue;
                }
                System.out.println("Ignoring " + string + " (already added)");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        jarsLoaded = true;
    }

    static {
        jarsLoaded = false;
        pluginsLoaded = false;
        PluginManager.loadJars();
    }
}

