/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.core;

import com.q3hardcore.xcommands.command.Loader;
import com.q3hardcore.xcommands.core.CommandRegistry;
import com.q3hardcore.xcommands.core.Helper;
import com.q3hardcore.xcommands.core.PluginLoader;
import com.q3hardcore.xcommands.core.PluginManager;
import com.q3hardcore.xcommands.plugin.Plugin;
import com.q3hardcore.xcommands.util.ObfuscationHelper;
import com.q3hardcore.xcommands.wrapper.WMinecraftServer;
import com.q3hardcore.xcommands.wrapper.WMovingObjectPosition;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import java.lang.reflect.Method;
import java.util.List;

public final class PlayerHelper {
    public static final boolean isEnabled = true;
    private final WPlayer player;
    protected static PluginManager PLUGIN_MANAGER;
    protected static Method PLUGIN_HANDLECOMMAND;
    protected static Method PLUGIN_HANDLELEFTCLICK;
    protected static Method PLUGIN_HANDLERIGHTCLICK;
    protected static Method PLUGIN_ATUPDATE;
    public static Method PLUGIN_HANDLECUIEVENT;
    private static boolean isInitialized;
    private static boolean updateStatus;
    private static boolean loadCmds;
    protected int pluginLoadState = 0;

    public PlayerHelper(WPlayer wPlayer) {
        System.out.println("Player helper instance for player: " + wPlayer.getUsername());
        this.player = wPlayer;
        Helper.loadSettings();
        if (CommandRegistry.registerCommands()) {
            loadCmds = true;
        }
        this.displayStatus();
        isInitialized = true;
        new PluginLoader(this).start();
        this.player.sendMessage2("\u00a77\u00a7o[XCommands: Checking for XCommands on client]");
    }

    private void displayStatus() {
        if (!isInitialized || updateStatus) {
            this.player.sendMessage2("XCommands by q3hardcore, running on Minecraft " + Helper.getServerVersion());
        }
    }

    protected WPlayer getPlayer() {
        return this.player;
    }

    public void afterUpdate() {
        if (loadCmds && this.pluginLoadState != 0) {
            if (!XCommandsHelper.hasSPC) {
                new Loader().start();
            } else {
                System.out.println("Skipping Loader (SPC installed)");
            }
            loadCmds = false;
        }
        if (PLUGIN_MANAGER != null) {
            List list = WMinecraftServer.getServer().getConfigurationManager().getPlayerEntityList();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                PLUGIN_MANAGER.callPluginMethods(PLUGIN_ATUPDATE, list.get(i2));
            }
        }
        if (!Helper.dropItems) {
            ObfuscationHelper.removeItemDrops(this.player, 128);
        }
    }

    public void sendDebug(String string) {
        if (Helper.debug) {
            this.player.sendMessage2("DEBUG: " + string);
        }
    }

    public void printDebug(String string) {
        if (Helper.debug) {
            System.out.println("DEBUG: " + string);
        }
    }

    public void handleLeftClick(int n2, int n3, int n4, int n5) {
        try {
            WMovingObjectPosition wMovingObjectPosition = this.player.rayTrace(this.player.getBlockReachDistance(), 1.0f);
            PLUGIN_MANAGER.callPluginMethods(PLUGIN_HANDLELEFTCLICK, this.player, wMovingObjectPosition);
        }
        catch (Throwable throwable) {
            System.out.println("Couldn't handle left click.");
        }
    }

    public void handleRightClick(int n2, int n3, int n4, int n5) {
        try {
            WMovingObjectPosition wMovingObjectPosition = this.player.rayTrace(this.player.getBlockReachDistance(), 1.0f);
            PLUGIN_MANAGER.callPluginMethods(PLUGIN_HANDLERIGHTCLICK, this.player, wMovingObjectPosition);
        }
        catch (Throwable throwable) {
            System.out.println("Couldn't handle right click.");
        }
    }

    public static PluginManager getPluginManager() {
        return PLUGIN_MANAGER;
    }

    static {
        isInitialized = false;
        updateStatus = false;
        loadCmds = false;
        try {
            PLUGIN_HANDLECOMMAND = Plugin.class.getDeclaredMethod("handleCommand", WPlayer.class, String[].class);
            PLUGIN_HANDLELEFTCLICK = Plugin.class.getDeclaredMethod("handleLeftClick", WPlayer.class, WMovingObjectPosition.class);
            PLUGIN_HANDLERIGHTCLICK = Plugin.class.getDeclaredMethod("handleRightClick", WPlayer.class, WMovingObjectPosition.class);
            PLUGIN_ATUPDATE = Plugin.class.getDeclaredMethod("atUpdate", WPlayer.class);
            PLUGIN_HANDLECUIEVENT = Plugin.class.getDeclaredMethod("handleCUIEvent", String.class, String[].class);
        }
        catch (Throwable throwable) {
            System.err.println("XCommands/Plugins: Plugin support is broken.");
        }
    }
}

