/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.core;

import com.q3hardcore.xcommands.core.CommandHelper;
import com.q3hardcore.xcommands.core.CommandList;
import com.q3hardcore.xcommands.core.Helper;
import com.q3hardcore.xcommands.core.PlayerHelper;
import com.q3hardcore.xcommands.wrapper.WICommandSender;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import com.q3hardcore.xcommands.wrapper.raw.RCommandBase;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class CommandConsole
extends RCommandBase {
    private static List commandList;

    @Override
    public String getCommandName() {
        return "c";
    }

    @Override
    public String getCommandUsage() {
        return "/c [command]";
    }

    @Override
    public void processCommand(WPlayer wPlayer, String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length == 1 && stringArray[0].equals("/")) {
            wPlayer.addChatMessage("XCommands 1.x, running on Minecraft " + Helper.getServerVersion());
            return;
        }
        PlayerHelper playerHelper = wPlayer.getPlayerHelper();
        if (playerHelper == null) {
            System.out.println("Player cannot use XCommands.");
            return;
        }
        CommandHelper.handleCommand(wPlayer, stringArray);
    }

    @Override
    public List addTabCompletionOptions(WICommandSender wICommandSender, String[] stringArray) {
        if (stringArray.length == 1) {
            this.setCommandList();
            if (stringArray[0].equals("/")) {
                return commandList;
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string : commandList) {
                if (!string.startsWith(stringArray[0])) continue;
                linkedList.add(string);
            }
            if (linkedList.isEmpty()) {
                return null;
            }
            return linkedList;
        }
        if (stringArray.length == 2) {
            // empty if block
        }
        return null;
    }

    private boolean setCommandList() {
        if (commandList == null) {
            LinkedList<String> linkedList = new LinkedList<String>();
            String[] stringArray = CommandList.CMDS.keySet().iterator();
            while (stringArray.hasNext()) {
                String[] stringArray2 = (String[])stringArray.next();
                linkedList.add("/" + (String)stringArray2);
            }
            if (PlayerHelper.PLUGIN_MANAGER != null) {
                for (String string : stringArray = PlayerHelper.PLUGIN_MANAGER.getCommands()) {
                    if (linkedList.contains("/" + string)) continue;
                    linkedList.add("/" + string);
                }
            }
            Collections.sort(linkedList);
            commandList = linkedList;
            return true;
        }
        return false;
    }
}

