/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.command;

import com.q3hardcore.xcommands.command.MultipleCommands;
import com.q3hardcore.xcommands.core.Helper;
import com.q3hardcore.xcommands.proxy.EnumSide;
import com.q3hardcore.xcommands.proxy.Proxy;
import com.q3hardcore.xcommands.worldedit.XCommandsLocalConfiguration;
import com.q3hardcore.xcommands.worldedit.XCommandsLocalPlayer;
import com.q3hardcore.xcommands.worldedit.XCommandsServerInterface;
import com.q3hardcore.xcommands.wrapper.WMinecraftServer;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldVector;
import java.io.File;
import java.util.HashMap;

public final class WorldEditCommandSet
extends MultipleCommands {
    public static WorldEdit WORLDEDIT;
    public static XCommandsServerInterface SERVER;
    public static XCommandsLocalConfiguration CONFIGURATION;
    private static WorldEditCommandSet INSTANCE;
    private static boolean isLoaded;
    private static final HashMap cachedPlayers;
    private static int worldHashCode;

    public WorldEditCommandSet(String string) {
        super(string);
        if (!isLoaded) {
            File file = Helper.getMinecraftDir();
            File file2 = new File(Helper.getModDir(), "worldedit.properties");
            CONFIGURATION = new XCommandsLocalConfiguration(file, file2);
            if (file2.exists()) {
                CONFIGURATION.load();
            }
            SERVER = new XCommandsServerInterface(null);
            WORLDEDIT = new WorldEdit((ServerInterface)SERVER, (LocalConfiguration)CONFIGURATION);
            INSTANCE = this;
            isLoaded = true;
        }
    }

    public static boolean isLoaded() {
        return isLoaded;
    }

    public static boolean hasCommand(String string) {
        return WORLDEDIT.getCommands().keySet().contains(string);
    }

    public static String getCommandDesc(String string) {
        return (String)WORLDEDIT.getCommands().get(string);
    }

    public static String[] getWECommands() {
        return WORLDEDIT.getCommands().keySet().toArray(new String[0]);
    }

    public static boolean hasWorldEdit() {
        return Helper.getHasWorldEdit() && WORLDEDIT != null;
    }

    public static WorldEditCommandSet getCurrentInstance() {
        return INSTANCE;
    }

    @Override
    public String[] getCommands() {
        return WORLDEDIT.getCommands().keySet().toArray(new String[0]);
    }

    @Override
    public String getDescription() {
        return (String)WORLDEDIT.getCommands().get(this.getCommandName());
    }

    @Override
    public void processCommand(WPlayer wPlayer, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "/" + this.getCommandName();
        int n2 = 1;
        String[] stringArray3 = stringArray;
        int n3 = stringArray3.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            String string;
            stringArray2[n2] = string = stringArray3[i2];
            ++n2;
        }
        WorldEditCommandSet.handleCommand(wPlayer, stringArray2);
    }

    private static XCommandsLocalPlayer getCachedPlayer(WPlayer wPlayer) {
        XCommandsLocalPlayer xCommandsLocalPlayer;
        if (worldHashCode != wPlayer.getWorld().rawHashCode()) {
            cachedPlayers.clear();
            worldHashCode = wPlayer.getWorld().rawHashCode();
        }
        if (cachedPlayers.containsKey(wPlayer.rawHashCode())) {
            xCommandsLocalPlayer = (XCommandsLocalPlayer)((Object)cachedPlayers.get(wPlayer.rawHashCode()));
            if (xCommandsLocalPlayer.player.inventoryHashCode() != wPlayer.inventoryHashCode()) {
                xCommandsLocalPlayer = new XCommandsLocalPlayer(SERVER, wPlayer);
                cachedPlayers.put(wPlayer.rawHashCode(), xCommandsLocalPlayer);
            }
        } else {
            xCommandsLocalPlayer = new XCommandsLocalPlayer(SERVER, wPlayer);
            if (Proxy.INSTANCE.getSide() == EnumSide.CLIENT && xCommandsLocalPlayer.getName().equals(WMinecraftServer.getServer().getServerOwner())) {
                WORLDEDIT.getSession((LocalPlayer)xCommandsLocalPlayer).setCUISupport(true);
                WORLDEDIT.getSession((LocalPlayer)xCommandsLocalPlayer).dispatchCUISetup((LocalPlayer)xCommandsLocalPlayer);
            }
            cachedPlayers.put(wPlayer.rawHashCode(), xCommandsLocalPlayer);
        }
        return xCommandsLocalPlayer;
    }

    public static void handleCommand(WPlayer wPlayer, String[] stringArray) {
        XCommandsLocalPlayer xCommandsLocalPlayer = WorldEditCommandSet.getCachedPlayer(wPlayer);
        boolean bl2 = WORLDEDIT.handleCommand((LocalPlayer)xCommandsLocalPlayer, stringArray);
        if (!bl2) {
            System.out.println("Invalid WE command.");
        }
    }

    public static void handleMouseButtonDown(WPlayer wPlayer, int n2, int n3, int n4, int n5, boolean bl2) {
        if (!WorldEditCommandSet.hasWorldEdit()) {
            return;
        }
        if (n3 < 0) {
            System.out.println("XCommands/WE: Player hit invalid position");
            return;
        }
        try {
            boolean bl3;
            XCommandsLocalPlayer xCommandsLocalPlayer = WorldEditCommandSet.getCachedPlayer(wPlayer);
            WorldVector worldVector = new WorldVector(xCommandsLocalPlayer.getWorld(), n2, n3, n4);
            boolean bl4 = false;
            if (!bl2) {
                bl3 = n2 != xCommandsLocalPlayer.blockrightx || n3 != xCommandsLocalPlayer.blockrighty || n4 != xCommandsLocalPlayer.blockrightz;
            } else {
                boolean bl5 = bl3 = n2 != xCommandsLocalPlayer.blockleftx || n3 != xCommandsLocalPlayer.blocklefty || n4 != xCommandsLocalPlayer.blockleftz;
            }
            if (!bl2) {
                if (n5 != -1) {
                    WORLDEDIT.handleRightClick((LocalPlayer)xCommandsLocalPlayer);
                }
                if (bl3) {
                    WORLDEDIT.handleBlockRightClick((LocalPlayer)xCommandsLocalPlayer, worldVector);
                    bl4 = true;
                }
            } else {
                if (n5 != -1) {
                    WORLDEDIT.handleArmSwing((LocalPlayer)xCommandsLocalPlayer);
                }
                if (bl3) {
                    WORLDEDIT.handleBlockLeftClick((LocalPlayer)xCommandsLocalPlayer, worldVector);
                    bl4 = true;
                }
            }
            if (bl4) {
                if (!bl2) {
                    xCommandsLocalPlayer.blockrightx = n2;
                    xCommandsLocalPlayer.blockrighty = n3;
                    xCommandsLocalPlayer.blockrightz = n4;
                } else {
                    xCommandsLocalPlayer.blockleftx = n2;
                    xCommandsLocalPlayer.blocklefty = n3;
                    xCommandsLocalPlayer.blockleftz = n4;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        isLoaded = false;
        cachedPlayers = new HashMap();
        worldHashCode = -1;
    }
}

