/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.command;

import com.q3hardcore.xcommands.command.StandardCommand;
import com.q3hardcore.xcommands.waypoint.Waypoint;
import com.q3hardcore.xcommands.waypoint.WaypointException;
import com.q3hardcore.xcommands.waypoint.WaypointHelper;
import com.q3hardcore.xcommands.wrapper.WPlayer;
import com.q3hardcore.xcommands.wrapper.WWorldProvider;
import java.io.File;
import java.util.List;

public class WaypointCommand
extends StandardCommand {
    @Override
    public String getCommandName() {
        return "waypoint";
    }

    @Override
    public String getDescription() {
        return "Provides tools for managing waypoints";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processCommand(WPlayer wPlayer, String[] stringArray) {
        if (stringArray.length == 0) {
            wPlayer.addChatMessage("Waypoint commands: add, del, info, goto, list");
            return;
        }
        File file = WaypointHelper.getWaypointFile(wPlayer.getWorld());
        if (stringArray[0].equals("list")) {
            if (!file.exists()) {
                wPlayer.addChatMessage("No waypoints for this world.");
                return;
            } else {
                List list = WaypointHelper.resolveWaypoints(file);
                if (list.size() == 0) {
                    wPlayer.addChatMessage("No waypoints added yet.");
                    return;
                }
                for (Waypoint waypoint : list) {
                    wPlayer.addChatMessage(waypoint.getName() + " created by " + waypoint.getPlayerName());
                }
            }
            return;
        }
        if (stringArray[0].equals("add")) {
            if (stringArray.length > 1) {
                WaypointHelper.addWaypoint(file, new Waypoint(stringArray[1], wPlayer.getUsername(), wPlayer.getPosition(), wPlayer.getDimension()));
                wPlayer.addChatMessage("Added waypoint.");
                return;
            }
            wPlayer.addChatMessage("Must specify waypoint name.");
            return;
        }
        if (stringArray[0].equals("goto")) {
            if (stringArray.length > 1) {
                Waypoint waypoint;
                if (!WaypointHelper.hasWaypoint(file, stringArray[1])) {
                    wPlayer.addChatMessage("Waypoint doesn't exist.");
                    return;
                }
                try {
                    waypoint = WaypointHelper.getWaypoint(file, stringArray[1]);
                }
                catch (WaypointException waypointException) {
                    wPlayer.addChatMessage("Invalid waypoint data.");
                    return;
                }
                int n2 = waypoint.getDimension();
                if (wPlayer.getDimension() != n2) {
                    if (WWorldProvider.getProviderForDimension(n2) == null) {
                        wPlayer.addChatMessage("Waypoint is located in invalid dimension.");
                        return;
                    }
                    wPlayer.addChatMessage("Waypoint located in dimension " + n2 + ".");
                    return;
                }
                wPlayer.setPositionAndUpdate(waypoint.getCoordinate());
                wPlayer.addChatMessage("Now at waypoint.");
                return;
            }
            wPlayer.addChatMessage("Must specify waypoint name.");
            return;
        }
        if (stringArray[0].equals("del")) {
            if (stringArray.length > 1) {
                if (!WaypointHelper.hasWaypoint(file, stringArray[1])) {
                    wPlayer.addChatMessage("Waypoint doesn't exist.");
                    return;
                }
                WaypointHelper.removeWaypoint(file, stringArray[1]);
                wPlayer.addChatMessage("Removed waypoint " + stringArray[1] + ".");
                return;
            }
            wPlayer.addChatMessage("Must specify waypoint name.");
            return;
        }
        if (stringArray[0].equals("info")) {
            if (stringArray.length > 1) {
                Waypoint waypoint;
                if (!WaypointHelper.hasWaypoint(file, stringArray[1])) {
                    wPlayer.addChatMessage("Waypoint doesn't exist.");
                    return;
                }
                try {
                    waypoint = WaypointHelper.getWaypoint(file, stringArray[1]);
                }
                catch (WaypointException waypointException) {
                    wPlayer.addChatMessage("Invalid waypoint data.");
                    return;
                }
                wPlayer.addChatMessage("Waypoint '" + waypoint.getName() + "', created by: " + waypoint.getPlayerName() + ".");
                wPlayer.addChatMessage("Position: " + waypoint.getCoordinate().toString() + " Dimension: " + waypoint.getDimension());
                return;
            }
            wPlayer.addChatMessage("Must specify waypoint name.");
            return;
        }
        wPlayer.addChatMessage("Unknown waypoint command.");
    }
}

