/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.command;

import com.q3hardcore.xcommands.command.MultipleCommands;
import com.q3hardcore.xcommands.command.StandardCommand;
import com.q3hardcore.xcommands.wrapper.WCommandHandler;
import com.q3hardcore.xcommands.wrapper.WMinecraftServer;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Loader
extends Thread {
    private static URLClassLoader CLASSLOADER;
    final WCommandHandler commandHandler = WMinecraftServer.getServer().getCommandHandler();

    public static URLClassLoader getClassLoader() {
        if (CLASSLOADER == null) {
            CLASSLOADER = (URLClassLoader)Loader.class.getClassLoader();
        }
        return CLASSLOADER;
    }

    @Override
    public void run() {
        long l2 = System.currentTimeMillis();
        if (!this.commandHandler.isValid()) {
            System.err.println("XCommands: Not loading 'native' commands.");
            return;
        }
        this.loadCommands();
        long l3 = System.currentTimeMillis();
        System.out.println("XCommands: Native commands thread took: " + (l3 - l2));
    }

    private void loadCommands() {
        System.out.println("Loading commands.");
        List list = this.getCommands();
        for (Class clazz : list) {
            if (clazz == null) {
                System.out.println("Report this!");
                continue;
            }
            if (StandardCommand.class.isAssignableFrom(clazz)) {
                if (this.loadStandardCommand(clazz)) continue;
                continue;
            }
            if (MultipleCommands.class.isAssignableFrom(clazz)) {
                if (this.loadMultipleCommands(clazz)) continue;
                continue;
            }
            if (!clazz.toString().contains("com.q3hardcore.xcommands.command")) continue;
            String string = clazz.toString();
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            System.out.println("Skipping class: " + string + " (non-command)");
        }
    }

    private boolean loadStandardCommand(Class clazz) {
        try {
            String string = clazz.toString();
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            if (Modifier.isAbstract(clazz.getModifiers())) {
                System.out.println("Skipping class: " + string + " (abstract)");
                return false;
            }
            System.out.println("Loading class: " + string);
            StandardCommand standardCommand = (StandardCommand)clazz.newInstance();
            if (!standardCommand.isEnabled()) {
                System.out.println("Command not enabled.");
                return false;
            }
            if (this.commandHandler.doesCommandExist(standardCommand.getCommandName())) {
                System.out.println("Overwriting existing command named: " + standardCommand.getCommandName());
            } else {
                System.out.println("Registering command: " + standardCommand.getCommandName());
            }
            this.commandHandler.registerCommand(standardCommand);
            return true;
        }
        catch (Exception exception) {
            System.err.println("There was an issue initialising class " + clazz.getName() + ". Verify that the class is setup correctly.");
            exception.printStackTrace();
            return false;
        }
    }

    private boolean loadMultipleCommands(Class clazz) {
        String string = clazz.toString();
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            System.out.println("Skipping class: " + string + " (abstract)");
            return false;
        }
        System.out.println("Loading class: " + string);
        try {
            Constructor constructor = clazz.getConstructor(String.class);
            MultipleCommands multipleCommands = (MultipleCommands)constructor.newInstance(new Object[]{null});
            String[] stringArray = multipleCommands.getCommands();
            if (stringArray == null) {
                return false;
            }
            for (String string2 : stringArray) {
                MultipleCommands multipleCommands2 = (MultipleCommands)constructor.newInstance(string2);
                if (!multipleCommands2.isEnabled()) {
                    System.out.println("Command not enabled.");
                    return false;
                }
                if (this.commandHandler.doesCommandExist(multipleCommands2.getCommandName())) {
                    System.out.println("Overwriting existing command named: " + multipleCommands2.getCommandName());
                }
                this.commandHandler.registerCommand(multipleCommands2);
            }
            return true;
        }
        catch (Throwable throwable) {
            System.err.println("Failed to load " + clazz.getName());
            return false;
        }
    }

    private List getCommands() {
        String string = Loader.class.getName();
        int n2 = string.split("\\.").length;
        String string2 = Loader.class.getResource((string = string.split("\\.")[n2 - 1]) + ".class").toString();
        if (string2.startsWith("jar")) {
            try {
                string2 = string2.replaceAll("jar:", "").split("!")[0];
                File file = new File(new URL(string2).toURI());
                return Loader.loadClassesFromJAR(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        try {
            File file = new File(new URL(string2).toURI());
            file = file.getParentFile();
            String string3 = file.toString();
            int n3 = string3.indexOf("com" + File.separator + "q3hardcore");
            if (n3 != -1) {
                string3 = string3.substring(n3);
                string3 = string3.replace(File.separatorChar, '.');
            }
            System.out.println("Command package: " + string3);
            return Loader.loadClassesFromDirectory(file, "com/q3hardcore/xcommands/command");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static List loadClassesFromDirectory(File file) {
        return Loader.loadClassesFromDirectory(file, "");
    }

    public static List loadClassesFromDirectory(File file, String string) {
        Vector<Class> vector = new Vector<Class>();
        try {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                try {
                    if (file2.isFile()) {
                        vector.add(Loader.loadClass(file2.getName(), string));
                        continue;
                    }
                    vector.addAll(Loader.loadClassesFromDirectory(file2, string + file2.getName() + "/"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return vector;
    }

    public static List loadClassesFromJAR(File file) {
        Vector<Class> vector = new Vector<Class>();
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                try {
                    vector.add(Loader.loadClass(jarEntry.getName(), null));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public static Class loadClass(String string, String string2) throws Exception {
        Class<?> clazz;
        if (!string.endsWith(".class")) {
            throw new Exception("'" + string + "' is not a class.");
        }
        if (string2 == null && !string.startsWith("com/q3hardcore/xcommands/command")) {
            throw new Exception("Skipping class (wrong package)");
        }
        string = string.split("\\.")[0];
        if (string2 != null) {
            string2 = string2.endsWith("/") ? string2.substring(0, string2.length() - 1) : string2;
        }
        string = string2 == null ? string : string2 + "." + string;
        if ((string = string.replaceAll("/", ".")).startsWith(".")) {
            string = string.substring(1);
        }
        URLClassLoader uRLClassLoader = Loader.getClassLoader();
        try {
            clazz = uRLClassLoader.loadClass(string);
        }
        catch (Throwable throwable) {
            System.out.println("Couldn't load " + string);
            throwable.printStackTrace();
            return null;
        }
        return clazz;
    }
}

