/*
 * Decompiled with CFR 0.152.
 */
package com.q3hardcore.xcommands.client.console;

import com.q3hardcore.xcommands.client.console.DrawMethods;
import com.q3hardcore.xcommands.client.console.Suggestion;
import com.q3hardcore.xcommands.client.wrapper.WMinecraft;
import com.q3hardcore.xcommands.client.wrapper.raw.RGuiScreen;
import com.q3hardcore.xcommands.command.WorldEditCommandSet;
import com.q3hardcore.xcommands.core.PlayerHelper;
import com.q3hardcore.xcommands.wrapper.WChatAllowedCharacters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.input.Keyboard;

public class GuiConsole
extends RGuiScreen {
    private int cursorIndex = 0;
    private int updateTicks = 0;
    private StringBuilder msgBuilder = new StringBuilder();
    private int numSuggestions = 0;
    private List suggestions = new ArrayList();
    private int historyIndex = -1;
    private static List history = new ArrayList();
    private boolean isSelecting = false;
    private int selBegin = 0;
    private int selEnd = 0;
    private static final String title = "XCC";
    private static final String helpMsg = "Console commands: clearhistory, help, pause, prefixslash, version";
    private static final int margin = 12;
    private static final int marginSmall = 3;
    private static final int marginY = 14;
    private static boolean loadedPluginCommands = false;
    private static boolean loadedWECommands = false;
    private static final Map cmds = new HashMap();
    private static final List cmdList = new ArrayList();
    private static boolean doPause = false;
    private static boolean prefixSlash = false;
    private int prevIndex = -1;
    private String prevString = "";
    private int newIndex = -1;
    private String newString = "";
    private int chatAdded = 0;
    private final int openKey;

    public GuiConsole(int n2) {
        Object object;
        this.openKey = n2;
        for (int i2 = 0; i2 < 10; ++i2) {
            this.suggestions.add(new Suggestion(i2));
        }
        if (PlayerHelper.getPluginManager() != null && !loadedPluginCommands) {
            String[] stringArray;
            System.out.println("XCommands/Console: Loading plugin commands");
            for (String string : stringArray = PlayerHelper.getPluginManager().getCommands()) {
                object = PlayerHelper.getPluginManager().getHelp(string);
                String string2 = "";
                if (object != null) {
                    if (object[1] != "") {
                        string2 = string2 + (String)object[1] + " ";
                    }
                    string2 = string2 + "- " + (String)object[0];
                }
                cmds.put("/" + string, string2);
            }
            loadedPluginCommands = true;
        }
        if (WorldEditCommandSet.isLoaded() && !loadedWECommands) {
            System.out.println("XCommands/Console: Loading WorldEdit commands");
            String[] stringArray = WorldEditCommandSet.getWECommands();
            for (String string : stringArray) {
                object = WorldEditCommandSet.getCommandDesc(string);
                if (((String)object).indexOf("-") == -1) {
                    object = "- " + (String)object;
                }
                cmds.put("/!" + string, object);
            }
            loadedWECommands = true;
        }
    }

    public void clearChat() {
        this.msgBuilder = prefixSlash ? new StringBuilder("/") : new StringBuilder();
        this.cursorIndex = this.msgBuilder.length();
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    public void updateScreen() {
        ++this.updateTicks;
    }

    @Override
    public void keyTyped(char c2, int n2) {
        if (this.chatAdded > 0) {
            --this.chatAdded;
        }
        try {
            this.handleKeyTyped(c2, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.cursorIndex = 0;
        }
    }

    private void handleKeyTyped(char c2, int n2) throws Exception {
        if (n2 == this.openKey && this.updateTicks == 0) {
            return;
        }
        if (n2 == 1) {
            this.closeGui();
        } else if (n2 == 28) {
            String string = this.msgBuilder.toString();
            if (!string.trim().equals("")) {
                history.add(string);
                if (string.startsWith("/") && !string.startsWith("/!")) {
                    this.sendChatMessage("/c " + string);
                } else {
                    String string2 = string;
                    if (string.startsWith("/!")) {
                        string2 = "/" + string.substring(2);
                    }
                    if (string2.equals("/")) {
                        string2 = "/ help";
                    }
                    if (string2.equals("/") || string2.startsWith("/ ")) {
                        String[] stringArray = string2.split(" ");
                        if (stringArray.length > 1) {
                            if (stringArray[1].equals("version")) {
                                this.printChatMessage("XCC v1.4 by q3hardcore.");
                            } else if (stringArray[1].equals("clearhistory")) {
                                history.clear();
                                this.historyIndex = -1;
                                this.printChatMessage("History cleared.");
                            } else if (stringArray[1].equals("pause")) {
                                doPause ^= true;
                            } else if (stringArray[1].equals("help")) {
                                this.printChatMessage(helpMsg);
                            } else if (stringArray[1].equals("prefixslash")) {
                                prefixSlash ^= true;
                            } else {
                                this.printChatMessage("Unknown console command.");
                            }
                            this.msgBuilder = new StringBuilder("/! ");
                            this.cursorIndex = this.msgBuilder.length();
                            this.historyIndex = -1;
                            return;
                        }
                    } else {
                        this.sendChatMessage(string2);
                    }
                }
            }
            this.closeGui();
        } else if (n2 == 14) {
            if (this.msgBuilder.length() > 0 && this.cursorIndex > 0) {
                this.msgBuilder.deleteCharAt(this.cursorIndex - 1).toString();
                --this.cursorIndex;
            }
        } else if (n2 == 211) {
            if (this.msgBuilder.length() > 0 && this.cursorIndex > -1 && this.cursorIndex < this.msgBuilder.length()) {
                this.msgBuilder.deleteCharAt(this.cursorIndex);
            }
        } else if (n2 == 203) {
            if (this.isShiftKeyDown()) {
                // empty if block
            }
            if (this.cursorIndex > 0) {
                --this.cursorIndex;
            }
        } else if (n2 == 205) {
            if (this.isShiftKeyDown()) {
                // empty if block
            }
            if (this.cursorIndex < this.msgBuilder.length()) {
                ++this.cursorIndex;
            }
        } else if (n2 == 200) {
            int n3;
            if (this.historyIndex == -1) {
                this.historyIndex = history.size();
            }
            if ((n3 = this.historyIndex - 1) >= 0) {
                this.historyIndex = n3;
                this.msgBuilder = new StringBuilder((String)history.get(this.historyIndex));
                this.cursorIndex = this.msgBuilder.length();
            }
        } else if (n2 == 208) {
            int n4;
            if (this.historyIndex == -1) {
                this.historyIndex = history.size();
            }
            if ((n4 = this.historyIndex + 1) < history.size()) {
                this.historyIndex = n4;
                this.msgBuilder = new StringBuilder((String)history.get(this.historyIndex));
                this.cursorIndex = this.msgBuilder.length();
            }
        } else if (this.isCtrlKeyDown()) {
            if (n2 == 46) {
                if (this.msgBuilder.length() > 0) {
                    GuiConsole.setClipboardString(this.msgBuilder.toString());
                }
            } else if (n2 == 47) {
                String string = GuiConsole.getClipboardString();
                if (!(string = WChatAllowedCharacters.filterAllowedCharacters(string)).equals("")) {
                    this.addChat(string);
                }
            } else if (n2 == 45) {
                if (this.msgBuilder.length() > 0) {
                    GuiConsole.setClipboardString(this.msgBuilder.toString());
                    this.addChat("");
                }
            } else if (n2 == 44 && this.chatAdded == 1) {
                if (this.newString.equals("")) {
                    this.msgBuilder = new StringBuilder(this.prevString);
                } else {
                    this.msgBuilder.delete(this.prevIndex, this.newIndex);
                }
                this.cursorIndex = this.prevIndex;
            }
        } else if (WChatAllowedCharacters.isAllowedCharacter(c2) && this.msgBuilder.length() < 100) {
            this.msgBuilder.insert(this.cursorIndex, c2);
            ++this.cursorIndex;
        }
    }

    private void addChat(String string) {
        if ((this.msgBuilder.toString() + string).length() > 100) {
            return;
        }
        this.chatAdded = 2;
        this.prevIndex = this.cursorIndex;
        this.prevString = this.msgBuilder.toString();
        if (string.equals("")) {
            this.clearChat();
            this.newIndex = 0;
            this.newString = "";
        } else {
            this.msgBuilder.insert(this.cursorIndex, string);
            this.cursorIndex += string.length();
            this.newIndex = this.cursorIndex;
            this.newString = this.msgBuilder.toString();
        }
    }

    private void printChatMessage(String string) {
        WMinecraft.getMinecraft().printChatMessage(string);
    }

    private void sendChatMessage(String string) {
        WMinecraft.getMinecraft().sendChatMessage(string);
    }

    private void closeGui() {
        WMinecraft.getMinecraft().displayGuiScreen((RGuiScreen)null);
    }

    @Override
    public void mouseClicked(int n2, int n3, int n4) {
        if (n4 == 0) {
            for (Suggestion suggestion : this.suggestions) {
                if (!suggestion.mousePressed(n2, n3)) continue;
                String string = "/" + suggestion.getMessage().split(" ")[0];
                this.msgBuilder = new StringBuilder(string);
                this.cursorIndex = this.msgBuilder.length();
                break;
            }
        } else if (n4 == 1) {
            int n5 = 14;
            int n6 = this.getWidth() - 12;
            if (n2 >= 12 && n3 >= 2 && n2 < n6 && n3 < n5) {
                this.msgBuilder = new StringBuilder("/!");
                this.cursorIndex = this.msgBuilder.length();
            }
        }
    }

    @Override
    public void drawScreen(int n2, int n3, float f2) {
        Object object;
        String string = this.msgBuilder.toString();
        StringBuilder stringBuilder = new StringBuilder(string);
        DrawMethods.drawRect(12, 14, this.getWidth() - 12, 2, Integer.MIN_VALUE);
        DrawMethods.drawRectWithMode(12, 14, this.getWidth() - 12, 2, -2130706433, 2);
        boolean bl2 = this.updateTicks / 6 % 2 == 0;
        boolean bl3 = false;
        if (bl2) {
            if (this.cursorIndex == string.length()) {
                try {
                    stringBuilder.insert(this.cursorIndex, "_");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.out.println("XCommands/Console: Reset cursor index");
                    this.cursorIndex = 0;
                }
            } else {
                bl3 = true;
            }
        }
        String string2 = "XCC: ";
        string2 = string2 + stringBuilder.toString();
        DrawMethods.drawString(this.getFontRenderer(), string2, 14, 4, 0xFFFFFF);
        if (bl3) {
            try {
                int n4 = 12 + this.getFontRenderer().getStringWidth("XCC: " + string.substring(0, this.cursorIndex));
                DrawMethods.drawRect(n4 + 1, 3, n4 + 2, 4 + this.getFontRenderer().getFontHeight(), -2130706433);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                System.out.println("XCommands/Console: Reset cursor index");
                this.cursorIndex = 0;
            }
        }
        this.numSuggestions = 0;
        String[] stringArray = this.suggestions.iterator();
        while (stringArray.hasNext()) {
            object = (Suggestion)stringArray.next();
            ((Suggestion)object).doDraw = false;
        }
        if (cmdList.size() != cmds.keySet().size()) {
            System.out.println("XCommands/Console: Sorting command list");
            cmdList.clear();
            cmdList.addAll(cmds.keySet());
            Collections.sort(cmdList);
        }
        if ((stringArray = string.split(" ")).length == 0) {
            return;
        }
        object = string.split(" ")[0];
        if (!((String)object).equals(string.trim()) && !cmdList.contains(object)) {
            return;
        }
        if (((String)object).equals("") || !((String)object).startsWith("/") || ((String)object).length() <= 1) {
            return;
        }
        if (((String)object).startsWith("/!") && ((String)object).length() < 3) {
            return;
        }
        int n5 = this.getFontRenderer().getStringWidth("XCC: /") + 12;
        int n6 = n5 - 3;
        int n7 = 0;
        for (Object object2 : cmdList) {
            if (!((String)object2).startsWith((String)object)) continue;
            if (this.numSuggestions > 9) {
                ++this.numSuggestions;
                continue;
            }
            n7 += 12;
            String string3 = ((String)object2).substring(1);
            String string4 = "";
            if (((String)object2).equals(object)) {
                string4 = cmds.get(object2) != "" ? (String)cmds.get(object2) : "(description not available)";
            }
            Suggestion suggestion = (Suggestion)this.suggestions.get(this.numSuggestions);
            suggestion.setPosition(n6, n7, this.getWidth(), n5);
            suggestion.setMessage(string3, string4);
            suggestion.doDraw = true;
            ++this.numSuggestions;
        }
        if (this.numSuggestions > 10) {
            Object object2;
            DrawMethods.drawRect(n6, 14 + (n7 += 12), this.getWidth() - 12, 2 + n7, Integer.MIN_VALUE);
            int n8 = this.numSuggestions - 10;
            object2 = "(" + n8;
            object2 = n8 == 1 ? (String)object2 + " command" : (String)object2 + " commands";
            object2 = (String)object2 + " not shown)";
            DrawMethods.drawString(this.getFontRenderer(), (String)object2, 2 + n5, 4 + n7, 0xFFFFFF);
            DrawMethods.drawRectWithMode(n6, 14 + n7, this.getWidth() - 12, 2 + n7, -2130706433, 3);
        }
        for (Object object2 : this.suggestions) {
            ((Suggestion)object2).draw(WMinecraft.getMinecraft(), n2, n3);
        }
    }

    @Override
    public boolean doesGuiPauseGame() {
        return doPause;
    }
}

