-- translation for StandardPackage

local t = {
	["standard"] = "英雄杀",
	["standard_cards"] = "标准卡牌包",
	["standard_ex_cards"] = "扩充卡牌包",

	["attack_card"] = "进攻牌",
	["defense_card"] = "防御牌",
	["recover_card"] = "恢复牌",
	["renyi_card"] = "限制牌",
	["global_effect"] = "全局效果",
	["aoe"] = "范围效果",
	["single_target_trick"] = "单体锦囊",
	["delayed_trick"] = "延时锦囊",
	["double_trick"] = "双体锦囊",
	["weapon"] = "武器",
	["armor"] = "防具",
	["horse"] = "马",
	["defensive_horse"] = "防御马",
	["offensive_horse"] = "进攻马",

	["slash"] = "杀",
	[":slash"] = "基本牌，出牌阶段，对除你外，你攻击范围内的一名角色使用，若目标无法闪避，则你对其造成1点伤害。\
	任何时候，当你成为【决斗】或【烽火狼烟】的目标时，你可以打出【杀】来抵消其效果。",

	["jink"] = "闪",
	[":jink"] = "基本牌，任何时候，当你成为【杀】或者【万箭齐发】的目标开始结算时，你可以打出【闪】来抵消其效果。",

	["peach"] = "药",
	[":peach"] = "基本牌，出牌阶段，对自己使用，可使自己回复一点体力。\
	任何时候，有角色处于濒死状态时，对其使用，可使目标角色回复1点体力。",

	["duel"] = "决斗",
	[":duel"] = "锦囊牌，出牌阶段，对除你以外任意一名角色使用，由目标角色先开始，你和他（她）轮流打出一张【杀】，【决斗】对首先不出【杀】的一方造成1点伤害；另一方成为此伤害的来源。",

	["dismantlement"] = "釜底抽薪",
	[":dismantlement"] = "锦囊牌，出牌阶段，对除你以外任意一名角色使用，你选择并弃掉目标角色手牌（随机选择）、装备区或判定区里的一张牌。",

	["snatch"] = "探囊取物",
	[":snatch"] = "锦囊牌，出牌阶段，对除你以外与你距离1以内的一名角色使用，你可以选择并获得目标角色手牌（随机选择）、装备区或判定区里的一张牌。",

	["archery_attack"] = "万箭齐发",
	[":archery_attack"] = "锦囊牌，出牌阶段，对除你以外的所有角色使用，按行动顺序结算，目标角色需打出1张【闪】来响应，否则该角色受到1点伤害。",

	["savage_assault"] = "烽火狼烟",
	[":savage_assault"] = "锦囊牌，出牌阶段，对除你以外的所有角色使用，按行动顺序结算，目标角色需打出1张【杀】来响应，否则该角色受到1点伤害。",

	["god_salvation"] = "休养生息",
	[":god_salvation"] = "锦囊牌，出牌阶段，对所有角色使用，按行动顺序结算，目标角色回复1点体力。",

	["ex_nihilo"] = "无中生有",
	[":ex_nihilo"] = "锦囊牌，出牌阶段，对自己使用，可以立即摸两张牌。",

	["amazing_grace"] = "五谷丰登",
	[":amazing_grace"] = "锦囊牌，出牌阶段，对所有角色使用，从牌堆顶亮出等同于现存角色数量的牌，然后按行动顺序结算，目标角色选择并获得这些牌中的一张。",

	["collateral"] = "借刀杀人",
	[":collateral"] = "锦囊牌，出牌阶段，对除你以外装备区里有武器牌的一名角色使用，并选择被借刀目标使用【杀】能攻击到的另一名角色（可以是你自己），被借刀目标需对指定角色使用一张【杀】，否则必须将其装备的武器牌交给你。",

	["indulgence"] = "画地为牢",
	[":indulgence"] = "锦囊牌，延时，出牌阶段，对除你以外任意一名角色使用，将【画地为牢】横置于目标角色判定区里，目标角色回合判定阶段，进行判定：若判定结果不为红桃，则跳过目标角色的出牌阶段，将【画地为牢】弃置。",

	["lightning"] = "手捧雷",
	[":lightning"] = "锦囊牌，延时，出牌阶段，对自己使用，将【手捧雷】横置于判定区里，回合判定阶段，进行判定：若判定结果为黑桃2-9之间（包括黑桃2和9），则【手捧雷】对当前目标造成3点伤害，将手捧雷弃置。若判定结果不为黑桃2-9之间（包括黑桃2和9），将【手捧雷】移动到当前当前角色下家（【手捧雷】的目标变为该角色）的判定区。",

	["nullification"] = "无懈可击",
	[":nullification"] = "锦囊牌，在一张锦囊牌对目标角色生效前，你可以对该锦囊使用，抵消该锦囊对其指定的一名目标角色产生的效果。",

	["crossbow"] = "虎符",
	[":crossbow"] = "装备牌，攻击范围：１\
	武器特效：出牌阶段，你可以使用任意张【杀】。",

	["double_sword"] = "雌雄双股剑",
	[":double_sword"] = "装备牌，攻击范围：２\
武器特效：你使用【杀】时，若指定了一名异性角色，则在【杀】结算前，你可以令对方选择一项：自己弃一张手牌或者让你从牌堆摸一张牌。",
	["double-sword-card"] = "%src 发动了【雌雄双股剑】，你必须弃一张手牌或让 %src 摸一张牌",
	["double_sword:yes"] = "你可以让对方选择让你摸一张牌或自弃一张牌",

	["ice_sword"] = "龙鳞刀",
	[":ice_sword"] = "装备牌，攻击范围：２\	武器特效：当你使用【杀】造成伤害时，你可以防止此伤害，改为弃置该目标角色的两张牌（弃完第一张再弃第二张）。",
	["ice_sword:yes"] = "你可以防止此伤害，改为弃掉目标的两张牌",

	["qinggang_sword"] = "鱼肠剑",
	[":qinggang_sword"] = "装备牌，攻击范围：２\
	武器特效：锁定技，每当你使用【杀】时，无视目标角色的防具。",

	["blade"] = "盘龙棍",
	[":blade"] = "装备牌，攻击范围：３\
武器特效：当你使用的【杀】被【闪】抵消时，你可以立即对此目标再使用一张【杀】直到【杀】生效或你不愿意出了为止。",
	["blade-slash"] = "你可以发动盘龙棍的追杀效果再打出一张【杀】",

	["spear"] = "芦叶枪",
	[":spear"] = "装备牌，攻击范围：３\
	武器特效：当你需要使用（或打出）一张【杀】时，你可以将两张手牌当一张【杀】使用（或打出）",

	["axe"] = "博浪锤",
	[":axe"] = "装备牌，攻击范围：３\
	武器特效：目标角色使用【闪】抵消你使用【杀】的效果时，你可以弃两张牌，则【杀】依然造成伤害。",
	["@axe"] = "你可以弃掉弃两张牌使此【杀】强制命中（手牌、装备牌均可）",
	["#AxeSkill"] = "%from 发动了<font color='yellow'><b>【博浪锤】</b></font>，弃掉了2张牌强制命中了 %to ",

	["halberd"] = "狼牙棒",
	[":halberd"] = "装备牌，攻击范围：４\
武器特效：当你使用的【杀】是你的最后一张手牌时，你可以为这张【杀】指定至多三名目标角色，然后按行动顺序依次结算之。",

	["kylin_bow"] = "霸王弓",
	[":kylin_bow"] = "装备牌，攻击范围：５\
	武器特效：你使用【杀】对目标角色造成伤害时，你可以将其装备区里的一匹马弃置。",
	["kylin_bow:yes"] = "弃置对方的一匹马",
	["kylin_bow:dhorse"] = "防御马（+1马）",
	["kylin_bow:ohorse"] = "进攻马（-1马）",

	["eight_diagram"] = "玉如意",
	[":eight_diagram"] = "装备牌，防具效果：每当你需要使用（或打出）一张【闪】时，你可以进行一次判定：\
	★若为红色，则视为你使用（或打出）了一张【闪】；\
	★若为黑色，你仍可从手牌里使用（或打出）。",
	["eight_diagram:yes"] = "进行一次判定，若判定结果为红色，则视为你打出了一张【闪】",

	["renwang_shield"] = "仁王盾",
	[":renwang_shield"] = "装备牌，防具效果：锁定技，黑色的【杀】对你无效。",

	["jueying"] = "绝影",
	["dilu"] = "的卢",
	["zhuahuangfeidian"] = "爪黄飞电",
	["chitu"] = "赤兔",
	["dayuan"] = "大宛",
	["zixing"] = "乌骓",
	[":-1 horse"] = "装备牌，你计算与其他角色的距离时，始终-1（你可以理解为一种进攻上的优势，不同名称的-1马，其效果是相同的）。",
	[":+1 horse"] = "装备牌，其他角色计算与你的距离时，始终+1（你可以理解为一种防御上的优势，不同名称的+1马，其效果是相同的）。",
}

local ohorses = {"chitu", "dayuan", "zixing"}
local dhorses = {"zhuahuangfeidian", "dilu", "jueying", "hualiu"}

for _, horse in ipairs(ohorses) do
	t[":" .. horse] = t[":-1 horse"]
end

for _, horse in ipairs(dhorses) do
	t[":" .. horse] = t[":+1 horse"]
end

return t
