Ext.define('cxd.datefield', {
	extend : 'Ext.form.Panel',
	alias : 'widget.dateField_plug',
	fieldName : 'name',
	fieldText:'text',
	maxValue:'',
	initComponent : function(config) {
		var me = this;
		Ext.apply(me, {
			border : 0,
			layout:'fit',
			items:[{
				xtype : 'datefield',						
				columnWidth : .8,						
				format : 'Y-m-d',
				fieldLabel : me.fieldText,
				maxValue:me.maxValue,
				listeners:{
						change:function(e){
							var date=Ext.util.Format.date(e.getValue(), 'Ymd');
								var dateTime=e.nextSibling();
								dateTime.refreshData="no";
								dateTime.setValue(date);
						}
					}
			},{
				xtype:'textfield',
				hidden:true,
				name:me.fieldName,
				listeners: {
					change:function(e){
						if(e.refreshData!="no"&&e.getValue()!=""){
								var dateTime=e.getValue();
								var year=dateTime.substring(0,4);
								var month=dateTime.substring(4,6);
								var day=dateTime.substring(6,8);
														
								var date=year+"-"+month+"-"+day;						
								e.previousSibling().setValue(date);
							}
					}}
			}]
		});
		this.callParent(arguments);
	}
});