/**
 * @class Ext.calendar.form.field.ReminderCombo
 * @extends Ext.form.ComboBox
 * <p>A custom combo used for choosing a reminder setting for an event.</p>
 * <p>This is pretty much a standard combo that is simply pre-configured for the options needed by the
 * calendar components. The default configs are as follows:<pre><code>
    width: 200,
    fieldLabel: 'Reminder',
    queryMode: 'local',
    triggerAction: 'all',
    forceSelection: true,
    displayField: 'desc',
    valueField: 'value'
</code></pre>
 * @constructor
 * @param {Object} config The config object
 */
Ext.define('Ext.calendar.form.field.ReminderCombo', {
    extend: 'Ext.form.field.ComboBox',
    alias: 'widget.reminderfield',

    fieldLabel: '提醒',
    queryMode: 'local',
    triggerAction: 'all',
    forceSelection: true,
    displayField: 'desc',
    valueField: 'value',
    typeAhead : true,// 当在combox框中输入信息时，自动显示下拉列表中对应该输入的列
	triggerAction : 'all',// 无论有没有内容，下拉列表全部显示，有内容会自动在该内容上高亮显示
	editable : false,// 用户不能自己输入,只能选择列表中有的记录
    // private
    initComponent: function() {
        this.store = this.store || new Ext.data.ArrayStore({
            fields: ['value', 'desc'],
            idIndex: 0,
            data: [                
            ['', '关闭'],
            //['-1', '自动'],
            ['0', '准时'],
            ['5', '提前5分钟'],
            ['15', '提前15分钟'],
            ['30', '提前30分钟'],
            ['60', '提前1小时'],
            ['90', '提前1.5小时'],
            ['120', '提前2小时'],
            ['180', '提前3小时'],
            ['360', '提前6小时'],
            ['720', '提前12小时'],
            ['1440', '提前1天'],
            ['2880', '提前2天'],
            ['4320', '提前3天'],
            ['5760', '提前4天'],
            ['7200', '提前5天'],
            ['10080', '提前1周'],
            ['20160', '提前2周']
            ]
        });

        this.callParent();
    },

    // inherited docs
    initValue: function() {
        if (this.value !== undefined) {
            this.setValue(this.value);
        }
        else {
            this.setValue('');
        }
        this.originalValue = this.getValue();
    }
});
