/**
 * @class Ext.calendar.form.EventWindow
 * @extends Ext.Window
 * <p>A custom window containing a basic edit form used for quick editing of events.</p>
 * <p>This window also provides custom events specific to the calendar so that other calendar components can be easily
 * notified when an event has been edited via this component.</p>
 * @constructor
 * @param {Object} config The config object
 */
Ext.define('Ext.calendar.form.EventWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.eventeditwindow',
    
    requires: [
        'Ext.form.Panel',
        'Ext.calendar.data.EventModel',
        'Ext.calendar.data.EventMappings'
    ],

    constructor: function(config) {
    	if (config.calendarStore) {
            this.calendarStore = config.calendarStore;
            delete config.calendarStore;
        }
        var formPanelCfg = {
            xtype: 'form',
            fieldDefaults: {
                msgTarget: 'side',
                labelWidth: 65
            },
            frame: false,
            layout:'column',
            bodyStyle: 'background:transparent;',
            defaults:{margin:'8px',columnWidth:1},
            bodyBorder: false,
            border: false,
            items: [{
                itemId: 'title',
                name: Ext.calendar.data.EventMappings.Title.name,
                fieldLabel: '主题',
                xtype: 'textfield',
                allowBlank: false,
                labelStyle : 'color:' + _requiredColor,
                emptyText: '请输入标题'
            },
            {
            	style:'margin:15px',
                xtype: 'daterangefield',
                itemId: 'date-range',
                name: 'dates',
                fieldLabel: '时间'
            },{    
            	itemId:'rem',
            	xtype:'reminderfield',
            	 name: 'Reminder',
            	 columnWidth:.5
            },{
                xtype: 'calendarpicker',
                itemId: 'calendar',
                name: Ext.calendar.data.EventMappings.CalendarId.name,
                columnWidth:.5,
                store: this.calendarStore
            },{
            	columnWidth:.5,
				xtype : 'fieldcontainer',
				fieldLabel : '全体共享',
				defaultType : 'checkboxfield',
				items : [{
							itemId:'QTGX',
							boxLabel : '是',
							name :  Ext.calendar.data.EventMappings.QTGX.name,
							checked:false,
							inputValue : 'true'
						}]
			},{
            	itemId:'textarea',
            	xtype:'textarea',
            	fieldLabel: '内容',
            	rows : 6,
                name: Ext.calendar.data.EventMappings.Notes.name
            },{
            	itemId:'faburen',
            	readOnly:true,
               	xtype : "textfield",  
               	name:Ext.calendar.data.EventMappings.Faburen.name,
               	fieldLabel : '发布人'
            }]
        };
    
        
        var me=this;
        this.callParent([Ext.apply({
            titleTextAdd: '新建日程',
            titleTextEdit: '编辑当前日程',
            width: 600,
            autocreate: true,
            border: true,
            closeAction: 'hide',
            modal: false,
            resizable: false,
            buttonAlign: 'left',
            savingMessage: 'Saving changes...',
            deletingMessage: 'Deleting event...',
            layout: 'fit',
    
            defaultFocus: 'title',
            onEsc: function(key, event) {
                        event.target.blur(); // Remove the focus to avoid doing the validity checks when the window is shown again.
                        this.onCancel();
                    },

            fbar: [
                   {
                xtype: 'tbtext',
                text: '<a href="#" id="tblink"></a>'
            },
            '->',
            {
                itemId: 'delete-btn',
                text: '删除',
                disabled: false,
                handler: this.onDelete,
                scope: this,
                hideMode: 'offsets'
            },
            {
            	itemId: 'save-btn',
                text: '保存',
                disabled: false,
                handler:function(){
                	var obj={};
                	var EventId=me.activeRecord.data.EventId==0?null:me.activeRecord.data.EventId;
                	var CalendarId=me.calendarField.getValue();
                	var Title=me.titleField.getValue();
                	
                	var dates = me.dateRangeField.getValue();

                	var startDate=Date.parse(dates[0]);
                	var endDate=Date.parse(dates[1]);
                	
                	if(startDate>endDate){
                		Ext.Msg.alert(Msg_TiShi, '日程结束时间不能小于开始时间！');
                		return false;
                	}
                	var IsAllDay=dates[2];
                	
                	var Notes=me.textareaField.getValue();
                	var Reminder=me.remField.getValue();
                	var gx=me.QTGX.getValue();
                	
                	obj['EventId']=EventId;
					obj['CalendarId']=CalendarId;
					obj['Title']=Title;
					obj['StartDate']=dates[0];
					obj['EndDate']=dates[1];
					
					obj['IsAllDay']=dates[2];
					obj['Reminder']=Reminder;
					obj['Notes']=Notes;
					obj['QTGX']=gx;
					
                	var json='{"id":'+EventId+',"cid":'+CalendarId+',"title":"'+Title+'","start":"'+startDate+'","end":"'+endDate+'","notes":"'+Notes+'","ad":'+IsAllDay+',"rem":"'+Reminder+'","gx":'+gx+'}';
                	Ext.Ajax.request({
                    	async : false,
        				clientValidation: true,
        				waitMsg: Msg_DengTai,
        				params: {state:'addOrUpdate',json:json},
        				url: Pro_Name + '/action/CalendarServlet',
        				method: 'POST',
        				// 删除成功的操作
        				success: function(response, action) {
        					var flag = Ext.decode(response.responseText).success;
        					if(flag == true) {
        						var calendar=mainTabs.queryById('calendarForm');
        						var index=calendar.eventStore.find('EventId',EventId);
        						if(index>=0){
        							calendar.eventStore.removeAt(index);	
        						}
        						obj['EventId']=Ext.decode(response.responseText).msg;;
    							calendar.eventStore.add(obj);
        						me.onCancel();
        						me.hide();	
        					} else {
        						Ext.Msg.alert(Msg_TiShi,Ext.decode(response.responseText).msg);
        					}
        				}
        			}); 
                	//me.onSave();
                } ,
                scope: this
            },
            {
                text: '取消',
                disabled: false,
                handler: this.onCancel,
                scope: this
            }],
            items: formPanelCfg
        },
        config)]);
    },

    newId: 10000,

    initComponent: function() {
        this.callParent();
        this.formPanel = this.items.items[0];

        this.addEvents({
            /**
             * @event eventadd
             * Fires after a new event is added
             * @param {Ext.calendar.form.EventWindow} this
             * @param {Ext.calendar.EventRecord} rec The new {@link Ext.calendar.EventRecord record} that was added
             */
            eventadd: true,
            /**
             * @event eventupdate
             * Fires after an existing event is updated
             * @param {Ext.calendar.form.EventWindow} this
             * @param {Ext.calendar.EventRecord} rec The new {@link Ext.calendar.EventRecord record} that was updated
             */
            eventupdate: true,
            /**
             * @event eventdelete
             * Fires after an event is deleted
             * @param {Ext.calendar.form.EventWindow} this
             * @param {Ext.calendar.EventRecord} rec The new {@link Ext.calendar.EventRecord record} that was deleted
             */
            eventdelete: true,
            /**
             * @event eventcancel
             * Fires after an event add/edit operation is canceled by the user and no store update took place
             * @param {Ext.calendar.form.EventWindow} this
             * @param {Ext.calendar.EventRecord} rec The new {@link Ext.calendar.EventRecord record} that was canceled
             */
            eventcancel: true,
            /**
             * @event editdetails
             * Fires when the user selects the option in this window to continue editing in the detailed edit form
             * (by default, an instance of {@link Ext.calendar.EventEditForm}. Handling code should hide this window
             * and transfer the current event record to the appropriate instance of the detailed form by showing it
             * and calling {@link Ext.calendar.EventEditForm#loadRecord loadRecord}.
             * @param {Ext.calendar.form.EventWindow} this
             * @param {Ext.calendar.EventRecord} rec The {@link Ext.calendar.EventRecord record} that is currently being edited
             */
            editdetails: true
        });
    },

    // private
    afterRender: function() {
        this.callParent();

        this.el.addCls('ext-cal-event-win');

        Ext.get('tblink').on('click', this.onEditDetailsClick, this);
        
        this.titleField = this.down('#title');
        this.remField=this.down('#rem');
        this.textareaField=this.down('#textarea');
        this.locField=this.down('#loc');
        this.dateRangeField = this.down('#date-range');
        this.calendarField = this.down('#calendar');
        this.QTGX=this.down('#QTGX');
        this.faburen=this.down('#faburen');
        this.deleteButton = this.down('#delete-btn');
        this.saveButton=this.down('#save-btn');
    },
    
    // private
    onEditDetailsClick: function(e){
        e.stopEvent();
        this.updateRecord(this.activeRecord, true);
        this.fireEvent('editdetails', this, this.activeRecord, this.animateTarget);
    },

    /**
     * Shows the window, rendering it first if necessary, or activates it and brings it to front if hidden.
	 * @param {Ext.data.Record/Object} o Either a {@link Ext.data.Record} if showing the form
	 * for an existing event in edit mode, or a plain object containing a StartDate property (and 
	 * optionally an EndDate property) for showing the form in add mode. 
     * @param {String/Element} animateTarget (optional) The target element or id from which the window should
     * animate while opening (defaults to null with no animation)
     * @return {Ext.Window} this
     */
    show: function(o, animateTarget) {
        // Work around the CSS day cell height hack needed for initial render in IE8/strict:
        var me = this,
            anim = (Ext.isIE8 && Ext.isStrict) ? null: animateTarget,
            M = Ext.calendar.data.EventMappings;

        this.callParent([anim, function(){
            me.titleField.focus(true);
        }]);

        this.deleteButton[o.data && o.data[M.EventId.name]? 'show': 'hide']();
        var rec,
        f = this.formPanel.form;

        if (o.data) {
            rec = o;
            this.setTitle(rec.phantom ? this.titleTextAdd : this.titleTextEdit);
            f.loadRecord(rec);
        }
        else {
            this.setTitle(this.titleTextAdd);

            var start = o[M.StartDate.name],
                end = o[M.EndDate.name] || Ext.calendar.util.Date.add(start, {hours: 1});

            rec = Ext.create('Ext.calendar.data.EventModel');
            rec.data[M.StartDate.name] = start;
            rec.data[M.EndDate.name] = end;
            rec.data[M.IsAllDay.name] = !!o[M.IsAllDay.name] || start.getDate() != Ext.calendar.util.Date.add(end, {millis: 1}).getDate();

            f.reset();
            rec.data.Reminder='-1';
           // rec.data.QTGX=true;
            f.loadRecord(rec);
        }

        if (this.calendarStore) {
            this.calendarField.setValue(rec.data[M.CalendarId.name]);
        }
        this.dateRangeField.setValue(rec.data);
        this.activeRecord = rec;
        if(rec.data.IsEditor=="false"){
        	for(var i=0;i<this.dateRangeField.items.length;i++){
        		if(i!=2){
        			this.dateRangeField.items.get(i).setReadOnly(true);
        			this.dateRangeField.items.get(i).setFieldStyle("color:gray;");
        		}	
        	}
        	for(var i=0;i<this.formPanel.items.length;i++){
        		if(i!=1&&i!=4){
        			this.formPanel.items.get(i).setReadOnly(true);	
        			this.formPanel.items.get(i).setFieldStyle("color:gray;");
        		}	
        	}
        	this.QTGX.setReadOnly(true);
        	this.deleteButton.hide();
        	this.saveButton.hide();
        	this.faburen.setVisible(true);
        }else{
        	for(var i=0;i<this.dateRangeField.items.length;i++){
        		if(i!=2){
        			this.dateRangeField.items.get(i).setReadOnly(false);
        			this.dateRangeField.items.get(i).setFieldStyle("color:black;");
        		}	
        	}
        	for(var i=0;i<this.formPanel.items.length;i++){
        		if(i!=1&&i!=4){
        			this.formPanel.items.get(i).setReadOnly(false);	
        			this.formPanel.items.get(i).setFieldStyle("color:black;");
        		}	
        	}
        	this.QTGX.setReadOnly(false);
        	this.saveButton.show();
        	this.faburen.setVisible(false);
        }
        	
        return this;
    },

    // private
    roundTime: function(dt, incr) {
        incr = incr || 15;
        var m = parseInt(dt.getMinutes(), 10);
        return dt.add('mi', incr - (m % incr));
    },

    // private
    onCancel: function() {
        this.cleanup(true);
        this.fireEvent('eventcancel', this);
    },

    // private
    cleanup: function(hide) {
        if (this.activeRecord && this.activeRecord.dirty) {
            this.activeRecord.reject();
        }
        delete this.activeRecord;

        if (hide === true) {
            // Work around the CSS day cell height hack needed for initial render in IE8/strict:
            //var anim = afterDelete || (Ext.isIE8 && Ext.isStrict) ? null : this.animateTarget;
            this.hide();
        }
    },

    // private
    updateRecord: function(record, keepEditing) {
    	
        var fields = record.fields,
            values = this.formPanel.getForm().getValues(),
            name,
            M = Ext.calendar.data.EventMappings,
            obj = {};

        fields.each(function(f) {
            name = f.name;
            if (name in values) {
                obj[name] = values[name];
            }
        });
        
        var dates = this.dateRangeField.getValue();
        obj[M.StartDate.name] = dates[0];
        obj[M.EndDate.name] = dates[1];
        obj[M.IsAllDay.name] = dates[2];
        	record.beginEdit();
 	        record.set(obj);
 	        if (!keepEditing) {
 	            record.endEdit();
 	        }
        return this;
    },
    
    // private
    onSave: function(){
        if(!this.formPanel.form.isValid()){
            return;
        }
	    if(!this.updateRecord(this.activeRecord)){
	    	this.onCancel();
	        return;
	   }
        this.fireEvent(this.activeRecord.phantom ? 'eventadd' : 'eventupdate', this, this.activeRecord, this.animateTarget);

        this.activeRecord.commit();
    },
    
    // private
    onDelete: function(){
        this.fireEvent('eventdelete', this, this.activeRecord, this.animateTarget);
    }
});