/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.prefixmapper;

import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.prefixmapper.MappingFileProvider;
import com.google.i18n.phonenumbers.prefixmapper.PhonePrefixMap;
import com.google.i18n.phonenumbers.prefixmapper.PhonePrefixMapStorageStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrefixFileReader {
    private static final Logger LOGGER = Logger.getLogger(PrefixFileReader.class.getName());
    private final String phonePrefixDataDirectory;
    private MappingFileProvider mappingFileProvider = new MappingFileProvider();
    public Map<String, PhonePrefixMap> availablePhonePrefixMaps = new HashMap<String, PhonePrefixMap>();

    public PrefixFileReader(String phonePrefixDataDirectory) {
        this.phonePrefixDataDirectory = phonePrefixDataDirectory;
        this.loadMappingFileProvider();
    }

    private void loadMappingFileProvider() {
        block5: {
            InputStream source = PrefixFileReader.class.getResourceAsStream(String.valueOf(this.phonePrefixDataDirectory) + "config");
            ObjectInputStream in = null;
            try {
                try {
                    in = new ObjectInputStream(source);
                    this.mappingFileProvider.readExternal(in);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.toString());
                    PrefixFileReader.close(in);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                PrefixFileReader.close(in);
                throw throwable;
            }
            PrefixFileReader.close(in);
        }
    }

    private PhonePrefixMap getPhonePrefixDescriptions(int prefixMapKey, String language, String script, String region) {
        String fileName = this.mappingFileProvider.getFileName(prefixMapKey, language, script, region);
        if (fileName.length() == 0) {
            return null;
        }
        if (!this.availablePhonePrefixMaps.containsKey(fileName)) {
            this.loadPhonePrefixMapFromFile(fileName);
        }
        return this.availablePhonePrefixMaps.get(fileName);
    }

    private void loadPhonePrefixMapFromFile(String fileName) {
        block5: {
            InputStream source = PrefixFileReader.class.getResourceAsStream(String.valueOf(this.phonePrefixDataDirectory) + fileName);
            ObjectInputStream in = null;
            try {
                try {
                    in = new ObjectInputStream(source);
                    PhonePrefixMap map = new PhonePrefixMap();
                    map.readExternal(in);
                    this.availablePhonePrefixMaps.put(fileName, map);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.toString());
                    PrefixFileReader.close(in);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                PrefixFileReader.close(in);
                throw throwable;
            }
            PrefixFileReader.close(in);
        }
    }

    private static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.toString());
            }
        }
    }

    public String getDescriptionForNumber(Phonenumber.PhoneNumber number, String lang, String script, String region) {
        String description;
        int countryCallingCode = number.getCountryCode();
        int phonePrefix = countryCallingCode != 1 ? countryCallingCode : 1000 + (int)(number.getNationalNumber() / 10000000L);
        PhonePrefixMap phonePrefixDescriptions = this.getPhonePrefixDescriptions(phonePrefix, lang, script, region);
        String string = description = phonePrefixDescriptions != null ? phonePrefixDescriptions.lookup(number) : null;
        if ((description == null || description.length() == 0) && this.mayFallBackToEnglish(lang)) {
            PhonePrefixMap defaultMap = this.getPhonePrefixDescriptions(phonePrefix, "en", "", "");
            if (defaultMap == null) {
                return "";
            }
            description = defaultMap.lookup(number);
        }
        return description != null ? description : "";
    }

    public Integer getNumberForDescription(String desc) {
        Integer code = null;
        int phonePrefix = 86;
        PhonePrefixMap phonePrefixDescriptions = this.getPhonePrefixDescriptions(phonePrefix, "zh", "", "CN");
        if (phonePrefixDescriptions != null) {
            PhonePrefixMapStorageStrategy s = phonePrefixDescriptions.getPhonePrefixMapStorage();
            int numOfEntries = s.getNumOfEntries();
            int i = 0;
            while (i < numOfEntries && s.getPrefix(i) <= 86999) {
                if (s.getDescription(i).equals(desc)) {
                    code = s.getPrefix(i);
                    break;
                }
                ++i;
            }
        }
        return code;
    }

    private boolean mayFallBackToEnglish(String lang) {
        return !lang.equals("zh") && !lang.equals("ja") && !lang.equals("ko");
    }
}

