/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeResolver
implements Serializable {
    private final BasicTypeRegistry basicTypeRegistry;
    private final TypeFactory typeFactory;
    private final List<BasicType> typeOverrides;
    private BasicTypeRegistry scopedTypeRegistry;

    public TypeResolver() {
        this(new BasicTypeRegistry(), new TypeFactory());
    }

    public TypeResolver(BasicTypeRegistry basicTypeRegistry, TypeFactory typeFactory) {
        this.basicTypeRegistry = basicTypeRegistry;
        this.typeOverrides = new ArrayList<BasicType>();
        this.typeFactory = typeFactory;
    }

    public TypeResolver scope(SessionFactoryImplementor factory) {
        this.typeFactory.injectSessionFactory(factory);
        this.scopedTypeRegistry = null;
        BasicTypeRegistry registry = this.basicTypeRegistry;
        List<BasicType> dialectTypeOverrides = factory.getDialect().getTypeOverrides();
        if (factory != null && !dialectTypeOverrides.isEmpty()) {
            this.scopedTypeRegistry = new BasicTypeRegistry();
            TypeResolver.registerTypeOverrides(this.scopedTypeRegistry, dialectTypeOverrides);
            TypeResolver.registerTypeOverrides(this.scopedTypeRegistry, this.typeOverrides);
            registry = this.scopedTypeRegistry;
        }
        return new TypeResolver(registry.shallowCopy(), this.typeFactory);
    }

    public void registerTypeOverride(BasicType type) {
        this.basicTypeRegistry.register(type);
        this.typeOverrides.add(type);
    }

    public void registerTypeOverride(UserType type, String[] keys) {
        this.basicTypeRegistry.register(type, keys);
        this.typeOverrides.add(new CustomType(type, keys));
    }

    public void registerTypeOverride(CompositeUserType type, String[] keys) {
        this.basicTypeRegistry.register(type, keys);
        this.typeOverrides.add(new CompositeCustomType(type, keys));
    }

    private static void registerTypeOverrides(BasicTypeRegistry typeRegistry, List<BasicType> typeOverrides) {
        for (BasicType typeOverride : typeOverrides) {
            typeRegistry.register(typeOverride);
        }
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public BasicType basic(String name) {
        return this.scopedTypeRegistry == null ? this.basicTypeRegistry.getRegisteredType(name) : this.scopedTypeRegistry.getRegisteredType(name);
    }

    public Type heuristicType(String typeName) throws MappingException {
        return this.heuristicType(typeName, null);
    }

    public Type heuristicType(String typeName, Properties parameters) throws MappingException {
        BasicType type = this.basic(typeName);
        if (type != null) {
            return type;
        }
        try {
            Class typeClass = ReflectHelper.classForName(typeName);
            if (typeClass != null) {
                return this.typeFactory.byClass(typeClass, parameters);
            }
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        return null;
    }
}

