/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Action;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.OSType;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.ComponentRef;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.javaws.Globals;
import com.sun.javaws.IconUtil;
import com.sun.javaws.LocalInstallHandlerFactory;
import com.sun.javaws.Main;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public abstract class LocalInstallHandler {
    private static LocalInstallHandler _installHandler;
    public static final int DESKTOP_INDEX = 0;
    public static final int MENU_INDEX = 1;

    public static synchronized LocalInstallHandler getInstance() {
        if (_installHandler == null) {
            _installHandler = LocalInstallHandlerFactory.newInstance();
        }
        return _installHandler;
    }

    public void install(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, boolean bl2, ComponentRef componentRef) {
        if (launchDesc.isApplicationDescriptor()) {
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (this.isLocalInstallSupported()) {
                Object[] objectArray;
                AssociationDesc[] associationDescArray = localApplicationProperties.getAssociations();
                if (associationDescArray == null || associationDescArray.length <= 0) {
                    objectArray = launchDesc.getInformation().getAssociations();
                    bl3 = this.isAssociationSupported() && objectArray != null && objectArray.length > 0;
                } else if (bl) {
                    this.removeAssociations(launchDesc, localApplicationProperties);
                    this.createAssociations(launchDesc, localApplicationProperties);
                }
                if (localApplicationProperties.isShortcutInstalled()) {
                    if (!localApplicationProperties.isShortcutInstalledSystem() && bl) {
                        objectArray = this.whichShortcutsExist(localApplicationProperties);
                        this.removeShortcuts(launchDesc, localApplicationProperties, true);
                        if (objectArray[0] == false && objectArray[1] == false) {
                            bl4 = true;
                        } else {
                            this.createShortcuts(launchDesc, localApplicationProperties, (boolean[])objectArray);
                        }
                    }
                } else {
                    bl4 = true;
                }
            } else if (!localApplicationProperties.getAskedForInstall()) {
                try {
                    this.performIntegration(componentRef, launchDesc, localApplicationProperties, bl2, false, false);
                }
                catch (Throwable throwable) {
                    Trace.ignored((Throwable)throwable);
                }
                localApplicationProperties.setAskedForInstall(true);
            }
            if ((bl4 || bl3) && !localApplicationProperties.getAskedForInstall()) {
                try {
                    this.performIntegration(componentRef, launchDesc, localApplicationProperties, bl2, bl4, bl3);
                }
                catch (Throwable throwable) {
                    Trace.ignored((Throwable)throwable);
                }
                localApplicationProperties.setAskedForInstall(true);
            }
            if (bl || localApplicationProperties.getLaunchCount() <= 1) {
                this.updateInstallPanel(launchDesc, localApplicationProperties);
            }
        }
    }

    public void updateInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        this.removeFromInstallPanel(launchDesc, localApplicationProperties, false);
        if (localApplicationProperties.isJnlpInstalled()) {
            this.registerWithInstallPanel(launchDesc, localApplicationProperties);
        }
    }

    public void uninstall(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        this.uninstall(launchDesc, localApplicationProperties, false);
    }

    public void uninstall(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
        this.removeShortcuts(launchDesc, localApplicationProperties, true);
        this.removeAssociations(launchDesc, localApplicationProperties);
        if (localApplicationProperties.isJnlpInstalled() || bl) {
            this.removeFromInstallPanel(launchDesc, localApplicationProperties, bl);
            localApplicationProperties.setJnlpInstalled(false);
        }
    }

    public abstract boolean isLocalInstallSupported();

    public abstract boolean isAssociationSupported();

    protected abstract boolean isAssociationFileExtSupported(String var1);

    public abstract String getAssociationOpenCommand(String var1);

    public abstract String getAssociationPrintCommand(String var1);

    public abstract void registerAssociationInternal(LaunchDesc var1, LocalApplicationProperties var2, Association var3) throws AssociationAlreadyRegisteredException, RegisterFailedException;

    public abstract void unregisterAssociationInternal(LaunchDesc var1, LocalApplicationProperties var2, Association var3) throws AssociationNotRegisteredException, RegisterFailedException;

    public abstract boolean hasAssociation(LaunchDesc var1, LocalApplicationProperties var2, Association var3);

    public abstract String getDefaultIconPath();

    public abstract boolean isShortcutExists(LocalApplicationProperties var1);

    public abstract boolean[] whichShortcutsExist(LocalApplicationProperties var1);

    protected abstract boolean createShortcuts(LaunchDesc var1, LocalApplicationProperties var2, boolean[] var3);

    protected abstract boolean removeShortcuts(LaunchDesc var1, LocalApplicationProperties var2, boolean var3);

    protected abstract boolean removePathShortcut(String var1);

    protected abstract void registerWithInstallPanel(LaunchDesc var1, LocalApplicationProperties var2);

    protected abstract void removeFromInstallPanel(LaunchDesc var1, LocalApplicationProperties var2, boolean var3);

    private String getJnlpLocation(LaunchDesc launchDesc) {
        File file = ResourceProvider.get().getCachedJNLPFile(launchDesc.getCanonicalHome(), null);
        String string = file != null ? file.getAbsolutePath() : launchDesc.getLocation().toString();
        return string;
    }

    private String getOpenActionCommand(Association association) {
        Action action = association.getActionByVerb("open");
        String string = null;
        if (action != null) {
            string = action.getCommand();
        }
        return string;
    }

    private boolean registerAssociation(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, String string, String string2, String string3, URL uRL) {
        String string4;
        Object object;
        AssociationService associationService = new AssociationService(localApplicationProperties);
        Association association = new Association();
        boolean bl = false;
        Association association2 = null;
        String string5 = "";
        String string6 = null;
        if (string != null) {
            object = new StringTokenizer(string);
            while (((StringTokenizer)object).hasMoreTokens()) {
                string4 = "." + ((StringTokenizer)object).nextToken();
                Trace.println((String)("associate with ext: " + string4), (TraceLevel)TraceLevel.BASIC);
                if (!this.isAssociationFileExtSupported(string4)) {
                    Trace.println((String)("association with ext: " + string4 + " is not supported"), (TraceLevel)TraceLevel.BASIC);
                    return false;
                }
                if (string5 == "") {
                    string5 = string4 + " file";
                }
                if ((association2 = associationService.getFileExtensionAssociation(string4)) != null) {
                    Trace.println((String)("associate with ext: " + string4 + " already EXIST"), (TraceLevel)TraceLevel.BASIC);
                    if (string6 == null) {
                        string6 = this.getOpenActionCommand(association2);
                    }
                    bl = true;
                    if (string6 == null || !this.promptReplace(launchDesc, string4, null, string6)) {
                        return false;
                    }
                }
                association.addFileExtension(string4);
            }
        }
        if (string3 != null && string3.length() > 0) {
            string5 = string3;
        }
        if (string2 != null) {
            Trace.println((String)("associate with mime: " + string2), (TraceLevel)TraceLevel.BASIC);
            association2 = associationService.getMimeTypeAssociation(string2);
            if (association2 != null & !bl) {
                Trace.println((String)("associate with mime: " + string2 + " already EXIST"), (TraceLevel)TraceLevel.BASIC);
                object = this.getOpenActionCommand(association2);
                if (object != string6 && !this.promptReplace(launchDesc, null, string2, (String)object)) {
                    return false;
                }
                bl = true;
            }
            association.setMimeType(string2);
        }
        association.setName(launchDesc.getInformation().getTitle());
        association.setDescription(string5);
        object = uRL != null ? IconUtil.getIconPath(uRL, null) : IconUtil.getIconPath(launchDesc);
        if (object == null) {
            object = this.getDefaultIconPath();
        }
        association.setIconFileName((String)object);
        String string7 = this.getJnlpLocation(launchDesc);
        String string8 = this.getAssociationOpenCommand(string7);
        String string9 = this.getAssociationPrintCommand(string7);
        Trace.println((String)("register OPEN using: " + string8), (TraceLevel)TraceLevel.BASIC);
        string4 = new Action("open", string8, "open the file");
        association.addAction((Action)string4);
        if (string9 != null) {
            Trace.println((String)("register PRINT using: " + string9), (TraceLevel)TraceLevel.BASIC);
            string4 = new Action("print", string9, "print the file");
            association.addAction((Action)string4);
        }
        try {
            this.registerAssociationInternal(launchDesc, localApplicationProperties, association);
        }
        catch (AssociationAlreadyRegisteredException associationAlreadyRegisteredException) {
            try {
                this.unregisterAssociationInternal(launchDesc, localApplicationProperties, association);
                this.registerAssociationInternal(launchDesc, localApplicationProperties, association);
            }
            catch (AssociationNotRegisteredException associationNotRegisteredException) {
                Trace.ignoredException((Exception)((Object)associationNotRegisteredException));
                return false;
            }
            catch (AssociationAlreadyRegisteredException associationAlreadyRegisteredException2) {
                Trace.ignoredException((Exception)((Object)associationAlreadyRegisteredException2));
                return false;
            }
            catch (RegisterFailedException registerFailedException) {
                Trace.ignoredException((Exception)((Object)registerFailedException));
                return false;
            }
        }
        catch (RegisterFailedException registerFailedException) {
            Trace.ignoredException((Exception)((Object)registerFailedException));
            return false;
        }
        return true;
    }

    private void unregisterAssociation(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, String string, String string2) {
        AssociationService associationService = new AssociationService(localApplicationProperties);
        Association association = null;
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = "." + stringTokenizer.nextToken();
                association = associationService.getFileExtensionAssociation(string3);
                if (association == null) continue;
                association.setName(launchDesc.getInformation().getTitle());
                Trace.println((String)("remove association with ext: " + string3), (TraceLevel)TraceLevel.BASIC);
                try {
                    this.unregisterAssociationInternal(launchDesc, localApplicationProperties, association);
                }
                catch (AssociationNotRegisteredException associationNotRegisteredException) {
                    Trace.ignoredException((Exception)((Object)associationNotRegisteredException));
                }
                catch (RegisterFailedException registerFailedException) {
                    Trace.ignoredException((Exception)((Object)registerFailedException));
                }
            }
        }
        if (string != null && (association = associationService.getMimeTypeAssociation(string)) != null) {
            association.setName(launchDesc.getInformation().getTitle());
            Trace.println((String)("remove association with mime: " + string), (TraceLevel)TraceLevel.BASIC);
            try {
                this.unregisterAssociationInternal(launchDesc, localApplicationProperties, association);
            }
            catch (AssociationNotRegisteredException associationNotRegisteredException) {
                Trace.ignoredException((Exception)((Object)associationNotRegisteredException));
            }
            catch (RegisterFailedException registerFailedException) {
                Trace.ignoredException((Exception)((Object)registerFailedException));
            }
        }
    }

    public void removeAssociations(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        AssociationDesc[] associationDescArray;
        if (this.isAssociationSupported() && (associationDescArray = localApplicationProperties.getAssociations()) != null) {
            for (int i = 0; i < associationDescArray.length; ++i) {
                String string = associationDescArray[i].getExtensions();
                String string2 = associationDescArray[i].getMimeType();
                this.removeAssociationIfCurent(launchDesc, localApplicationProperties, string2, string);
            }
            localApplicationProperties.setAssociations(null);
        }
    }

    private void removeAssociationIfCurent(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, String string, String string2) {
        String string3 = this.getAssociationOpenCommand(this.getJnlpLocation(launchDesc));
        AssociationService associationService = new AssociationService(localApplicationProperties);
        Association association = associationService.getMimeTypeAssociation(string);
        if (association != null) {
            String string4 = this.getOpenActionCommand(association);
            if (string3.equals(string4)) {
                this.unregisterAssociation(launchDesc, localApplicationProperties, string, string2);
            } else {
                Trace.println((String)("Not removing association because existing command is: " + string4 + " instead of: " + string3), (TraceLevel)TraceLevel.BASIC);
            }
        }
    }

    public boolean createAssociations(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        if (Config.getAssociationValue() == 0) {
            return false;
        }
        boolean bl = true;
        if (this.isAssociationSupported()) {
            AssociationDesc[] associationDescArray = launchDesc.getInformation().getAssociations();
            for (int i = 0; associationDescArray != null && i < associationDescArray.length; ++i) {
                URL uRL;
                String string;
                String string2;
                String string3 = associationDescArray[i].getExtensions();
                if (this.registerAssociation(launchDesc, localApplicationProperties, string3, string2 = associationDescArray[i].getMimeType(), string = associationDescArray[i].getMimeDescription(), uRL = associationDescArray[i].getIconUrl())) {
                    localApplicationProperties.addAssociation(associationDescArray[i]);
                    LocalInstallHandler.save(localApplicationProperties);
                    continue;
                }
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean performIntegration(ComponentRef componentRef, LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = true;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = launchDesc.getSecurityModel() != 0;
        ShortcutDesc shortcutDesc = launchDesc.getInformation().getShortcut();
        if (shortcutDesc != null) {
            if (!(shortcutDesc.getDesktop() || shortcutDesc.getMenu() || OSType.isMac())) {
                bl2 = false;
            }
            bl12 = shortcutDesc.getInstall();
        }
        if (bl2) {
            if (bl) {
                bl7 = Globals.createShortcut() || Config.getShortcutValue() == 1 || Config.getShortcutValue() == 4;
                bl10 = false;
            } else {
                switch (Config.getShortcutValue()) {
                    case 0: {
                        bl7 = false;
                        bl10 = false;
                        break;
                    }
                    case 1: {
                        bl7 = true;
                        bl10 = false;
                        break;
                    }
                    case 4: {
                        bl7 = shortcutDesc != null;
                        bl10 = false;
                        break;
                    }
                    case 3: {
                        bl7 = shortcutDesc != null;
                        bl10 = shortcutDesc != null;
                        break;
                    }
                    default: {
                        bl7 = true;
                        bl10 = true;
                    }
                }
            }
        }
        if (bl3) {
            AssociationService associationService = new AssociationService(localApplicationProperties);
            boolean bl14 = true;
            AssociationDesc[] associationDescArray = launchDesc.getInformation().getAssociations();
            block21: for (int i = 0; associationDescArray != null && i < associationDescArray.length; ++i) {
                if (associationService.getMimeTypeAssociation(associationDescArray[i].getMimeType()) != null) {
                    bl14 = false;
                    break;
                }
                String string = associationDescArray[i].getExtensions();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = "." + stringTokenizer.nextToken();
                    if (associationService.getFileExtensionAssociation(string2) == null) continue;
                    bl14 = false;
                    continue block21;
                }
            }
            if (bl) {
                bl11 = false;
                switch (Config.getAssociationValue()) {
                    case 0: {
                        bl8 = false;
                        break;
                    }
                    case 1: {
                        bl8 = bl14;
                        break;
                    }
                    case 3: {
                        bl8 = bl14 || Globals.createAssoc();
                        break;
                    }
                    case 4: {
                        bl8 = true;
                        break;
                    }
                    default: {
                        bl8 = Globals.createAssoc();
                        break;
                    }
                }
            } else {
                switch (Config.getAssociationValue()) {
                    case 0: {
                        bl8 = false;
                        bl11 = false;
                        break;
                    }
                    case 1: {
                        bl8 = bl14;
                        bl11 = false;
                        break;
                    }
                    case 3: {
                        bl8 = true;
                        bl11 = !bl14;
                        break;
                    }
                    case 4: {
                        bl8 = true;
                        bl11 = false;
                        break;
                    }
                    default: {
                        bl8 = true;
                        bl11 = true;
                    }
                }
            }
        }
        if (bl12) {
            switch (Config.getInstallMode()) {
                case 0: 
                case 1: 
                case 2: {
                    bl9 = false;
                    break;
                }
                default: {
                    bl9 = true;
                }
            }
        }
        if (bl10 || bl11) {
            if (!Environment.isImportMode() && bl13 || this.showDialog(componentRef == null ? null : componentRef.get(), launchDesc, localApplicationProperties, bl7, bl8)) {
                if (bl10) {
                    bl7 = true;
                }
                if (bl11) {
                    bl8 = true;
                }
            } else {
                if (bl10) {
                    bl7 = false;
                }
                if (bl11) {
                    bl8 = false;
                }
            }
        }
        if (bl7) {
            bl4 = this.installShortcuts(launchDesc, localApplicationProperties, null);
        }
        if (bl8) {
            bl5 = this.createAssociations(launchDesc, localApplicationProperties);
        }
        if (bl9) {
            localApplicationProperties.setJnlpInstalled(true);
            this.updateInstallPanel(launchDesc, localApplicationProperties);
            LocalInstallHandler.save(localApplicationProperties);
        }
        return bl4 && bl5;
    }

    public boolean installShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        boolean bl = this.installShortcuts(launchDesc, localApplicationProperties, null);
        return bl;
    }

    private boolean installShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean[] blArray) {
        Object object;
        int n;
        boolean bl = this.createShortcuts(launchDesc, localApplicationProperties, blArray);
        localApplicationProperties.setAskedForInstall(true);
        RContentDesc[] rContentDescArray = launchDesc.getInformation().getRelatedContent();
        if (rContentDescArray != null) {
            for (n = 0; n < rContentDescArray.length; ++n) {
                object = rContentDescArray[n].getHref();
                if ("jar".equals(((URL)object).getProtocol()) || !((URL)object).toString().endsWith(".jnlp")) continue;
                try {
                    Main.importApp(((URL)object).toString());
                    continue;
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
            }
        }
        if (bl && !localApplicationProperties.isJnlpInstalled()) {
            n = Config.getInstallMode();
            object = launchDesc.getInformation().getShortcut();
            if (n == 1 || n == 2 && object != null && ((ShortcutDesc)object).getInstall()) {
                localApplicationProperties.setJnlpInstalled(true);
                this.updateInstallPanel(launchDesc, localApplicationProperties);
                LocalInstallHandler.save(localApplicationProperties);
            }
        }
        return bl;
    }

    private boolean showDialog(Object object, LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, boolean bl2) {
        AssociationDesc[] associationDescArray;
        InformationDesc informationDesc = launchDesc.getInformation();
        IconDesc iconDesc = informationDesc.getIconLocation(48, 0);
        URL uRL = iconDesc == null ? null : iconDesc.getLocation();
        String string = iconDesc == null ? null : iconDesc.getVersion();
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = null;
        if (bl) {
            associationDescArray = informationDesc.getShortcut();
            if (associationDescArray != null) {
                bl3 = associationDescArray.getDesktop();
                bl4 = associationDescArray.getMenu();
                string2 = associationDescArray.getSubmenu();
            } else {
                bl3 = true;
                bl4 = true;
            }
        }
        associationDescArray = bl2 ? informationDesc.getAssociations() : new AssociationDesc[]{};
        AppInfo appInfo = new AppInfo(launchDesc.getLaunchType(), informationDesc.getTitle(), informationDesc.getVendor(), launchDesc.getCanonicalHome(), launchDesc.getSourceURL(), uRL, string, bl3, bl4, string2, associationDescArray);
        UIFactory uIFactory = ToolkitStore.getUI();
        ToolkitStore.getUI();
        int n = uIFactory.showMessageDialog(object, appInfo, 5, null, null, null, null, null, null, null);
        ToolkitStore.getUI();
        return n == 0;
    }

    private boolean promptReplace(LaunchDesc launchDesc, String string, String string2, String string3) {
        Object object;
        String string4;
        String string5 = string != null ? ResourceManager.getString((String)"association.replace.ext", (String)string) : ResourceManager.getString((String)"association.replace.mime", (String)string2);
        String string6 = string3;
        String string7 = ResourceProvider.get().getCacheDir().toString();
        int n = string3.indexOf(string7);
        if (n >= 0) {
            int n2 = string3.indexOf("\"", n + string7.length());
            if (n2 < 0) {
                n2 = string3.indexOf(" ", n + string7.length());
            }
            string4 = n2 >= 0 ? string3.substring(n, n2) : string3.substring(n);
            try {
                object = LaunchDescFactory.buildDescriptor(string4);
                if (object != null) {
                    string6 = ((LaunchDesc)object).getInformation().getTitle();
                    if (((LaunchDesc)object).getCanonicalHome().toString().equals(launchDesc.getCanonicalHome().toString())) {
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                return true;
            }
        }
        string4 = ResourceManager.getString((String)"association.replace.info", (String)string6);
        String string8 = ResourceManager.getString((String)"association.replace.title");
        object = ResourceManager.getString((String)"common.ok_btn");
        String string9 = ResourceManager.getString((String)"common.cancel_btn");
        UIFactory uIFactory = ToolkitStore.getUI();
        AppInfo appInfo = launchDesc.getAppInfo();
        ToolkitStore.getUI();
        int n3 = uIFactory.showMessageDialog(null, appInfo, 3, string8, null, string5, string4, (String)object, string9, null);
        ToolkitStore.getUI();
        return n3 == 0;
    }

    public boolean uninstallShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        return this.removeShortcuts(launchDesc, localApplicationProperties, true);
    }

    public static boolean shouldInstallOverExisting(final LaunchDesc launchDesc) {
        int[] nArray = new int[1];
        ToolkitStore.getUI();
        nArray[0] = -1;
        final int[] nArray2 = nArray;
        Runnable runnable = new Runnable(){

            public void run() {
                String string = ResourceManager.getString((String)"install.alreadyInstalledTitle");
                String string2 = ResourceManager.getString((String)"install.alreadyInstalled", (String)launchDesc.getInformation().getTitle());
                String string3 = ResourceManager.getString((String)"common.ok_btn");
                String string4 = ResourceManager.getString((String)"common.cancel_btn");
                UIFactory uIFactory = ToolkitStore.getUI();
                AppInfo appInfo = launchDesc.getAppInfo();
                ToolkitStore.getUI();
                nArray2[0] = uIFactory.showMessageDialog(null, appInfo, 3, string, null, string2, null, string3, string4, null);
            }
        };
        if (!Globals.isSilentMode()) {
            LocalInstallHandler.invokeRunnable(runnable);
        }
        int n = nArray2[0];
        ToolkitStore.getUI();
        return n == 0;
    }

    public static void invokeRunnable(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static void save(LocalApplicationProperties localApplicationProperties) {
        try {
            localApplicationProperties.store();
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
    }

    public boolean addUninstallShortcut() {
        return Config.getBooleanProperty((String)"deployment.javaws.uninstall.shortcut") && !Environment.isSystemCacheMode();
    }

    boolean removeShortcuts(String string) {
        return this.removePathShortcut(string);
    }

    void removeAssociations(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, String string, String string2) {
        Association association = new Association();
        String string3 = "";
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = "." + stringTokenizer.nextToken();
                if (string3 == "") {
                    string3 = string4 + " file";
                }
                association.addFileExtension(string4);
            }
        }
        if (string != null) {
            association.setMimeType(string);
        }
        association.setName(" ");
        association.setDescription(string3);
        try {
            this.unregisterAssociationInternal(launchDesc, localApplicationProperties, association);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
    }

    void reinstallShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, boolean bl2) {
        boolean[] blArray = new boolean[]{bl, bl2};
        this.installShortcuts(launchDesc, localApplicationProperties, blArray);
    }

    void reinstallAssociations(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        this.createAssociations(launchDesc, localApplicationProperties);
    }

    protected String checkTitleString(String string, String string2, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Config.isJavaVersionAtLeast15()) {
            int n;
            for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                n = string.codePointAt(i);
                if (string2.indexOf(n) >= 0) {
                    stringBuffer.appendCodePoint(c);
                    continue;
                }
                if (!LocalInstallHandler.isShortCutSafe(n)) {
                    stringBuffer.appendCodePoint(c);
                    continue;
                }
                stringBuffer.appendCodePoint(n);
            }
        } else {
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (string2.indexOf(c2) >= 0) {
                    stringBuffer.append(c);
                    continue;
                }
                if (!LocalInstallHandler.isShortCutSafe14(c2)) {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(c2);
            }
        }
        return stringBuffer.toString();
    }

    private static boolean isShortCutSafe(int n) {
        return !Character.isIdentifierIgnorable(n) && n >= 32;
    }

    private static boolean isShortCutSafe14(char c) {
        return !Character.isIdentifierIgnorable(c) && c >= ' ';
    }
}

