/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import ezvcard.util.ISOFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;

public class VCardDateFormatter {
    public static String format(Date date, ISOFormat format) {
        return VCardDateFormatter.format(date, format, TimeZone.getDefault());
    }

    public static String format(Date date, ISOFormat format, TimeZone timeZone) {
        switch (format) {
            case UTC_TIME_BASIC: 
            case UTC_TIME_EXTENDED: {
                timeZone = TimeZone.getTimeZone("UTC");
            }
        }
        DateFormat df = format.getFormatDateFormat();
        df.setTimeZone(timeZone);
        String str = df.format(date);
        switch (format) {
            case TIME_EXTENDED: {
                str = str.replaceAll("([-\\+]\\d{2})(\\d{2})$", "$1:$2");
            }
        }
        return str;
    }

    public static Date parse(String dateStr) {
        Enum format = null;
        for (ISOFormat f : ISOFormat.values()) {
            if (!f.matches(dateStr)) continue;
            format = f;
            break;
        }
        if (format == null) {
            throw new IllegalArgumentException("Date string is not in a valid ISO-8601 format.");
        }
        switch (1.$SwitchMap$ezvcard$util$ISOFormat[format.ordinal()]) {
            case 3: 
            case 4: {
                dateStr = dateStr.replaceAll("([-\\+]\\d{2}):(\\d{2})$", "$1$2");
                break;
            }
            case 1: 
            case 2: {
                dateStr = dateStr.replace("Z", "+0000");
            }
        }
        DateFormat df = ((ISOFormat)format).getParseDateFormat();
        try {
            return df.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static TimeZone parseTimeZoneId(String timezoneId) {
        TimeZone timezone = TimeZone.getTimeZone(timezoneId);
        return "GMT".equals(timezone.getID()) ? null : timezone;
    }

    private VCardDateFormatter() {
    }
}

