/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.parameter.RelatedType;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Related
extends VCardProperty
implements HasAltId {
    private String uri;
    private String text;

    @Override
    public Set<VCardVersion> _supportedVersions() {
        return EnumSet.of(VCardVersion.V4_0);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUriEmail(String email) {
        this.setUri("mailto:" + email);
    }

    public void setUriIM(String protocol, String handle) {
        this.setUri(protocol + ":" + handle);
    }

    public void setUriTelephone(String telephone) {
        this.setUri("tel:" + telephone);
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.text = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.uri = null;
    }

    public Set<RelatedType> getTypes() {
        Set<String> values = this.parameters.getTypes();
        HashSet<RelatedType> types = new HashSet<RelatedType>(values.size());
        for (String value : values) {
            types.add(RelatedType.get(value));
        }
        return types;
    }

    public void addType(RelatedType type) {
        this.parameters.addType(type.getValue());
    }

    public void removeType(RelatedType type) {
        this.parameters.removeType(type.getValue());
    }

    @Override
    public List<Integer[]> getPids() {
        return super.getPids();
    }

    @Override
    public void addPid(int localId, int clientPidMapRef) {
        super.addPid(localId, clientPidMapRef);
    }

    @Override
    public void removePids() {
        super.removePids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<String> warnings, VCardVersion version, VCard vcard) {
        if (this.uri == null && this.text == null) {
            warnings.add("Property has neither a URI nor a text value associated with it.");
        }
    }
}

