/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.parameter.AddressType;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Address
extends VCardProperty
implements HasAltId {
    private String poBox;
    private String extendedAddress;
    private String streetAddress;
    private String locality;
    private String region;
    private String postalCode;
    private String country;

    public String getPoBox() {
        return this.poBox;
    }

    public void setPoBox(String poBox) {
        this.poBox = poBox;
    }

    public String getExtendedAddress() {
        return this.extendedAddress;
    }

    public void setExtendedAddress(String extendedAddress) {
        this.extendedAddress = extendedAddress;
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public void setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Set<AddressType> getTypes() {
        Set<String> values = this.parameters.getTypes();
        HashSet<AddressType> types = new HashSet<AddressType>(values.size());
        for (String value : values) {
            types.add(AddressType.get(value));
        }
        return types;
    }

    public void addType(AddressType type) {
        this.parameters.addType(type.getValue());
    }

    public void removeType(AddressType type) {
        this.parameters.removeType(type.getValue());
    }

    @Override
    public String getLanguage() {
        return super.getLanguage();
    }

    @Override
    public void setLanguage(String language) {
        super.setLanguage(language);
    }

    public String getLabel() {
        return this.parameters.getLabel();
    }

    public void setLabel(String label) {
        this.parameters.setLabel(label);
    }

    public double[] getGeo() {
        return this.parameters.getGeo();
    }

    public void setGeo(double latitude, double longitude) {
        this.parameters.setGeo(latitude, longitude);
    }

    @Override
    public List<Integer[]> getPids() {
        return super.getPids();
    }

    @Override
    public void addPid(int localId, int clientPidMapRef) {
        super.addPid(localId, clientPidMapRef);
    }

    @Override
    public void removePids() {
        super.removePids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    public String getTimezone() {
        return this.parameters.getTimezone();
    }

    public void setTimezone(String timezone) {
        this.parameters.setTimezone(timezone);
    }

    @Override
    protected void _validate(List<String> warnings, VCardVersion version, VCard vcard) {
        for (AddressType type : this.getTypes()) {
            if (type == AddressType.PREF || type.isSupported(version)) continue;
            warnings.add("Type value \"" + type.getValue() + "\" is not supported in version " + version.getVersion() + ".");
        }
    }
}

