/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.xml;

import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardNamespaceContext;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.ProductId;
import ezvcard.property.VCardProperty;
import ezvcard.property.Xml;
import ezvcard.util.IOUtils;
import ezvcard.util.ListMultimap;
import ezvcard.util.StringUtils;
import ezvcard.util.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCardDocument {
    private static final VCardVersion version4 = VCardVersion.V4_0;
    private static final XCardNamespaceContext nsContext = new XCardNamespaceContext(version4, "v");
    private final Map<String, VCardDataType> parameterDataTypes = new HashMap<String, VCardDataType>();
    private ScribeIndex index;
    private boolean addProdId;
    private boolean versionStrict;
    private final List<List<String>> parseWarnings;
    private Document document;
    private Element root;

    public XCardDocument() {
        this.registerParameterDataType("ALTID", VCardDataType.TEXT);
        this.registerParameterDataType("CALSCALE", VCardDataType.TEXT);
        this.registerParameterDataType("GEO", VCardDataType.URI);
        this.registerParameterDataType("LABEL", VCardDataType.TEXT);
        this.registerParameterDataType("LANGUAGE", VCardDataType.LANGUAGE_TAG);
        this.registerParameterDataType("MEDIATYPE", VCardDataType.TEXT);
        this.registerParameterDataType("PID", VCardDataType.TEXT);
        this.registerParameterDataType("PREF", VCardDataType.INTEGER);
        this.registerParameterDataType("SORT-AS", VCardDataType.TEXT);
        this.registerParameterDataType("TYPE", VCardDataType.TEXT);
        this.registerParameterDataType("TZ", VCardDataType.URI);
        this.index = new ScribeIndex();
        this.addProdId = true;
        this.versionStrict = true;
        this.parseWarnings = new ArrayList<List<String>>();
        this.document = XmlUtils.createDocument();
        this.root = this.createElement("vcards");
        this.document.appendChild(this.root);
    }

    public XCardDocument(String xml) throws SAXException {
        this(XmlUtils.toDocument(xml));
    }

    public XCardDocument(InputStream in) throws SAXException, IOException {
        this(XmlUtils.toDocument(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XCardDocument(File file) throws SAXException, IOException {
        this.registerParameterDataType("ALTID", VCardDataType.TEXT);
        this.registerParameterDataType("CALSCALE", VCardDataType.TEXT);
        this.registerParameterDataType("GEO", VCardDataType.URI);
        this.registerParameterDataType("LABEL", VCardDataType.TEXT);
        this.registerParameterDataType("LANGUAGE", VCardDataType.LANGUAGE_TAG);
        this.registerParameterDataType("MEDIATYPE", VCardDataType.TEXT);
        this.registerParameterDataType("PID", VCardDataType.TEXT);
        this.registerParameterDataType("PREF", VCardDataType.INTEGER);
        this.registerParameterDataType("SORT-AS", VCardDataType.TEXT);
        this.registerParameterDataType("TYPE", VCardDataType.TEXT);
        this.registerParameterDataType("TZ", VCardDataType.URI);
        this.index = new ScribeIndex();
        this.addProdId = true;
        this.versionStrict = true;
        this.parseWarnings = new ArrayList<List<String>>();
        FileInputStream in = new FileInputStream(file);
        try {
            this.init(XmlUtils.toDocument(in));
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public XCardDocument(Reader reader) throws SAXException, IOException {
        this(XmlUtils.toDocument(reader));
    }

    public XCardDocument(Document document) {
        this.registerParameterDataType("ALTID", VCardDataType.TEXT);
        this.registerParameterDataType("CALSCALE", VCardDataType.TEXT);
        this.registerParameterDataType("GEO", VCardDataType.URI);
        this.registerParameterDataType("LABEL", VCardDataType.TEXT);
        this.registerParameterDataType("LANGUAGE", VCardDataType.LANGUAGE_TAG);
        this.registerParameterDataType("MEDIATYPE", VCardDataType.TEXT);
        this.registerParameterDataType("PID", VCardDataType.TEXT);
        this.registerParameterDataType("PREF", VCardDataType.INTEGER);
        this.registerParameterDataType("SORT-AS", VCardDataType.TEXT);
        this.registerParameterDataType("TYPE", VCardDataType.TEXT);
        this.registerParameterDataType("TZ", VCardDataType.URI);
        this.index = new ScribeIndex();
        this.addProdId = true;
        this.versionStrict = true;
        this.parseWarnings = new ArrayList<List<String>>();
        this.init(document);
    }

    private void init(Document document) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsContext);
        try {
            String prefix = nsContext.getPrefix();
            this.root = (Element)xpath.evaluate("//" + prefix + ":vcards", document, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    public boolean isAddProdId() {
        return this.addProdId;
    }

    public void setAddProdId(boolean addProdId) {
        this.addProdId = addProdId;
    }

    public boolean isVersionStrict() {
        return this.versionStrict;
    }

    public void setVersionStrict(boolean versionStrict) {
        this.versionStrict = versionStrict;
    }

    public List<List<String>> getParseWarnings() {
        return this.parseWarnings;
    }

    public void registerParameterDataType(String parameterName, VCardDataType dataType) {
        parameterName = parameterName.toLowerCase();
        if (dataType == null) {
            this.parameterDataTypes.remove(parameterName);
        } else {
            this.parameterDataTypes.put(parameterName, dataType);
        }
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public Document getDocument() {
        return this.document;
    }

    public List<VCard> parseAll() {
        this.parseWarnings.clear();
        if (this.root == null) {
            return Collections.emptyList();
        }
        ArrayList<VCard> vcards = new ArrayList<VCard>();
        for (Element vcardElement : this.getVCardElements()) {
            ArrayList<String> warnings = new ArrayList<String>();
            this.parseWarnings.add(warnings);
            VCard vcard = this.parseVCardElement(vcardElement, warnings);
            vcards.add(vcard);
        }
        return vcards;
    }

    public VCard parseFirst() {
        this.parseWarnings.clear();
        if (this.root == null) {
            return null;
        }
        List<Element> vcardElements = this.getVCardElements();
        if (vcardElements.isEmpty()) {
            return null;
        }
        ArrayList<String> warnings = new ArrayList<String>();
        this.parseWarnings.add(warnings);
        return this.parseVCardElement(vcardElements.get(0), warnings);
    }

    private VCard parseVCardElement(Element vcardElement, List<String> warnings) {
        VCard vcard = new VCard();
        vcard.setVersion(version4);
        String ns = version4.getXmlNamespace();
        List<Element> children = XmlUtils.toElementList(vcardElement.getChildNodes());
        for (Element child : children) {
            if ("group".equals(child.getLocalName()) && ns.equals(child.getNamespaceURI())) {
                String group = child.getAttribute("name");
                if (group.length() == 0) {
                    group = null;
                }
                List<Element> propElements = XmlUtils.toElementList(child.getChildNodes());
                for (Element propElement : propElements) {
                    this.parseAndAddElement(propElement, group, vcard, warnings);
                }
                continue;
            }
            this.parseAndAddElement(child, null, vcard, warnings);
        }
        return vcard;
    }

    private void parseAndAddElement(Element element, String group, VCard vcard, List<String> warnings) {
        VCardProperty property;
        VCardParameters parameters = this.parseSubTypes(element);
        String propertyName = element.getLocalName();
        String ns = element.getNamespaceURI();
        VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(new QName(ns, propertyName));
        try {
            VCardPropertyScribe.Result<? extends VCardProperty> result = scribe.parseXml(element, parameters);
            property = result.getProperty();
            property.setGroup(group);
            for (String warning : result.getWarnings()) {
                this.addWarning(warning, propertyName, warnings);
            }
        }
        catch (SkipMeException e) {
            this.addWarning("Property has requested that it be skipped: " + e.getMessage(), propertyName, warnings);
            return;
        }
        catch (CannotParseException e) {
            String xml = XmlUtils.toString(element);
            this.addWarning("Property value could not be parsed.  It will be unmarshalled as a " + Xml.class.getSimpleName() + " property instead." + StringUtils.NEWLINE + "  XML: " + xml + StringUtils.NEWLINE + "  Reason: " + e.getMessage(), propertyName, warnings);
            scribe = this.index.getPropertyScribe(Xml.class);
            VCardPropertyScribe.Result<? extends VCardProperty> result = scribe.parseXml(element, parameters);
            property = result.getProperty();
            property.setGroup(group);
        }
        catch (UnsupportedOperationException e) {
            scribe = this.index.getPropertyScribe(Xml.class);
            VCardPropertyScribe.Result<? extends VCardProperty> result = scribe.parseXml(element, parameters);
            property = result.getProperty();
            property.setGroup(group);
            this.addWarning("Property class \"" + property.getClass().getName() + "\" does not support xCard unmarshalling.  It will be unmarshalled as a " + Xml.class.getSimpleName() + " property instead.", propertyName, warnings);
        }
        catch (EmbeddedVCardException e) {
            this.addWarning("Property will not be unmarshalled because xCard does not supported embedded vCards.", propertyName, warnings);
            return;
        }
        vcard.addProperty(property);
    }

    private VCardParameters parseSubTypes(Element element) {
        VCardParameters subTypes = new VCardParameters();
        List<Element> parametersElements = XmlUtils.toElementList(element.getElementsByTagNameNS(version4.getXmlNamespace(), "parameters"));
        for (Element parametersElement : parametersElements) {
            List<Element> paramElements = XmlUtils.toElementList(parametersElement.getChildNodes());
            for (Element paramElement : paramElements) {
                String name = paramElement.getLocalName().toUpperCase();
                List<Element> valueElements = XmlUtils.toElementList(paramElement.getChildNodes());
                if (valueElements.isEmpty()) {
                    String value = paramElement.getTextContent();
                    subTypes.put(name, value);
                    continue;
                }
                for (Element valueElement : valueElements) {
                    String value = valueElement.getTextContent();
                    subTypes.put(name, value);
                }
            }
        }
        return subTypes;
    }

    public String write() {
        return this.write(-1);
    }

    public String write(int indent) {
        StringWriter sw = new StringWriter();
        try {
            this.write(sw, indent);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return sw.toString();
    }

    public void write(OutputStream out) throws TransformerException {
        this.write(out, -1);
    }

    public void write(OutputStream out, int indent) throws TransformerException {
        this.write(IOUtils.utf8Writer(out), indent);
    }

    public void write(File file) throws TransformerException, IOException {
        this.write(file, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, int indent) throws TransformerException, IOException {
        Writer writer = IOUtils.utf8Writer(file);
        try {
            this.write(writer, indent);
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    public void write(Writer writer) throws TransformerException {
        this.write(writer, -1);
    }

    public void write(Writer writer, int indent) throws TransformerException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (indent >= 0) {
            properties.put("indent", "yes");
            properties.put("{http://xml.apache.org/xslt}indent-amount", indent + "");
        }
        XmlUtils.toWriter(this.document, writer, properties);
    }

    public void add(VCard vcard) {
        ListMultimap<String, VCardProperty> typesToAdd = new ListMultimap<String, VCardProperty>();
        for (VCardProperty type : vcard) {
            if (this.addProdId && type instanceof ProductId || this.versionStrict && !type.getSupportedVersions().contains((Object)version4)) continue;
            if (this.index.getPropertyScribe(type) == null) {
                throw new IllegalArgumentException("No scribe found for property class \"" + type.getClass().getName() + "\".");
            }
            typesToAdd.put(type.getGroup(), type);
        }
        if (this.addProdId) {
            ProductId prodId = new ProductId("ez-vcard " + Ezvcard.VERSION);
            typesToAdd.put(prodId.getGroup(), prodId);
        }
        Element vcardElement = this.createElement("vcard");
        for (String groupName : typesToAdd.keySet()) {
            Element parent;
            if (groupName != null) {
                Element groupElement = this.createElement("group");
                groupElement.setAttribute("name", groupName);
                vcardElement.appendChild(groupElement);
                parent = groupElement;
            } else {
                parent = vcardElement;
            }
            for (VCardProperty type : typesToAdd.get(groupName)) {
                try {
                    Element typeElement = this.marshalType(type, vcard);
                    parent.appendChild(typeElement);
                }
                catch (SkipMeException e) {
                }
                catch (EmbeddedVCardException e) {}
            }
        }
        this.root.appendChild(vcardElement);
    }

    private Element marshalType(VCardProperty type, VCard vcard) {
        VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(type);
        if (scribe == null) {
            throw new IllegalArgumentException("No marshaller found for property class \"" + type.getClass().getName() + "\".");
        }
        VCardParameters parameters = scribe.prepareParameters(type, version4, vcard);
        QName qname = scribe.getQName();
        Element typeElement = this.createElement(qname.getLocalPart(), qname.getNamespaceURI());
        if (!parameters.isEmpty()) {
            Element parametersElement = this.marshalSubTypes(parameters);
            typeElement.appendChild(parametersElement);
        }
        scribe.writeXml(type, typeElement);
        return typeElement;
    }

    private Element marshalSubTypes(VCardParameters parameters) {
        Element parametersElement = this.createElement("parameters");
        for (Map.Entry param : parameters) {
            String parameterName = ((String)param.getKey()).toLowerCase();
            Element parameterElement = this.createElement(parameterName);
            for (String paramValue : param.getValue()) {
                VCardDataType dataType = this.parameterDataTypes.get(parameterName);
                String dataTypeElementName = dataType == null ? "unknown" : dataType.getName().toLowerCase();
                Element dataTypeElement = this.createElement(dataTypeElementName);
                dataTypeElement.setTextContent(paramValue);
                parameterElement.appendChild(dataTypeElement);
            }
            parametersElement.appendChild(parameterElement);
        }
        return parametersElement;
    }

    private List<Element> getVCardElements() {
        return this.getChildElements(this.root, "vcard");
    }

    private List<Element> getChildElements(Element parent, String localName) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element child : XmlUtils.toElementList(parent.getChildNodes())) {
            if (!localName.equals(child.getLocalName()) || !version4.getXmlNamespace().equals(child.getNamespaceURI())) continue;
            elements.add(child);
        }
        return elements;
    }

    private Element createElement(String name) {
        return this.createElement(name, version4.getXmlNamespace());
    }

    private Element createElement(String name, String ns) {
        return this.document.createElementNS(ns, name);
    }

    private void addWarning(String message, String propertyName, List<String> warnings) {
        warnings.add(propertyName + " property: " + message);
    }
}

