/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.text;

import ezvcard.VCardVersion;
import ezvcard.io.text.FoldedLineWriter;
import ezvcard.io.text.FoldingScheme;
import ezvcard.parameter.Encoding;
import ezvcard.parameter.VCardParameters;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class VCardRawWriter
implements Closeable,
Flushable {
    private static final Pattern quoteMeRegex = Pattern.compile(".*?[,:;].*");
    private static final Pattern newlineRegex = Pattern.compile("\\r\\n|\\r|\\n");
    private static final Pattern propertyNameRegex = Pattern.compile("(?i)[-a-z0-9]+");
    private static final Map<VCardVersion, BitSet> invalidParamValueChars = new HashMap<VCardVersion, BitSet>();
    private final String newline;
    private boolean caretEncodingEnabled = false;
    private final FoldingScheme foldingScheme;
    private final FoldedLineWriter writer;
    private ProblemsListener problemsListener;
    private VCardVersion version;

    public VCardRawWriter(Writer writer, VCardVersion version) {
        this(writer, version, FoldingScheme.MIME_DIR);
    }

    public VCardRawWriter(Writer writer, VCardVersion version, FoldingScheme foldingScheme) {
        this(writer, version, foldingScheme, "\r\n");
    }

    public VCardRawWriter(Writer writer, VCardVersion version, FoldingScheme foldingScheme, String newline) {
        this.writer = foldingScheme == null ? new FoldedLineWriter(writer, null, "", newline) : new FoldedLineWriter(writer, foldingScheme.getLineLength(), foldingScheme.getIndent(), newline);
        this.version = version;
        this.foldingScheme = foldingScheme;
        this.newline = newline;
    }

    public boolean isCaretEncodingEnabled() {
        return this.caretEncodingEnabled;
    }

    public void setCaretEncodingEnabled(boolean enable) {
        this.caretEncodingEnabled = enable;
    }

    public VCardVersion getVersion() {
        return this.version;
    }

    public void setVersion(VCardVersion version) {
        this.version = version;
    }

    public String getNewline() {
        return this.newline;
    }

    public ProblemsListener getProblemsListener() {
        return this.problemsListener;
    }

    public void setProblemsListener(ProblemsListener problemsListener) {
        this.problemsListener = problemsListener;
    }

    public FoldingScheme getFoldingScheme() {
        return this.foldingScheme;
    }

    public void writeBeginComponent(String componentName) throws IOException {
        this.writeProperty("BEGIN", componentName);
    }

    public void writeEndComponent(String componentName) throws IOException {
        this.writeProperty("END", componentName);
    }

    public void writeVersion() throws IOException {
        this.writeProperty("VERSION", this.version.getVersion());
    }

    public void writeProperty(String propertyName, String value) throws IOException {
        this.writeProperty(null, propertyName, new VCardParameters(), value);
    }

    public void writeProperty(String group, String propertyName, VCardParameters parameters, String value) throws IOException {
        if (group != null && !propertyNameRegex.matcher(group).matches()) {
            throw new IllegalArgumentException("Group contains invalid characters.  Valid characters are letters, numbers, and hyphens: " + group);
        }
        if (!propertyNameRegex.matcher(propertyName).matches()) {
            throw new IllegalArgumentException("Property name contains invalid characters.  Valid characters are letters, numbers, and hyphens: " + propertyName);
        }
        value = this.sanitizeValue(parameters, value);
        if (group != null) {
            this.writer.append(group);
            this.writer.append('.');
        }
        this.writer.append(propertyName);
        for (Map.Entry subType : parameters) {
            String parameterName = (String)subType.getKey();
            List parameterValues = subType.getValue();
            if (parameterValues.isEmpty()) continue;
            if (this.version == VCardVersion.V2_1) {
                boolean isTypeParameter = "TYPE".equalsIgnoreCase(parameterName);
                for (String parameterValue : parameterValues) {
                    parameterValue = this.sanitizeParameterValue(parameterValue, parameterName, propertyName);
                    if (isTypeParameter) {
                        this.writer.append(';').append(parameterValue.toUpperCase());
                        continue;
                    }
                    this.writer.append(';').append(parameterName).append('=').append(parameterValue);
                }
                continue;
            }
            boolean first = true;
            this.writer.append(';').append(parameterName).append('=');
            for (String parameterValue : parameterValues) {
                if (!first) {
                    this.writer.append(',');
                }
                if (quoteMeRegex.matcher(parameterValue = this.sanitizeParameterValue(parameterValue, parameterName, propertyName)).matches()) {
                    this.writer.append('\"');
                    this.writer.append(parameterValue);
                    this.writer.append('\"');
                } else {
                    this.writer.append(parameterValue);
                }
                first = false;
            }
        }
        this.writer.append(':');
        boolean quotedPrintable = parameters.getEncoding() == Encoding.QUOTED_PRINTABLE;
        this.writer.append(value, quotedPrintable);
        this.writer.append(this.newline);
    }

    private String sanitizeValue(VCardParameters parameters, String value) {
        if (value == null) {
            return "";
        }
        if (this.version == VCardVersion.V2_1 && this.containsNewlines(value)) {
            parameters.setEncoding(Encoding.QUOTED_PRINTABLE);
            return value;
        }
        return this.escapeNewlines(value);
    }

    private String sanitizeParameterValue(String parameterValue, String parameterName, String propertyName) {
        String modifiedValue = null;
        boolean valueChanged = false;
        switch (this.version) {
            case V2_1: {
                modifiedValue = this.removeInvalidParameterValueChars(parameterValue);
                modifiedValue = newlineRegex.matcher(modifiedValue).replaceAll(" ");
                valueChanged = parameterValue != modifiedValue;
                modifiedValue = modifiedValue.replace("\\", "\\\\");
                modifiedValue = modifiedValue.replace(";", "\\;");
                break;
            }
            case V3_0: {
                modifiedValue = this.removeInvalidParameterValueChars(parameterValue);
                if (this.caretEncodingEnabled) {
                    valueChanged = modifiedValue != parameterValue;
                    modifiedValue = this.applyCaretEncoding(modifiedValue);
                    break;
                }
                modifiedValue = modifiedValue.replace('\"', '\'');
                valueChanged = (modifiedValue = newlineRegex.matcher(modifiedValue).replaceAll(" ")) != parameterValue;
                break;
            }
            case V4_0: {
                modifiedValue = this.removeInvalidParameterValueChars(parameterValue);
                if (this.caretEncodingEnabled) {
                    valueChanged = modifiedValue != parameterValue;
                    modifiedValue = this.applyCaretEncoding(modifiedValue);
                    break;
                }
                valueChanged = (modifiedValue = modifiedValue.replace('\"', '\'')) != parameterValue;
                modifiedValue = newlineRegex.matcher(modifiedValue).replaceAll("\\\\\\n");
            }
        }
        if (valueChanged && this.problemsListener != null) {
            this.problemsListener.onParameterValueChanged(propertyName, parameterName, parameterValue, modifiedValue);
        }
        return modifiedValue;
    }

    private String removeInvalidParameterValueChars(String value) {
        BitSet invalidChars = invalidParamValueChars.get((Object)this.version);
        StringBuilder sb = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (invalidChars.get(ch)) continue;
            sb.append(ch);
        }
        return sb.length() == value.length() ? value : sb.toString();
    }

    private String applyCaretEncoding(String value) {
        value = value.replace("^", "^^");
        value = newlineRegex.matcher(value).replaceAll("^n");
        value = value.replace("\"", "^'");
        return value;
    }

    private String escapeNewlines(String text) {
        return newlineRegex.matcher(text).replaceAll("\\\\n");
    }

    private boolean containsNewlines(String text) {
        return newlineRegex.matcher(text).find();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    static {
        BitSet controlChars = new BitSet(128);
        controlChars.set(0, 31);
        controlChars.set(127);
        controlChars.set(9, false);
        controlChars.set(10, false);
        controlChars.set(13, false);
        BitSet bitSet = new BitSet(128);
        bitSet.or(controlChars);
        bitSet.set(44);
        bitSet.set(46);
        bitSet.set(58);
        bitSet.set(61);
        bitSet.set(91);
        bitSet.set(93);
        invalidParamValueChars.put(VCardVersion.V2_1, bitSet);
        bitSet = new BitSet(128);
        bitSet.or(controlChars);
        invalidParamValueChars.put(VCardVersion.V3_0, bitSet);
        invalidParamValueChars.put(VCardVersion.V4_0, bitSet);
    }

    public static interface ProblemsListener {
        public void onParameterValueChanged(String var1, String var2, String var3, String var4);
    }
}

