/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Xml;
import ezvcard.util.XmlUtils;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlScribe
extends VCardPropertyScribe<Xml> {
    public XmlScribe() {
        super(Xml.class, "XML");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(Xml property, VCardVersion version) {
        Document value = (Document)property.getValue();
        if (value == null) {
            return "";
        }
        String xml = this.valueToString(value);
        return XmlScribe.escape(xml);
    }

    @Override
    protected Xml _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = XmlScribe.unescape(value);
        try {
            return new Xml(value);
        }
        catch (SAXException e) {
            throw new CannotParseException("Cannot parse value as XML: " + value);
        }
    }

    @Override
    protected void _writeXml(Xml property, XCardElement element) {
        super._writeXml(property, element);
    }

    @Override
    protected Xml _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        Xml xml = new Xml(element.element());
        Element root = XmlUtils.getRootElement((Document)xml.getValue());
        for (Element child : XmlUtils.toElementList(root.getChildNodes())) {
            if (!"parameters".equals(child.getLocalName()) || !VCardVersion.V4_0.getXmlNamespace().equals(child.getNamespaceURI())) continue;
            root.removeChild(child);
        }
        return xml;
    }

    @Override
    protected JCardValue _writeJson(Xml property) {
        String xml = null;
        Document value = (Document)property.getValue();
        if (value != null) {
            xml = this.valueToString(value);
        }
        return JCardValue.single(xml);
    }

    @Override
    protected Xml _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        try {
            String xml = value.asSingle();
            return xml == null ? new Xml((Document)null) : new Xml(xml);
        }
        catch (SAXException e) {
            throw new CannotParseException("Cannot parse value as XML: " + value);
        }
    }

    private String valueToString(Document document) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("omit-xml-declaration", "yes");
        return XmlUtils.toString(document, props);
    }
}

