/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Related;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedScribe
extends VCardPropertyScribe<Related> {
    public RelatedScribe() {
        super(Related.class, "RELATED");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.URI;
    }

    @Override
    protected VCardDataType _dataType(Related property, VCardVersion version) {
        if (property.getUri() != null) {
            return VCardDataType.URI;
        }
        if (property.getText() != null) {
            return VCardDataType.TEXT;
        }
        return VCardDataType.URI;
    }

    @Override
    protected String _writeText(Related property, VCardVersion version) {
        String uri = property.getUri();
        if (uri != null) {
            return uri;
        }
        String text = property.getText();
        if (text != null) {
            return RelatedScribe.escape(text);
        }
        return "";
    }

    @Override
    protected Related _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = RelatedScribe.unescape(value);
        Related property = new Related();
        if (dataType == VCardDataType.TEXT) {
            property.setText(value);
        } else {
            property.setUri(value);
        }
        return property;
    }

    @Override
    protected void _writeXml(Related property, XCardElement parent) {
        String uri = property.getUri();
        if (uri != null) {
            parent.append(VCardDataType.URI, uri);
            return;
        }
        String text = property.getText();
        if (text != null) {
            parent.append(VCardDataType.TEXT, text);
            return;
        }
        parent.append(VCardDataType.URI, "");
    }

    @Override
    protected Related _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String uri = element.first(VCardDataType.URI);
        if (uri != null) {
            Related property = new Related();
            property.setUri(uri);
            return property;
        }
        String text = element.first(VCardDataType.TEXT);
        if (text != null) {
            Related property = new Related();
            property.setText(text);
            return property;
        }
        throw RelatedScribe.missingXmlElements(VCardDataType.URI, VCardDataType.TEXT);
    }

    @Override
    protected JCardValue _writeJson(Related property) {
        String uri = property.getUri();
        if (uri != null) {
            return JCardValue.single(uri);
        }
        String text = property.getText();
        if (text != null) {
            return JCardValue.single(text);
        }
        return JCardValue.single("");
    }

    @Override
    protected Related _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        String valueStr = value.asSingle();
        Related property = new Related();
        if (dataType == VCardDataType.TEXT) {
            property.setText(valueStr);
        } else {
            property.setUri(valueStr);
        }
        return property;
    }
}

