/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Gender;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenderScribe
extends VCardPropertyScribe<Gender> {
    public GenderScribe() {
        super(Gender.class, "GENDER");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(Gender property, VCardVersion version) {
        String gender = property.getGender();
        String text = property.getText();
        if (text != null) {
            return GenderScribe.structured(gender, text);
        }
        if (gender != null) {
            return GenderScribe.structured(new Object[]{gender});
        }
        return "";
    }

    @Override
    protected Gender _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        VCardPropertyScribe.SemiStructuredIterator it = GenderScribe.semistructured(value, 2);
        String sex = it.next();
        if (sex != null) {
            sex = sex.toUpperCase();
        }
        String text = it.next();
        Gender property = new Gender(sex);
        property.setText(text);
        return property;
    }

    @Override
    protected void _writeXml(Gender property, XCardElement parent) {
        parent.append("sex", property.getGender());
        String text = property.getText();
        if (text != null) {
            parent.append("identity", text);
        }
    }

    @Override
    protected Gender _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String sex = element.first("sex");
        if (sex != null) {
            Gender property = new Gender(sex);
            property.setText(element.first("identity"));
            return property;
        }
        throw GenderScribe.missingXmlElements("sex");
    }

    @Override
    protected JCardValue _writeJson(Gender property) {
        String gender = property.getGender();
        String text = property.getText();
        if (text == null) {
            return JCardValue.single(gender);
        }
        return JCardValue.structured(gender, text);
    }

    @Override
    protected Gender _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        VCardPropertyScribe.StructuredIterator it = GenderScribe.structured(value);
        String sex = it.nextString();
        if (sex != null) {
            sex = sex.toUpperCase();
        }
        String text = it.nextString();
        Gender property = new Gender(sex);
        property.setText(text);
        return property;
    }
}

