/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.ClientPidMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientPidMapScribe
extends VCardPropertyScribe<ClientPidMap> {
    public ClientPidMapScribe() {
        super(ClientPidMap.class, "CLIENTPIDMAP");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(ClientPidMap property, VCardVersion version) {
        return ClientPidMapScribe.structured(property.getPid(), property.getUri());
    }

    @Override
    protected ClientPidMap _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        VCardPropertyScribe.SemiStructuredIterator it = ClientPidMapScribe.semistructured(value, 2);
        String pid = it.next();
        String uri = it.next();
        if (pid == null || uri == null) {
            throw new CannotParseException("Incorrect data format.  Value must contain a PID and a URI, separated by a semi-colon.");
        }
        return this.parse(pid, uri);
    }

    @Override
    protected void _writeXml(ClientPidMap property, XCardElement parent) {
        Integer pid = property.getPid();
        parent.append("sourceid", pid == null ? "" : pid.toString());
        parent.append(VCardDataType.URI, property.getUri());
    }

    @Override
    protected ClientPidMap _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        String sourceid = element.first("sourceid");
        String uri = element.first(VCardDataType.URI);
        if (uri == null && sourceid == null) {
            throw ClientPidMapScribe.missingXmlElements(VCardDataType.URI.getName().toLowerCase(), "sourceid");
        }
        if (uri == null) {
            throw ClientPidMapScribe.missingXmlElements(VCardDataType.URI);
        }
        if (sourceid == null) {
            throw ClientPidMapScribe.missingXmlElements("sourceid");
        }
        return this.parse(sourceid, uri);
    }

    @Override
    protected JCardValue _writeJson(ClientPidMap property) {
        return JCardValue.structured(property.getPid(), property.getUri());
    }

    @Override
    protected ClientPidMap _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        VCardPropertyScribe.StructuredIterator it = ClientPidMapScribe.structured(value);
        String pid = it.nextString();
        String uri = it.nextString();
        return this.parse(pid, uri);
    }

    private ClientPidMap parse(String pid, String uri) {
        try {
            return new ClientPidMap(Integer.parseInt(pid), uri);
        }
        catch (NumberFormatException e) {
            throw new CannotParseException("Unable to parse PID component.");
        }
    }
}

