/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.html.HCardElement;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Agent;
import ezvcard.property.VCardProperty;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentScribe
extends VCardPropertyScribe<Agent> {
    public AgentScribe() {
        super(Agent.class, "AGENT");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return null;
    }

    @Override
    protected VCardDataType _dataType(Agent property, VCardVersion version) {
        if (property.getUrl() != null) {
            return version == VCardVersion.V2_1 ? VCardDataType.URL : VCardDataType.URI;
        }
        return null;
    }

    @Override
    protected String _writeText(Agent property, VCardVersion version) {
        String url = property.getUrl();
        if (url != null) {
            return url;
        }
        VCard vcard = property.getVCard();
        if (vcard != null) {
            throw new EmbeddedVCardException(vcard);
        }
        throw new SkipMeException("Property has neither a URL nor an embedded vCard.");
    }

    @Override
    protected Agent _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        Agent property = new Agent();
        if (dataType == null) {
            throw new EmbeddedVCardException(new Injector(property));
        }
        property.setUrl(AgentScribe.unescape(value));
        return property;
    }

    @Override
    protected Agent _parseHtml(HCardElement element, List<String> warnings) {
        Agent property = new Agent();
        Set<String> classes = element.classNames();
        if (classes.contains("vcard")) {
            throw new EmbeddedVCardException(new Injector(property));
        }
        String url = element.absUrl("href");
        if (url.length() == 0) {
            url = element.value();
        }
        property.setUrl(url);
        return property;
    }

    private static class Injector
    implements EmbeddedVCardException.InjectionCallback {
        private final Agent property;

        public Injector(Agent property) {
            this.property = property;
        }

        public void injectVCard(VCard vcard) {
            this.property.setVCard(vcard);
        }

        public VCardProperty getProperty() {
            return this.property;
        }
    }
}

