/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.json.JCardRawReader;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.RawPropertyScribe;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.RawProperty;
import ezvcard.property.VCardProperty;
import ezvcard.util.IOUtils;
import ezvcard.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCardReader
implements Closeable {
    private ScribeIndex index = new ScribeIndex();
    private final List<String> warnings = new ArrayList<String>();
    private final JCardRawReader reader;

    public JCardReader(String json) {
        this(new StringReader(json));
    }

    public JCardReader(InputStream in) {
        this(IOUtils.utf8Reader(in));
    }

    public JCardReader(File file) throws FileNotFoundException {
        this(IOUtils.utf8Reader(file));
    }

    public JCardReader(Reader reader) {
        this.reader = new JCardRawReader(reader);
    }

    public VCard readNext() throws IOException {
        if (this.reader.eof()) {
            return null;
        }
        this.warnings.clear();
        JCardDataStreamListenerImpl listener = new JCardDataStreamListenerImpl();
        this.reader.readNext(listener);
        VCard vcard = listener.vcard;
        if (vcard != null && !listener.versionFound) {
            this.addWarning("No \"version\" property found.");
        }
        return vcard;
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public List<String> getWarnings() {
        return new ArrayList<String>(this.warnings);
    }

    private void addWarning(String message) {
        this.addWarning(message, null);
    }

    private void addWarning(String message, String propertyName) {
        StringBuilder sb = new StringBuilder();
        sb.append("Line ").append(this.reader.getLineNum());
        if (propertyName != null) {
            sb.append(" (").append(propertyName).append(" property)");
        }
        sb.append(": ").append(message);
        this.warnings.add(sb.toString());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private class JCardDataStreamListenerImpl
    implements JCardRawReader.JCardDataStreamListener {
        private VCard vcard = null;
        private boolean versionFound = false;

        private JCardDataStreamListenerImpl() {
        }

        public void beginVCard() {
            this.vcard = new VCard();
            this.vcard.setVersion(VCardVersion.V4_0);
        }

        public void readProperty(String group, String propertyName, VCardParameters parameters, VCardDataType dataType, JCardValue value) {
            Object property;
            if ("version".equalsIgnoreCase(propertyName)) {
                this.versionFound = true;
                VCardVersion version = VCardVersion.valueOfByStr(value.asSingle());
                if (version != VCardVersion.V4_0) {
                    JCardReader.this.addWarning("Version must be \"" + VCardVersion.V4_0.getVersion() + "\"", propertyName);
                }
                return;
            }
            RawPropertyScribe scribe = JCardReader.this.index.getPropertyScribe(propertyName);
            if (scribe == null) {
                scribe = new RawPropertyScribe(propertyName);
            }
            try {
                VCardPropertyScribe.Result result = scribe.parseJson(value, dataType, parameters);
                for (String warning : result.getWarnings()) {
                    JCardReader.this.addWarning(warning, propertyName);
                }
                property = result.getProperty();
                ((VCardProperty)property).setGroup(group);
            }
            catch (SkipMeException e) {
                JCardReader.this.addWarning("Property has requested that it be skipped: " + e.getMessage(), propertyName);
                return;
            }
            catch (CannotParseException e) {
                scribe = new RawPropertyScribe(propertyName);
                VCardPropertyScribe.Result result = scribe.parseJson(value, dataType, parameters);
                property = result.getProperty();
                ((VCardProperty)property).setGroup(group);
                String valueStr = (String)((RawProperty)property).getValue();
                JCardReader.this.addWarning("Property value could not be parsed.  Property will be saved as an extended property instead." + StringUtils.NEWLINE + "  Value: " + valueStr + StringUtils.NEWLINE + "  Reason: " + e.getMessage(), propertyName);
            }
            catch (EmbeddedVCardException e) {
                JCardReader.this.addWarning("Property will not be unmarshalled because jCard does not supported embedded vCards.", propertyName);
                return;
            }
            this.vcard.addProperty((VCardProperty)property);
        }
    }
}

