/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import ezvcard.VCardDataType;
import ezvcard.io.json.JCardValue;
import ezvcard.io.json.JsonValue;
import ezvcard.parameter.VCardParameters;
import ezvcard.util.StringUtils;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class JCardRawWriter
implements Closeable,
Flushable {
    private final Writer writer;
    private final boolean wrapInArray;
    private JsonGenerator jg;
    private boolean indent = false;
    private boolean open = false;

    public JCardRawWriter(Writer writer, boolean wrapInArray) {
        this.writer = writer;
        this.wrapInArray = wrapInArray;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void writeStartVCard() throws IOException {
        if (this.jg == null) {
            this.init();
        }
        if (this.open) {
            this.writeEndVCard();
        }
        this.jg.writeStartArray();
        this.indent(0);
        this.jg.writeString("vcard");
        this.jg.writeStartArray();
        this.open = true;
    }

    public void writeEndVCard() throws IOException {
        if (!this.open) {
            throw new IllegalStateException("Call \"writeStartVCard\" first.");
        }
        this.jg.writeEndArray();
        this.jg.writeEndArray();
        this.open = false;
    }

    public void writeProperty(String propertyName, VCardDataType dataType, JCardValue value) throws IOException {
        this.writeProperty(null, propertyName, new VCardParameters(), dataType, value);
    }

    public void writeProperty(String group, String propertyName, VCardParameters parameters, VCardDataType dataType, JCardValue value) throws IOException {
        if (!this.open) {
            throw new IllegalStateException("Call \"writeStartVCard\" first.");
        }
        this.jg.writeStartArray();
        this.indent(2);
        this.jg.writeString(propertyName);
        this.jg.writeStartObject();
        for (Map.Entry entry : parameters) {
            String name = ((String)entry.getKey()).toLowerCase();
            List values = entry.getValue();
            if (values.isEmpty()) continue;
            if (values.size() == 1) {
                this.jg.writeStringField(name, (String)values.get(0));
                continue;
            }
            this.jg.writeArrayFieldStart(name);
            for (String paramValue : values) {
                this.jg.writeString(paramValue);
            }
            this.jg.writeEndArray();
        }
        if (group != null) {
            this.jg.writeStringField("group", group);
        }
        this.jg.writeEndObject();
        this.jg.writeString(dataType == null ? "unknown" : dataType.getName().toLowerCase());
        if (value.getValues().isEmpty()) {
            this.jg.writeString("");
        } else {
            for (JsonValue jsonValue : value.getValues()) {
                this.writeValue(jsonValue);
            }
        }
        this.jg.writeEndArray();
    }

    private void writeValue(JsonValue jsonValue) throws IOException {
        if (jsonValue.isNull()) {
            this.jg.writeNull();
            return;
        }
        Object val = jsonValue.getValue();
        if (val != null) {
            if (val instanceof Byte) {
                this.jg.writeNumber((int)((Byte)val).byteValue());
            } else if (val instanceof Short) {
                this.jg.writeNumber((int)((Short)val).shortValue());
            } else if (val instanceof Integer) {
                this.jg.writeNumber(((Integer)val).intValue());
            } else if (val instanceof Long) {
                this.jg.writeNumber(((Long)val).longValue());
            } else if (val instanceof Float) {
                this.jg.writeNumber(((Float)val).floatValue());
            } else if (val instanceof Double) {
                this.jg.writeNumber(((Double)val).doubleValue());
            } else if (val instanceof Boolean) {
                this.jg.writeBoolean(((Boolean)val).booleanValue());
            } else {
                this.jg.writeString(val.toString());
            }
            return;
        }
        List<JsonValue> array = jsonValue.getArray();
        if (array != null) {
            this.jg.writeStartArray();
            for (JsonValue element : array) {
                this.writeValue(element);
            }
            this.jg.writeEndArray();
            return;
        }
        Map<String, JsonValue> object = jsonValue.getObject();
        if (object != null) {
            this.jg.writeStartObject();
            for (Map.Entry<String, JsonValue> entry : object.entrySet()) {
                this.jg.writeFieldName(entry.getKey());
                this.writeValue(entry.getValue());
            }
            this.jg.writeEndObject();
            return;
        }
    }

    private void indent(int spaces) throws IOException {
        if (!this.indent) {
            return;
        }
        this.jg.writeRaw(StringUtils.NEWLINE);
        for (int i = 0; i < spaces; ++i) {
            this.jg.writeRaw(' ');
        }
    }

    public void flush() throws IOException {
        if (this.jg == null) {
            return;
        }
        this.jg.flush();
    }

    public void closeJsonStream() throws IOException {
        if (this.jg == null) {
            return;
        }
        while (this.open) {
            this.writeEndVCard();
        }
        if (this.wrapInArray) {
            this.indent(0);
            this.jg.writeEndArray();
        }
        this.jg.close();
    }

    public void close() throws IOException {
        if (this.jg == null) {
            return;
        }
        this.closeJsonStream();
        this.writer.close();
    }

    private void init() throws IOException {
        JsonFactory factory = new JsonFactory();
        factory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        this.jg = factory.createJsonGenerator(this.writer);
        if (this.wrapInArray) {
            this.jg.writeStartArray();
            this.indent(0);
        }
    }
}

