/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import ezvcard.VCardDataType;
import ezvcard.io.json.JCardParseException;
import ezvcard.io.json.JCardValue;
import ezvcard.io.json.JsonValue;
import ezvcard.parameter.VCardParameters;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCardRawReader
implements Closeable {
    private final Reader reader;
    private JsonParser jp;
    private boolean eof = false;
    private JCardDataStreamListener listener;

    public JCardRawReader(Reader reader) {
        this.reader = reader;
    }

    public int getLineNum() {
        return this.jp == null ? 0 : this.jp.getCurrentLocation().getLineNr();
    }

    public void readNext(JCardDataStreamListener listener) throws IOException {
        JsonToken cur;
        if (this.jp == null) {
            JsonFactory factory = new JsonFactory();
            this.jp = factory.createJsonParser(this.reader);
        } else if (this.jp.isClosed()) {
            return;
        }
        this.listener = listener;
        JsonToken prev = null;
        while (!((cur = this.jp.nextToken()) == null || prev == JsonToken.START_ARRAY && cur == JsonToken.VALUE_STRING && "vcard".equals(this.jp.getValueAsString()))) {
            prev = cur;
        }
        if (cur == null) {
            this.eof = true;
            return;
        }
        listener.beginVCard();
        this.parseProperties();
    }

    private void parseProperties() throws IOException {
        if (this.jp.nextToken() != JsonToken.START_ARRAY) {
            throw new JCardParseException(JsonToken.START_ARRAY, this.jp.getCurrentToken());
        }
        while (this.jp.nextToken() != JsonToken.END_ARRAY) {
            if (this.jp.getCurrentToken() != JsonToken.START_ARRAY) {
                throw new JCardParseException(JsonToken.START_ARRAY, this.jp.getCurrentToken());
            }
            this.jp.nextToken();
            this.parseProperty();
        }
    }

    private void parseProperty() throws IOException {
        String group;
        if (this.jp.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw new JCardParseException(JsonToken.VALUE_STRING, this.jp.getCurrentToken());
        }
        String propertyName = this.jp.getValueAsString().toLowerCase();
        VCardParameters parameters = this.parseParameters();
        List removed = parameters.removeAll("group");
        String string = group = removed.isEmpty() ? null : (String)removed.get(0);
        if (this.jp.nextToken() != JsonToken.VALUE_STRING) {
            throw new JCardParseException(JsonToken.VALUE_STRING, this.jp.getCurrentToken());
        }
        String dataTypeStr = this.jp.getText().toLowerCase();
        VCardDataType dataType = "unknown".equals(dataTypeStr) ? null : VCardDataType.get(dataTypeStr);
        List<JsonValue> values = this.parseValues();
        JCardValue value = new JCardValue(values);
        this.listener.readProperty(group, propertyName, parameters, dataType, value);
    }

    private VCardParameters parseParameters() throws IOException {
        if (this.jp.nextToken() != JsonToken.START_OBJECT) {
            throw new JCardParseException(JsonToken.START_OBJECT, this.jp.getCurrentToken());
        }
        VCardParameters parameters = new VCardParameters();
        while (this.jp.nextToken() != JsonToken.END_OBJECT) {
            String parameterName = this.jp.getText();
            if (this.jp.nextToken() == JsonToken.START_ARRAY) {
                while (this.jp.nextToken() != JsonToken.END_ARRAY) {
                    parameters.put(parameterName, this.jp.getText());
                }
                continue;
            }
            parameters.put(parameterName, this.jp.getValueAsString());
        }
        return parameters;
    }

    private List<JsonValue> parseValues() throws IOException {
        ArrayList<JsonValue> values = new ArrayList<JsonValue>();
        while (this.jp.nextToken() != JsonToken.END_ARRAY) {
            JsonValue value = this.parseValue();
            values.add(value);
        }
        return values;
    }

    private Object parseValueElement() throws IOException {
        switch (this.jp.getCurrentToken()) {
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return this.jp.getBooleanValue();
            }
            case VALUE_NUMBER_FLOAT: {
                return this.jp.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return this.jp.getLongValue();
            }
            case VALUE_NULL: {
                return null;
            }
        }
        return this.jp.getText();
    }

    private List<JsonValue> parseValueArray() throws IOException {
        ArrayList<JsonValue> array = new ArrayList<JsonValue>();
        while (this.jp.nextToken() != JsonToken.END_ARRAY) {
            JsonValue value = this.parseValue();
            array.add(value);
        }
        return array;
    }

    private Map<String, JsonValue> parseValueObject() throws IOException {
        HashMap<String, JsonValue> object = new HashMap<String, JsonValue>();
        this.jp.nextToken();
        while (this.jp.getCurrentToken() != JsonToken.END_OBJECT) {
            if (this.jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw new JCardParseException(JsonToken.FIELD_NAME, this.jp.getCurrentToken());
            }
            String key = this.jp.getText();
            this.jp.nextToken();
            JsonValue value = this.parseValue();
            object.put(key, value);
            this.jp.nextToken();
        }
        return object;
    }

    private JsonValue parseValue() throws IOException {
        switch (this.jp.getCurrentToken()) {
            case START_ARRAY: {
                return new JsonValue(this.parseValueArray());
            }
            case START_OBJECT: {
                return new JsonValue(this.parseValueObject());
            }
        }
        return new JsonValue(this.parseValueElement());
    }

    public boolean eof() {
        return this.eof;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static interface JCardDataStreamListener {
        public void beginVCard();

        public void readProperty(String var1, String var2, VCardParameters var3, VCardDataType var4, JCardValue var5);
    }
}

