/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.html;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.scribe.RawPropertyScribe;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.property.Address;
import ezvcard.property.Categories;
import ezvcard.property.Email;
import ezvcard.property.Impp;
import ezvcard.property.Label;
import ezvcard.property.Nickname;
import ezvcard.property.RawProperty;
import ezvcard.property.Source;
import ezvcard.property.Telephone;
import ezvcard.property.Url;
import ezvcard.property.VCardProperty;
import ezvcard.util.HtmlUtils;
import ezvcard.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HCardReader {
    private ScribeIndex index = new ScribeIndex();
    private String pageUrl;
    private final List<String> warnings = new ArrayList<String>();
    private Elements vcardElements;
    private Iterator<Element> it;
    private final List<Label> labels = new ArrayList<Label>();
    private VCard curVCard;
    private Elements embeddedVCards = new Elements();
    private Nickname nickname;
    private Categories categories;
    private final String urlPropertyName = this.index.getPropertyScribe(Url.class).getPropertyName().toLowerCase();
    private final String categoriesName = this.index.getPropertyScribe(Categories.class).getPropertyName().toLowerCase();
    private final String emailName = this.index.getPropertyScribe(Email.class).getPropertyName().toLowerCase();
    private final String telName = this.index.getPropertyScribe(Telephone.class).getPropertyName().toLowerCase();

    public HCardReader(URL url) throws IOException {
        this.pageUrl = url.toString();
        Document document = Jsoup.parse((URL)url, (int)30000);
        this.init(document, url.getRef());
    }

    public HCardReader(InputStream in) throws IOException {
        this(in, null);
    }

    public HCardReader(InputStream in, String pageUrl) throws IOException {
        this.pageUrl = pageUrl;
        Document document = pageUrl == null ? Jsoup.parse((InputStream)in, null, (String)"") : Jsoup.parse((InputStream)in, null, (String)pageUrl);
        String anchor = this.getAnchor(pageUrl);
        this.init(document, anchor);
    }

    public HCardReader(File file) throws IOException {
        this(file, null);
    }

    public HCardReader(File file, String pageUrl) throws IOException {
        this.pageUrl = pageUrl;
        Document document = pageUrl == null ? Jsoup.parse((File)file, null, (String)"") : Jsoup.parse((File)file, null, (String)pageUrl);
        String anchor = this.getAnchor(pageUrl);
        this.init(document, anchor);
    }

    public HCardReader(Reader reader) throws IOException {
        this(reader, null);
    }

    public HCardReader(Reader reader, String pageUrl) throws IOException {
        int read;
        this.pageUrl = pageUrl;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[4096];
        while ((read = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, read);
        }
        String html = sb.toString();
        Document document = pageUrl == null ? Jsoup.parse((String)html) : Jsoup.parse((String)html, (String)pageUrl);
        String anchor = this.getAnchor(pageUrl);
        this.init(document, anchor);
    }

    public HCardReader(String html) {
        this(html, null);
    }

    public HCardReader(String html, String pageUrl) {
        this.pageUrl = pageUrl;
        Document document = pageUrl == null ? Jsoup.parse((String)html) : Jsoup.parse((String)html, (String)pageUrl);
        String anchor = this.getAnchor(pageUrl);
        this.init(document, anchor);
    }

    private HCardReader(Element embeddedVCard, String pageUrl) {
        this.pageUrl = pageUrl;
        this.vcardElements = new Elements(new Element[]{embeddedVCard});
        this.it = this.vcardElements.iterator();
    }

    private void init(Document document, String anchor) {
        Element searchIn = null;
        if (anchor != null) {
            searchIn = document.getElementById(anchor);
        }
        if (searchIn == null) {
            searchIn = document;
        }
        this.vcardElements = searchIn.getElementsByClass("vcard");
        this.it = this.vcardElements.iterator();
    }

    private String getAnchor(String urlStr) {
        if (urlStr == null) {
            return null;
        }
        try {
            URL url = new URL(urlStr);
            return url.getRef();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void registerScribe(VCardPropertyScribe<? extends VCardProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public List<String> getWarnings() {
        return new ArrayList<String>(this.warnings);
    }

    public VCard readNext() {
        Element vcardElement = null;
        while (this.it.hasNext() && vcardElement == null) {
            vcardElement = this.it.next();
            if (!HtmlUtils.isChildOf(vcardElement, this.vcardElements)) continue;
            vcardElement = null;
        }
        if (vcardElement == null) {
            return null;
        }
        this.warnings.clear();
        this.labels.clear();
        this.nickname = null;
        this.categories = null;
        this.curVCard = new VCard();
        this.curVCard.setVersion(VCardVersion.V3_0);
        if (this.pageUrl != null) {
            this.curVCard.addSource(new Source(this.pageUrl));
        }
        for (Element child : vcardElement.children()) {
            this.visit(child);
        }
        for (Label label : this.labels) {
            boolean orphaned = true;
            for (Address adr : this.curVCard.getAddresses()) {
                if (adr.getLabel() != null || !((Object)adr.getTypes()).equals(label.getTypes())) continue;
                adr.setLabel((String)label.getValue());
                orphaned = false;
                break;
            }
            if (!orphaned) continue;
            this.curVCard.addOrphanedLabel(label);
        }
        return this.curVCard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visit(Element element) {
        Set classNames = element.classNames();
        for (String className : classNames) {
            VCardProperty property;
            RawPropertyScribe scribe;
            VCardPropertyScribe.Result<? extends VCardProperty> result;
            String href;
            if (this.urlPropertyName.equalsIgnoreCase(className = className.toLowerCase()) && (href = element.attr("href")).length() > 0) {
                if (!classNames.contains(this.emailName) && href.matches("(?i)mailto:.*")) {
                    className = this.emailName;
                } else if (!classNames.contains(this.telName) && href.matches("(?i)tel:.*")) {
                    className = this.telName;
                } else {
                    VCardPropertyScribe<? extends VCardProperty> scribe2 = this.index.getPropertyScribe(Impp.class);
                    try {
                        result = scribe2.parseHtml(element);
                        this.curVCard.addProperty(result.getProperty());
                        for (String warning : result.getWarnings()) {
                            this.addWarning(warning, scribe2.getPropertyName());
                        }
                        continue;
                    }
                    catch (SkipMeException e) {
                    }
                    catch (CannotParseException e) {
                        // empty catch block
                    }
                }
            }
            if ("category".equalsIgnoreCase(className)) {
                className = this.categoriesName;
            }
            if ((scribe = this.index.getPropertyScribe(className)) == null) {
                if (!className.startsWith("x-")) continue;
                scribe = new RawPropertyScribe(className);
            }
            try {
                result = scribe.parseHtml(element);
                for (String warning : result.getWarnings()) {
                    this.addWarning(warning, className);
                }
                property = result.getProperty();
                if (property instanceof Label) {
                    this.labels.add((Label)property);
                    continue;
                }
                if (property instanceof Nickname) {
                    Nickname nn = (Nickname)property;
                    if (this.nickname == null) {
                        this.nickname = nn;
                        this.curVCard.addProperty(this.nickname);
                        continue;
                    }
                    this.nickname.getValues().addAll(nn.getValues());
                    continue;
                }
                if (property instanceof Categories) {
                    Categories c = (Categories)property;
                    if (this.categories == null) {
                        this.categories = c;
                        this.curVCard.addProperty(this.categories);
                        continue;
                    }
                    this.categories.getValues().addAll(c.getValues());
                    continue;
                }
            }
            catch (SkipMeException e) {
                this.addWarning("Property has requested that it be skipped: " + e.getMessage(), className);
                continue;
            }
            catch (CannotParseException e) {
                String html = element.outerHtml();
                this.addWarning("Property value could not be parsed.  Property will be saved as an extended property instead." + StringUtils.NEWLINE + "  HTML: " + html + StringUtils.NEWLINE + "  Reason: " + e.getMessage(), className);
                property = new RawProperty(className, html);
            }
            catch (EmbeddedVCardException e) {
                if (HtmlUtils.isChildOf(element, this.embeddedVCards)) continue;
                property = e.getProperty();
                this.embeddedVCards.add(element);
                HCardReader embeddedReader = new HCardReader(element, this.pageUrl);
                try {
                    VCard embeddedVCard = embeddedReader.readNext();
                    e.injectVCard(embeddedVCard);
                }
                finally {
                    for (String w : embeddedReader.getWarnings()) {
                        this.addWarning("Problem unmarshalling nested vCard value: " + w, className);
                    }
                }
            }
            this.curVCard.addProperty(property);
        }
        for (Element child : element.children()) {
            this.visit(child);
        }
    }

    private void addWarning(String message, String propertyName) {
        this.warnings.add(propertyName + " property: " + message);
    }
}

