/*
 * Decompiled with CFR 0.152.
 */
package ezvcard;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.io.html.HCardPage;
import ezvcard.io.html.HCardReader;
import ezvcard.io.json.JCardReader;
import ezvcard.io.json.JCardWriter;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.VCardReader;
import ezvcard.io.text.VCardWriter;
import ezvcard.io.xml.XCardDocument;
import ezvcard.property.VCardProperty;
import ezvcard.util.IOUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ezvcard {
    public static final String VERSION;
    public static final String URL;

    public static ParserChainTextString parse(String str) {
        return new ParserChainTextString(str);
    }

    public static ParserChainTextReader parse(File file) {
        return new ParserChainTextReader(file);
    }

    public static ParserChainTextReader parse(InputStream in) {
        return Ezvcard.parse(new InputStreamReader(in));
    }

    public static ParserChainTextReader parse(Reader reader) {
        return new ParserChainTextReader(reader);
    }

    public static ParserChainXmlString parseXml(String xml) {
        return new ParserChainXmlString(xml);
    }

    public static ParserChainXmlReader parseXml(File file) {
        return new ParserChainXmlReader(file);
    }

    public static ParserChainXmlReader parseXml(InputStream in) {
        return new ParserChainXmlReader(in);
    }

    public static ParserChainXmlReader parseXml(Reader reader) {
        return new ParserChainXmlReader(reader);
    }

    public static ParserChainXmlDom parseXml(Document document) {
        return new ParserChainXmlDom(document);
    }

    public static ParserChainHtmlString parseHtml(String html) {
        return new ParserChainHtmlString(html);
    }

    public static ParserChainHtmlReader parseHtml(File file) {
        return new ParserChainHtmlReader(file);
    }

    public static ParserChainHtmlReader parseHtml(InputStream in) {
        return Ezvcard.parseHtml(new InputStreamReader(in));
    }

    public static ParserChainHtmlReader parseHtml(Reader reader) {
        return new ParserChainHtmlReader(reader);
    }

    public static ParserChainHtmlReader parseHtml(URL url) {
        return new ParserChainHtmlReader(url);
    }

    public static ParserChainJsonString parseJson(String json) {
        return new ParserChainJsonString(json);
    }

    public static ParserChainJsonReader parseJson(File file) {
        return new ParserChainJsonReader(file);
    }

    public static ParserChainJsonReader parseJson(InputStream in) {
        return new ParserChainJsonReader(in);
    }

    public static ParserChainJsonReader parseJson(Reader reader) {
        return new ParserChainJsonReader(reader);
    }

    public static WriterChainText write(VCard ... vcards) {
        return Ezvcard.write(Arrays.asList(vcards));
    }

    public static WriterChainText write(Collection<VCard> vcards) {
        return new WriterChainText(vcards);
    }

    public static WriterChainXml writeXml(VCard ... vcards) {
        return Ezvcard.writeXml(Arrays.asList(vcards));
    }

    public static WriterChainXml writeXml(Collection<VCard> vcards) {
        return new WriterChainXml(vcards);
    }

    public static WriterChainHtml writeHtml(VCard ... vcards) {
        return Ezvcard.writeHtml(Arrays.asList(vcards));
    }

    public static WriterChainHtml writeHtml(Collection<VCard> vcards) {
        return new WriterChainHtml(vcards);
    }

    public static WriterChainJson writeJson(VCard ... vcards) {
        return Ezvcard.writeJson(Arrays.asList(vcards));
    }

    public static WriterChainJson writeJson(Collection<VCard> vcards) {
        return new WriterChainJson(vcards);
    }

    private Ezvcard() {
    }

    static {
        InputStream in = null;
        try {
            in = Ezvcard.class.getResourceAsStream("/ez-vcard.properties");
            Properties props = new Properties();
            props.load(in);
            VERSION = props.getProperty("version");
            URL = props.getProperty("url");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WriterChainJson
    extends WriterChain<WriterChainJson> {
        boolean prodId = true;
        boolean versionStrict = true;
        boolean indent = false;
        final ScribeIndex index = new ScribeIndex();

        private WriterChainJson(Collection<VCard> vcards) {
            super(vcards);
        }

        public WriterChainJson prodId(boolean include) {
            this.prodId = include;
            return (WriterChainJson)this.this_;
        }

        public WriterChainJson indent(boolean indent) {
            this.indent = indent;
            return (WriterChainJson)this.this_;
        }

        public WriterChainJson versionStrict(boolean versionStrict) {
            this.versionStrict = versionStrict;
            return (WriterChainJson)this.this_;
        }

        public WriterChainJson register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            this.index.register(scribe);
            return (WriterChainJson)this.this_;
        }

        public String go() {
            StringWriter sw = new StringWriter();
            try {
                this.go(sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        public void go(OutputStream out) throws IOException {
            this.go(new JCardWriter(out, this.vcards.size() > 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void go(File file) throws IOException {
            JCardWriter writer = new JCardWriter(file, this.vcards.size() > 1);
            try {
                this.go(writer);
            }
            finally {
                IOUtils.closeQuietly(writer);
            }
        }

        public void go(Writer writer) throws IOException {
            this.go(new JCardWriter(writer, this.vcards.size() > 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void go(JCardWriter writer) throws IOException {
            writer.setAddProdId(this.prodId);
            writer.setIndent(this.indent);
            writer.setVersionStrict(this.versionStrict);
            writer.setScribeIndex(this.index);
            try {
                for (VCard vcard : this.vcards) {
                    writer.write(vcard);
                    writer.flush();
                }
            }
            finally {
                writer.closeJsonStream();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WriterChainHtml
    extends WriterChain<WriterChainHtml> {
        private WriterChainHtml(Collection<VCard> vcards) {
            super(vcards);
        }

        public String go() {
            StringWriter sw = new StringWriter();
            try {
                this.go(sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        public void go(OutputStream out) throws IOException {
            this.go(new OutputStreamWriter(out));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void go(File file) throws IOException {
            FileWriter writer = null;
            try {
                writer = new FileWriter(file);
                this.go(writer);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly(writer);
        }

        public void go(Writer writer) throws IOException {
            HCardPage page = new HCardPage();
            for (VCard vcard : this.vcards) {
                page.add(vcard);
            }
            page.write(writer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WriterChainXml
    extends WriterChain<WriterChainXml> {
        boolean prodId = true;
        boolean versionStrict = true;
        int indent = -1;
        final ScribeIndex index = new ScribeIndex();

        private WriterChainXml(Collection<VCard> vcards) {
            super(vcards);
        }

        public WriterChainXml prodId(boolean include) {
            this.prodId = include;
            return (WriterChainXml)this.this_;
        }

        public WriterChainXml indent(int indent) {
            this.indent = indent;
            return (WriterChainXml)this.this_;
        }

        public WriterChainXml versionStrict(boolean versionStrict) {
            this.versionStrict = versionStrict;
            return (WriterChainXml)this.this_;
        }

        public WriterChainXml register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            this.index.register(scribe);
            return (WriterChainXml)this.this_;
        }

        public String go() {
            StringWriter sw = new StringWriter();
            try {
                this.go(sw);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            return sw.toString();
        }

        public void go(OutputStream out) throws TransformerException {
            XCardDocument doc = this.createXCardDocument();
            doc.write(out, this.indent);
        }

        public void go(File file) throws IOException, TransformerException {
            XCardDocument doc = this.createXCardDocument();
            doc.write(file, this.indent);
        }

        public void go(Writer writer) throws TransformerException {
            XCardDocument doc = this.createXCardDocument();
            doc.write(writer, this.indent);
        }

        public Document dom() {
            XCardDocument doc = this.createXCardDocument();
            return doc.getDocument();
        }

        private XCardDocument createXCardDocument() {
            XCardDocument doc = new XCardDocument();
            doc.setAddProdId(this.prodId);
            doc.setVersionStrict(this.versionStrict);
            doc.setScribeIndex(this.index);
            for (VCard vcard : this.vcards) {
                doc.add(vcard);
            }
            return doc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WriterChainText
    extends WriterChain<WriterChainText> {
        VCardVersion version;
        boolean prodId = true;
        boolean versionStrict = true;
        boolean caretEncoding = false;
        final ScribeIndex index = new ScribeIndex();

        private WriterChainText(Collection<VCard> vcards) {
            super(vcards);
        }

        public WriterChainText version(VCardVersion version) {
            this.version = version;
            return (WriterChainText)this.this_;
        }

        public WriterChainText prodId(boolean include) {
            this.prodId = include;
            return (WriterChainText)this.this_;
        }

        public WriterChainText caretEncoding(boolean enable) {
            this.caretEncoding = enable;
            return (WriterChainText)this.this_;
        }

        public WriterChainText versionStrict(boolean versionStrict) {
            this.versionStrict = versionStrict;
            return (WriterChainText)this.this_;
        }

        public WriterChainText register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            this.index.register(scribe);
            return (WriterChainText)this.this_;
        }

        public String go() {
            StringWriter sw = new StringWriter();
            try {
                this.go(sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        public void go(OutputStream out) throws IOException {
            VCardWriter vcardWriter = this.version == null ? new VCardWriter(out) : new VCardWriter(out, this.version);
            this.go(vcardWriter);
        }

        public void go(File file) throws IOException {
            this.go(file, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void go(File file, boolean append) throws IOException {
            VCardWriter vcardWriter = this.version == null ? new VCardWriter(file, append) : new VCardWriter(file, append, this.version);
            try {
                this.go(vcardWriter);
            }
            finally {
                IOUtils.closeQuietly(vcardWriter);
            }
        }

        public void go(Writer writer) throws IOException {
            VCardWriter vcardWriter = new VCardWriter(writer);
            vcardWriter.setTargetVersion(this.version);
            this.go(vcardWriter);
        }

        private void go(VCardWriter vcardWriter) throws IOException {
            vcardWriter.setAddProdId(this.prodId);
            vcardWriter.setCaretEncodingEnabled(this.caretEncoding);
            vcardWriter.setVersionStrict(this.versionStrict);
            vcardWriter.setScribeIndex(this.index);
            for (VCard vcard : this.vcards) {
                if (this.version == null) {
                    VCardVersion vcardVersion = vcard.getVersion();
                    if (vcardVersion == null) {
                        vcardVersion = VCardVersion.V3_0;
                    }
                    vcardWriter.setTargetVersion(vcardVersion);
                }
                vcardWriter.write(vcard);
                vcardWriter.flush();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class WriterChain<T> {
        final Collection<VCard> vcards;
        final T this_ = this;

        WriterChain(Collection<VCard> vcards) {
            this.vcards = vcards;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainJsonString
    extends ParserChainJson<ParserChainJsonString> {
        private final String json;

        private ParserChainJsonString(String json) {
            super(false);
            this.json = json;
        }

        @Override
        public ParserChainJsonString register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainJsonString)super.register(scribe);
        }

        @Override
        public ParserChainJsonString warnings(List<List<String>> warnings) {
            return (ParserChainJsonString)super.warnings(warnings);
        }

        @Override
        JCardReader _constructReader() {
            return new JCardReader(this.json);
        }

        @Override
        public VCard first() {
            try {
                return super.first();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<VCard> all() {
            try {
                return super.all();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainJsonReader
    extends ParserChainJson<ParserChainJsonReader> {
        private final InputStream in;
        private final File file;
        private final Reader reader;

        private ParserChainJsonReader(InputStream in) {
            super(false);
            this.in = in;
            this.reader = null;
            this.file = null;
        }

        private ParserChainJsonReader(File file) {
            super(true);
            this.in = null;
            this.reader = null;
            this.file = file;
        }

        private ParserChainJsonReader(Reader reader) {
            super(false);
            this.in = null;
            this.reader = reader;
            this.file = null;
        }

        @Override
        public ParserChainJsonReader register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainJsonReader)super.register(scribe);
        }

        @Override
        public ParserChainJsonReader warnings(List<List<String>> warnings) {
            return (ParserChainJsonReader)super.warnings(warnings);
        }

        @Override
        JCardReader _constructReader() throws IOException {
            if (this.in != null) {
                return new JCardReader(this.in);
            }
            if (this.file != null) {
                return new JCardReader(this.file);
            }
            return new JCardReader(this.reader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ParserChainJson<T>
    extends ParserChain<T> {
        final boolean closeWhenDone;

        private ParserChainJson(boolean closeWhenDone) {
            this.closeWhenDone = closeWhenDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VCard first() throws IOException {
            JCardReader parser = this.constructReader();
            try {
                VCard vcard = parser.readNext();
                if (this.warnings != null) {
                    this.warnings.add(parser.getWarnings());
                }
                VCard vCard = vcard;
                return vCard;
            }
            finally {
                if (this.closeWhenDone) {
                    IOUtils.closeQuietly(parser);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<VCard> all() throws IOException {
            JCardReader parser = this.constructReader();
            try {
                VCard vcard;
                ArrayList<VCard> vcards = new ArrayList<VCard>();
                while ((vcard = parser.readNext()) != null) {
                    if (this.warnings != null) {
                        this.warnings.add(parser.getWarnings());
                    }
                    vcards.add(vcard);
                }
                ArrayList<VCard> arrayList = vcards;
                return arrayList;
            }
            finally {
                if (this.closeWhenDone) {
                    IOUtils.closeQuietly(parser);
                }
            }
        }

        private JCardReader constructReader() throws IOException {
            JCardReader parser = this._constructReader();
            parser.setScribeIndex(this.index);
            return parser;
        }

        abstract JCardReader _constructReader() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainHtmlString
    extends ParserChainHtml<ParserChainHtmlString> {
        private final String html;

        private ParserChainHtmlString(String html) {
            this.html = html;
        }

        @Override
        public ParserChainHtmlString register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainHtmlString)super.register(scribe);
        }

        @Override
        public ParserChainHtmlString warnings(List<List<String>> warnings) {
            return (ParserChainHtmlString)super.warnings(warnings);
        }

        @Override
        public ParserChainHtmlString pageUrl(String pageUrl) {
            return (ParserChainHtmlString)super.pageUrl(pageUrl);
        }

        @Override
        HCardReader _constructReader() {
            return new HCardReader(this.html, this.pageUrl);
        }

        @Override
        public VCard first() {
            try {
                return super.first();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<VCard> all() {
            try {
                return super.all();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainHtmlReader
    extends ParserChainHtml<ParserChainHtmlReader> {
        private final Reader reader;
        private final File file;
        private final URL url;

        private ParserChainHtmlReader(Reader reader) {
            this.reader = reader;
            this.file = null;
            this.url = null;
        }

        private ParserChainHtmlReader(File file) {
            this.reader = null;
            this.file = file;
            this.url = null;
        }

        private ParserChainHtmlReader(URL url) {
            this.reader = null;
            this.file = null;
            this.url = url;
        }

        @Override
        public ParserChainHtmlReader register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainHtmlReader)super.register(scribe);
        }

        @Override
        public ParserChainHtmlReader warnings(List<List<String>> warnings) {
            return (ParserChainHtmlReader)super.warnings(warnings);
        }

        @Override
        public ParserChainHtmlReader pageUrl(String pageUrl) {
            return (ParserChainHtmlReader)super.pageUrl(pageUrl);
        }

        @Override
        HCardReader _constructReader() throws IOException {
            if (this.reader != null) {
                return new HCardReader(this.reader, this.pageUrl);
            }
            if (this.file != null) {
                return new HCardReader(this.file, this.pageUrl);
            }
            return new HCardReader(this.url);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ParserChainHtml<T>
    extends ParserChain<T> {
        String pageUrl;

        ParserChainHtml() {
        }

        public T pageUrl(String pageUrl) {
            this.pageUrl = pageUrl;
            return (T)this.this_;
        }

        @Override
        public VCard first() throws IOException {
            HCardReader parser = this.constructReader();
            VCard vcard = parser.readNext();
            if (this.warnings != null) {
                this.warnings.add(parser.getWarnings());
            }
            return vcard;
        }

        @Override
        public List<VCard> all() throws IOException {
            VCard vcard;
            HCardReader parser = this.constructReader();
            ArrayList<VCard> vcards = new ArrayList<VCard>();
            while ((vcard = parser.readNext()) != null) {
                if (this.warnings != null) {
                    this.warnings.add(parser.getWarnings());
                }
                vcards.add(vcard);
            }
            return vcards;
        }

        private HCardReader constructReader() throws IOException {
            HCardReader parser = this._constructReader();
            parser.setScribeIndex(this.index);
            return parser;
        }

        abstract HCardReader _constructReader() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainXmlDom
    extends ParserChainXml<ParserChainXmlDom> {
        private final Document document;

        private ParserChainXmlDom(Document document) {
            this.document = document;
        }

        @Override
        public ParserChainXmlDom register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainXmlDom)super.register(scribe);
        }

        @Override
        public ParserChainXmlDom warnings(List<List<String>> warnings) {
            return (ParserChainXmlDom)super.warnings(warnings);
        }

        @Override
        XCardDocument _constructDocument() {
            return new XCardDocument(this.document);
        }

        @Override
        public VCard first() {
            try {
                return super.first();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<VCard> all() {
            try {
                return super.all();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainXmlString
    extends ParserChainXml<ParserChainXmlString> {
        private final String xml;

        private ParserChainXmlString(String xml) {
            this.xml = xml;
        }

        @Override
        public ParserChainXmlString register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainXmlString)super.register(scribe);
        }

        @Override
        public ParserChainXmlString warnings(List<List<String>> warnings) {
            return (ParserChainXmlString)super.warnings(warnings);
        }

        @Override
        XCardDocument _constructDocument() throws SAXException {
            return new XCardDocument(this.xml);
        }

        @Override
        public VCard first() throws SAXException {
            try {
                return super.first();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<VCard> all() throws SAXException {
            try {
                return super.all();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainXmlReader
    extends ParserChainXml<ParserChainXmlReader> {
        private final InputStream in;
        private final File file;
        private final Reader reader;

        private ParserChainXmlReader(InputStream in) {
            this.in = in;
            this.reader = null;
            this.file = null;
        }

        private ParserChainXmlReader(File file) {
            this.in = null;
            this.reader = null;
            this.file = file;
        }

        private ParserChainXmlReader(Reader reader) {
            this.in = null;
            this.reader = reader;
            this.file = null;
        }

        @Override
        public ParserChainXmlReader register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainXmlReader)super.register(scribe);
        }

        @Override
        public ParserChainXmlReader warnings(List<List<String>> warnings) {
            return (ParserChainXmlReader)super.warnings(warnings);
        }

        @Override
        XCardDocument _constructDocument() throws IOException, SAXException {
            if (this.in != null) {
                return new XCardDocument(this.in);
            }
            if (this.file != null) {
                return new XCardDocument(this.file);
            }
            return new XCardDocument(this.reader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ParserChainXml<T>
    extends ParserChain<T> {
        ParserChainXml() {
        }

        @Override
        public VCard first() throws IOException, SAXException {
            XCardDocument document = this.constructDocument();
            VCard vcard = document.parseFirst();
            if (this.warnings != null) {
                this.warnings.addAll(document.getParseWarnings());
            }
            return vcard;
        }

        @Override
        public List<VCard> all() throws IOException, SAXException {
            XCardDocument document = this.constructDocument();
            List<VCard> icals = document.parseAll();
            if (this.warnings != null) {
                this.warnings.addAll(document.getParseWarnings());
            }
            return icals;
        }

        private XCardDocument constructDocument() throws SAXException, IOException {
            XCardDocument parser = this._constructDocument();
            parser.setScribeIndex(this.index);
            return parser;
        }

        abstract XCardDocument _constructDocument() throws IOException, SAXException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainTextString
    extends ParserChainText<ParserChainTextString> {
        private final String text;

        private ParserChainTextString(String text) {
            super(false);
            this.text = text;
        }

        @Override
        public ParserChainTextString register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainTextString)super.register(scribe);
        }

        @Override
        public ParserChainTextString warnings(List<List<String>> warnings) {
            return (ParserChainTextString)super.warnings(warnings);
        }

        @Override
        public ParserChainTextString caretDecoding(boolean enable) {
            return (ParserChainTextString)super.caretDecoding(enable);
        }

        @Override
        VCardReader _constructReader() {
            return new VCardReader(this.text);
        }

        @Override
        public VCard first() {
            try {
                return super.first();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<VCard> all() {
            try {
                return super.all();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainTextReader
    extends ParserChainText<ParserChainTextReader> {
        private final Reader reader;
        private final File file;

        private ParserChainTextReader(Reader reader) {
            super(false);
            this.reader = reader;
            this.file = null;
        }

        private ParserChainTextReader(File file) {
            super(true);
            this.reader = null;
            this.file = file;
        }

        @Override
        public ParserChainTextReader register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            return (ParserChainTextReader)super.register(scribe);
        }

        @Override
        public ParserChainTextReader warnings(List<List<String>> warnings) {
            return (ParserChainTextReader)super.warnings(warnings);
        }

        @Override
        public ParserChainTextReader caretDecoding(boolean enable) {
            return (ParserChainTextReader)super.caretDecoding(enable);
        }

        @Override
        VCardReader _constructReader() throws IOException {
            return this.reader != null ? new VCardReader(this.reader) : new VCardReader(this.file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ParserChainText<T>
    extends ParserChain<T> {
        boolean caretDecoding = true;
        final boolean closeWhenDone;

        private ParserChainText(boolean closeWhenDone) {
            this.closeWhenDone = closeWhenDone;
        }

        public T caretDecoding(boolean enable) {
            this.caretDecoding = enable;
            return (T)this.this_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VCard first() throws IOException {
            VCardReader parser = this.constructReader();
            try {
                VCard vcard = parser.readNext();
                if (this.warnings != null) {
                    this.warnings.add(parser.getWarnings());
                }
                VCard vCard = vcard;
                return vCard;
            }
            finally {
                if (this.closeWhenDone) {
                    IOUtils.closeQuietly(parser);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<VCard> all() throws IOException {
            VCardReader parser = this.constructReader();
            try {
                VCard vcard;
                ArrayList<VCard> vcards = new ArrayList<VCard>();
                while ((vcard = parser.readNext()) != null) {
                    if (this.warnings != null) {
                        this.warnings.add(parser.getWarnings());
                    }
                    vcards.add(vcard);
                }
                ArrayList<VCard> arrayList = vcards;
                return arrayList;
            }
            finally {
                if (this.closeWhenDone) {
                    IOUtils.closeQuietly(parser);
                }
            }
        }

        private VCardReader constructReader() throws IOException {
            VCardReader parser = this._constructReader();
            parser.setScribeIndex(this.index);
            parser.setCaretDecodingEnabled(this.caretDecoding);
            return parser;
        }

        abstract VCardReader _constructReader() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ParserChain<T> {
        final ScribeIndex index = new ScribeIndex();
        List<List<String>> warnings;
        final T this_ = this;

        ParserChain() {
        }

        public T register(VCardPropertyScribe<? extends VCardProperty> scribe) {
            this.index.register(scribe);
            return this.this_;
        }

        public T warnings(List<List<String>> warnings) {
            this.warnings = warnings;
            return this.this_;
        }

        public abstract VCard first() throws IOException, SAXException;

        public abstract List<VCard> all() throws IOException, SAXException;
    }
}

