/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.internal.extension.widgets;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.sf.feeling.swt.win32.internal.extension.widgets.ISkinable;

public class ButtonCanvas
extends Canvas {
    private int type;
    private ISkinable drawable;
    private boolean active;

    public ButtonCanvas(Composite composite, int n) {
        super(composite, 0);
        this.type = n;
        this.setBackgroundMode(1);
        this.createLayoutData(n);
        InternalListener internalListener = new InternalListener();
        this.addListener(27, internalListener);
        this.addListener(6, internalListener);
        this.addListener(7, internalListener);
        this.addListener(3, internalListener);
        this.addListener(4, internalListener);
        this.addListener(11, internalListener);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (ButtonCanvas.this.drawable != null) {
                    ButtonCanvas.this.drawable.paint(paintEvent.gc, 0, 0);
                }
            }
        });
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public int getType() {
        return this.type;
    }

    public ISkinable getDrawable() {
        return this.drawable;
    }

    public void setDrawable(ISkinable iSkinable) {
        GridData gridData = (GridData)this.getLayoutData();
        if (iSkinable != null) {
            gridData.widthHint = iSkinable.getInitWidth();
            gridData.heightHint = iSkinable.getInitHeight();
        } else {
            gridData.widthHint = 0;
            gridData.heightHint = 0;
        }
        this.setLayoutData(gridData);
        this.drawable = iSkinable;
    }

    public void updateSkin(Event event) {
        if (this.drawable != null) {
            Color color = this.drawable.getForeground(event);
            if (color != null && !color.isDisposed()) {
                this.setForeground(color);
            }
            this.drawable.configue(event);
            this.redraw();
        }
    }

    private void createLayoutData(int n) {
        GridData gridData = new GridData(4, 4, false, false);
        this.setLayoutData(gridData);
    }

    private class InternalListener
    implements Listener {
        private InternalListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 3 && event.button != 1) {
                return;
            }
            ButtonCanvas.this.updateSkin(event);
        }
    }
}

