/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.internal.extension.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorCache {
    public static final RGB BLACK = new RGB(0, 0, 0);
    public static final RGB WHITE = new RGB(255, 255, 255);
    private static Map colorTable;
    private static ColorCache instance;

    public static void disposeAll() {
        ColorCache.getInstance().dispose();
        instance = null;
        colorTable = null;
    }

    private ColorCache() {
        if (colorTable == null) {
            colorTable = new HashMap();
        }
    }

    public static ColorCache getInstance() {
        if (instance == null) {
            instance = new ColorCache();
        }
        return instance;
    }

    private void dispose() {
        Iterator iterator = colorTable.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v == null) continue;
            ((Color)v).dispose();
        }
        colorTable.clear();
    }

    public Color getWhite() {
        return this.getColor(new RGB(255, 255, 255));
    }

    public Color getBlack() {
        return this.getColor(new RGB(0, 0, 0));
    }

    public Color getColor(RGB rGB) {
        Color color = (Color)colorTable.get(rGB);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rGB);
            colorTable.put(rGB, color);
        }
        return color;
    }

    public Color getColor(int n, int n2, int n3) {
        RGB rGB = new RGB(n, n2, n3);
        Color color = (Color)colorTable.get(rGB);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rGB);
            colorTable.put(rGB, color);
        }
        return color;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                ColorCache.disposeAll();
            }
        });
    }
}

