/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.swt.win32.extension.graphics.ImageRegion;
import org.sf.feeling.swt.win32.extension.shell.ShellIcon;
import org.sf.feeling.swt.win32.extension.shell.SystemMenuManager;
import org.sf.feeling.swt.win32.extension.shell.Windows;
import org.sf.feeling.swt.win32.extension.shell.listener.WindowMoveListener;
import org.sf.feeling.swt.win32.extension.widgets.MenuBar;
import org.sf.feeling.swt.win32.internal.extension.Extension;
import org.sf.feeling.swt.win32.internal.extension.util.ColorCache;
import org.sf.feeling.swt.win32.internal.extension.widgets.BorderCanvas;
import org.sf.feeling.swt.win32.internal.extension.widgets.ButtonCanvas;
import org.sf.feeling.swt.win32.internal.extension.widgets.ISkinable;
import org.sf.feeling.swt.win32.internal.extension.widgets.IWindow;
import org.sf.feeling.swt.win32.internal.extension.widgets.ImageSkin;
import org.sf.feeling.swt.win32.internal.extension.widgets.MouseResizeListener;
import org.sf.feeling.swt.win32.internal.extension.widgets.SkinableWidget;
import org.sf.feeling.swt.win32.internal.extension.widgets.UIManager;
import org.sf.feeling.swt.win32.internal.extension.widgets.WindowResizeHook;

public class Window
extends SkinableWidget
implements IWindow {
    protected Shell shell;
    private Composite titleArea;
    private Composite buttonArea;
    private Map buttons;
    private ControlAdapter resizeListener;
    private ShellAdapter shellListener;
    private WindowResizeHook resizeHook;
    private SystemMenuManager menuManager;
    private String theme = "office2007";

    Window() {
    }

    public Window(int n) {
        super(null, n);
        this.initWindow(n);
    }

    public Window(Shell shell) {
        super((Composite)shell, 0);
        this.initWindow(32768);
    }

    public Window(Shell shell, int n) {
        super((Composite)shell, n);
        this.initWindow(n);
    }

    public Window(Shell shell, int n, String string) {
        super((Composite)shell, n);
        this.initWindow(n);
        this.theme = string;
    }

    public Shell getShell() {
        return this.shell;
    }

    public Composite getClientArea() {
        return super.getClientArea();
    }

    public ISkinable getButtonSkin(int n) {
        return ((ButtonCanvas)((Object)this.buttons.get(new Integer(n)))).getDrawable();
    }

    public void setButtonSkin(int n, ISkinable iSkinable) {
        ButtonCanvas buttonCanvas = (ButtonCanvas)((Object)this.buttons.get(new Integer(n)));
        buttonCanvas.setDrawable(iSkinable);
        UIManager.transformWindowsButtonLayoutData(buttonCanvas, this.theme);
        this.buttonArea.layout();
        this.getBorder(1).layout();
    }

    public Image getImage() {
        Image image = this.shell.getImage();
        if (image == null) {
            Image[] imageArray = this.shell.getImages();
            if (imageArray != null && imageArray.length > 0) {
                return imageArray[0];
            }
            return null;
        }
        return image;
    }

    public void setImage(Image image) {
        if (image == null) {
            return;
        }
        this.shell.setImage(image);
        if (this.isThemeInstalled()) {
            Label label = (Label)this.titleArea.getData("image");
            GridData gridData = (GridData)label.getLayoutData();
            gridData.widthHint = 16;
            gridData.heightHint = 16;
            label.setLayoutData((Object)gridData);
            label.setBackgroundImage(image);
            this.titleArea.layout();
        }
    }

    public String getText() {
        return this.shell.getText();
    }

    public void setText(String string) {
        this.shell.setText(string);
        if (this.isThemeInstalled()) {
            Composite composite = (Composite)this.titleArea.getData("title");
            composite.redraw();
            composite.update();
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.shell.setBounds(rectangle);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.shell.setBounds(n, n2, n3, n4);
    }

    public Rectangle getBounds() {
        return this.shell.getBounds();
    }

    public void setLocation(Point point) {
        this.shell.setLocation(point);
    }

    public void setLocation(int n, int n2) {
        this.shell.setLocation(n, n2);
    }

    public Point getLocation() {
        return this.shell.getLocation();
    }

    public void setSize(Point point) {
        this.shell.setSize(point);
    }

    public void setSize(int n, int n2) {
        this.shell.setSize(n, n2);
    }

    public Point getSize() {
        return this.shell.getSize();
    }

    public void setEnabled(int n, boolean bl) {
        BorderCanvas borderCanvas = (BorderCanvas)this.getBorder(1);
        ButtonCanvas buttonCanvas = (ButtonCanvas)((Object)this.buttons.get(new Integer(n)));
        Object object = (GridData)buttonCanvas.getLayoutData();
        object.exclude = !bl;
        buttonCanvas.setLayoutData(object);
        buttonCanvas.setVisible(bl);
        switch (n) {
            case 2: {
                object = (ButtonCanvas)((Object)this.buttons.get(new Integer(3)));
                GridData gridData = (GridData)object.getLayoutData();
                gridData.exclude = !bl;
                object.setLayoutData((Object)gridData);
                object.setVisible(bl);
                break;
            }
            case 3: {
                ButtonCanvas buttonCanvas2 = (ButtonCanvas)((Object)this.buttons.get(new Integer(3)));
                GridData gridData = (GridData)buttonCanvas2.getLayoutData();
                gridData.exclude = !bl;
                buttonCanvas2.setLayoutData(gridData);
                buttonCanvas2.setVisible(bl);
            }
        }
        borderCanvas.layout();
    }

    public boolean getEnabled(int n) {
        ButtonCanvas buttonCanvas = (ButtonCanvas)((Object)this.buttons.get(new Integer(n)));
        return buttonCanvas.getVisible();
    }

    public void layout() {
        ISkinable iSkinable;
        if (this.menubar != null && !this.menubar.getControl().isDisposed()) {
            iSkinable = (GridData)this.menubar.getControl().getLayoutData();
            ((GridData)iSkinable).exclude = this.menubar.getMenu() == null || this.menubar.getMenu().getItemCount() == 0;
            this.menubar.getControl().setLayoutData((Object)iSkinable);
            iSkinable = (GridData)this.separator.getLayoutData();
            ((GridData)iSkinable).exclude = this.menubar.getMenu() == null || this.menubar.getMenu().getItemCount() == 0;
            this.separator.setLayoutData(iSkinable);
        }
        if ((iSkinable = ((ButtonCanvas)((Object)this.buttons.get(new Integer(4)))).getDrawable()) != null) {
            ((GridData)this.buttonArea.getLayoutData()).heightHint = iSkinable.getInitHeight() + ((GridData)this.titleArea.getLayoutData()).verticalIndent;
        }
        this.getBorderContainer().layout();
        this.shell.layout();
        this.redrawShell();
    }

    public MenuBar getMenuBar() {
        return this.menubar;
    }

    public void open() {
        if (!UIManager.isInstall(this)) {
            if (this.theme != null) {
                UIManager.installTheme(this.theme, this);
            } else {
                UIManager.installTheme(this);
            }
        }
        Display display = this.shell.getDisplay();
        this.layout();
        this.hookShellUI();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void close() {
        this.shell.close();
    }

    public Display getDisplay() {
        return this.shell.getDisplay();
    }

    public void setCenter() {
        Rectangle rectangle = this.shell.getBounds();
        Rectangle rectangle2 = this.shell.getDisplay().getBounds();
        int n = (rectangle2.width - rectangle.width) / 2;
        int n2 = (rectangle2.height - rectangle.height) / 2;
        this.shell.setLocation(n, n2);
    }

    public void help(Event event) {
    }

    protected Composite createContents(Composite composite, int n) {
        this.shell = composite != null && n != 0 ? (composite instanceof Shell ? new Shell((Shell)composite, this.createShellStyle(n)) : new Shell(composite.getShell(), this.createShellStyle(n))) : (composite != null ? (composite instanceof Shell ? new Shell((Shell)composite) : new Shell(composite.getShell())) : (n != 0 ? new Shell(this.createShellStyle(n)) : new Shell()));
        return this.shell;
    }

    protected void hookShellUI() {
        this.resizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (Window.this.getClientArea() == null || Window.this.getClientArea().isDisposed()) {
                    return;
                }
                if (Window.this.shell.getMaximized()) {
                    Window.this.setShellMax();
                } else if (!Window.this.shell.getMinimized()) {
                    Window.this.restoreShell();
                }
                Window.this.redrawShell();
            }
        };
        this.shell.addControlListener((ControlListener)this.resizeListener);
        this.shellListener = new ShellAdapter(){

            public void shellActivated(ShellEvent shellEvent) {
                if (Window.this.getClientArea() == null || Window.this.getClientArea().isDisposed()) {
                    return;
                }
                Window.this.redrawShell();
            }
        };
        this.shell.addShellListener((ShellListener)this.shellListener);
        Windows.hideTitleBar(this.shell.handle);
        Windows.setBorderThick(this.shell.handle, false);
        Windows.setWindowAsDialogModel(this.shell.handle, false);
        if (this.resizeHook == null) {
            this.resizeHook = new WindowResizeHook(this);
        }
        this.resizeHook.installHook();
        if (this.menuManager == null) {
            this.menuManager = new SystemMenuManager(this.shell);
        }
    }

    protected void unHookShellUI() {
        this.unHookShellUI(true);
    }

    protected void unHookShellUI(boolean bl) {
        this.shell.removeControlListener((ControlListener)this.resizeListener);
        this.shell.removeShellListener((ShellListener)this.shellListener);
        if (UIManager.isInstall(this)) {
            UIManager.unInstallTheme(this);
        }
        if (bl) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (Window.this.shell.isDisposed()) {
                        return;
                    }
                    Windows.setWindowAsDialogModel(Window.this.shell.handle, (Window.this.shell.getStyle() & 0x800) != 0);
                    Windows.showTitleBar(Window.this.shell.handle);
                    Windows.setBorderThick(Window.this.shell.handle, true);
                }
            });
        }
    }

    private int createShellStyle(int n) {
        if (((n |= 0x40000) & 0x20) == 0) {
            n = n | 0x20 | 0x40;
        }
        if ((n & 0x800) != 0) {
            n &= 0xFFFFF7FF;
        }
        return n;
    }

    protected void initWindow(int n) {
        if ((n & 0x20) == 0) {
            return;
        }
        Canvas canvas = this.getBorder(1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        canvas.setLayout((Layout)gridLayout);
        this.titleArea = new Composite((Composite)canvas, 0);
        gridLayout = new GridData(4, 4, true, true);
        gridLayout.verticalIndent = 3;
        this.titleArea.setLayoutData((Object)gridLayout);
        Object object = new GridLayout();
        object.numColumns = 3;
        object.horizontalSpacing = 0;
        object.verticalSpacing = 0;
        object.marginHeight = 0;
        object.marginWidth = 0;
        this.titleArea.setLayout((Layout)object);
        this.createWindowImage(this.titleArea);
        this.createWindowTitle(this.titleArea);
        this.createButtons((Composite)canvas);
        boolean bl = (n & 0x10) != 0;
        object = new MouseResizeListener(1, (BorderCanvas)this.getBorder(1), bl);
        this.getBorder(1).addListener(3, (Listener)object);
        this.getBorder(1).addListener(5, (Listener)object);
        this.getBorder(1).addListener(7, (Listener)object);
        object = new MouseResizeListener(4, (BorderCanvas)this.getBorder(4), bl);
        this.getBorder(4).addListener(3, (Listener)object);
        this.getBorder(4).addListener(5, (Listener)object);
        this.getBorder(4).addListener(7, (Listener)object);
        object = new MouseResizeListener(6, (BorderCanvas)this.getBorder(6), bl);
        this.getBorder(6).addListener(3, (Listener)object);
        this.getBorder(6).addListener(5, (Listener)object);
        this.getBorder(6).addListener(7, (Listener)object);
        object = new MouseResizeListener(3, (BorderCanvas)this.getBorder(3), bl);
        this.getBorder(3).addListener(3, (Listener)object);
        this.getBorder(3).addListener(5, (Listener)object);
        this.getBorder(3).addListener(7, (Listener)object);
        object = new MouseResizeListener(2, (BorderCanvas)this.getBorder(2), bl);
        this.getBorder(2).addListener(3, (Listener)object);
        this.getBorder(2).addListener(5, (Listener)object);
        this.getBorder(2).addListener(7, (Listener)object);
        object = new MouseResizeListener(0, (BorderCanvas)this.getBorder(0), bl);
        this.getBorder(0).addListener(3, (Listener)object);
        this.getBorder(0).addListener(5, (Listener)object);
        this.getBorder(0).addListener(7, (Listener)object);
        object = new MouseResizeListener(7, (BorderCanvas)this.getBorder(7), bl);
        this.getBorder(7).addListener(3, (Listener)object);
        this.getBorder(7).addListener(5, (Listener)object);
        this.getBorder(7).addListener(7, (Listener)object);
        object = new MouseResizeListener(5, (BorderCanvas)this.getBorder(5), bl);
        this.getBorder(5).addListener(3, (Listener)object);
        this.getBorder(5).addListener(5, (Listener)object);
        this.getBorder(5).addListener(7, (Listener)object);
        object = new WindowMoveListener(this.shell, true);
        this.titleArea.addListener(3, (Listener)object);
        this.titleArea.addListener(5, (Listener)object);
        this.titleArea.addListener(4, (Listener)object);
        Composite composite = (Composite)this.titleArea.getData("title");
        composite.addListener(3, (Listener)object);
        composite.addListener(5, (Listener)object);
        composite.addListener(4, (Listener)object);
        this.setEnabled(0, false);
        if ((n & 0x400) != 0) {
            this.setEnabled(2, true);
        } else {
            this.setEnabled(2, false);
        }
        if ((n & 0x80) != 0) {
            this.setEnabled(1, true);
        } else {
            this.setEnabled(1, false);
        }
        if ((n & 0x40) != 0) {
            this.setEnabled(4, true);
        } else {
            this.setEnabled(4, false);
        }
        this.buttonArea.layout();
        this.checkButtonStatus();
    }

    private void createButtons(Composite composite) {
        this.buttonArea = new Composite(composite, 0);
        this.buttonArea.setLayoutData((Object)new GridData(4, 1, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.buttonArea.setLayout((Layout)gridLayout);
        this.buttons = new HashMap(5);
        int n = 0;
        for (n = 0; n < 5; ++n) {
            final ButtonCanvas buttonCanvas = new ButtonCanvas(this.buttonArea, n);
            buttonCanvas.setLayoutData(new GridData(4, 4, false, false));
            switch (n) {
                case 2: {
                    buttonCanvas.addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            if (event.button != 1) {
                                return;
                            }
                            Rectangle rectangle = new Rectangle(0, 0, buttonCanvas.getBounds().width, buttonCanvas.getBounds().height);
                            if (!rectangle.contains(event.x, event.y)) {
                                return;
                            }
                            Window.this.shell.setMaximized(true);
                        }
                    });
                    break;
                }
                case 3: {
                    buttonCanvas.addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            if (event.button != 1) {
                                return;
                            }
                            Rectangle rectangle = new Rectangle(0, 0, buttonCanvas.getBounds().width, buttonCanvas.getBounds().height);
                            if (!rectangle.contains(event.x, event.y)) {
                                return;
                            }
                            Window.this.shell.setMaximized(false);
                        }
                    });
                    break;
                }
                case 1: {
                    buttonCanvas.addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            if (event.button != 1) {
                                return;
                            }
                            Rectangle rectangle = new Rectangle(0, 0, buttonCanvas.getBounds().width, buttonCanvas.getBounds().height);
                            if (!rectangle.contains(event.x, event.y)) {
                                return;
                            }
                            Window.this.shell.setMinimized(true);
                        }
                    });
                    break;
                }
                case 4: {
                    buttonCanvas.addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            if (event.button != 1) {
                                return;
                            }
                            Rectangle rectangle = new Rectangle(0, 0, buttonCanvas.getBounds().width, buttonCanvas.getBounds().height);
                            if (!rectangle.contains(event.x, event.y)) {
                                return;
                            }
                            Window.this.shell.close();
                        }
                    });
                    break;
                }
                case 0: {
                    buttonCanvas.addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            if (event.button != 1) {
                                return;
                            }
                            Rectangle rectangle = new Rectangle(0, 0, buttonCanvas.getBounds().width, buttonCanvas.getBounds().height);
                            if (!rectangle.contains(event.x, event.y)) {
                                return;
                            }
                            Window.this.help(event);
                        }
                    });
                }
            }
            this.buttons.put(new Integer(n), buttonCanvas);
        }
    }

    protected Composite getBorderContainer() {
        return this.shell;
    }

    protected void hiddenBorders(boolean bl) {
        Composite composite = this.getBorderContainer();
        if (composite == null) {
            return;
        }
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        if (gridLayout == null) {
            return;
        }
        gridLayout.numColumns = bl ? 1 : 3;
        this.hiddenControl((Control)this.getBorder(0), bl);
        this.hiddenControl((Control)this.getBorder(2), bl);
        this.hiddenControl((Control)this.getBorder(3), bl);
        this.hiddenControl((Control)this.getBorder(4), bl);
        this.hiddenControl((Control)this.getBorder(5), bl);
        this.hiddenControl((Control)this.getBorder(6), bl);
        this.hiddenControl((Control)this.getBorder(7), bl);
        this.hiddenControl((Control)this.getBorder(6).getParent(), bl);
        composite.layout();
    }

    private void hiddenControl(Control control, boolean bl) {
        GridData gridData = (GridData)control.getLayoutData();
        gridData.exclude = bl;
        control.setLayoutData((Object)gridData);
        control.setVisible(!bl);
    }

    private void createWindowImage(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
        gridData.horizontalIndent = 1;
        gridData.widthHint = 16;
        gridData.heightHint = 16;
        label.setLayoutData((Object)gridData);
        label.setAlignment(0x1000000);
        Image image = null;
        try {
            Image image2;
            Class<?> clazz = Class.forName("org.eclipse.swt.widgets.Decorations");
            Field field = clazz.getDeclaredField("smallImage");
            field.setAccessible(true);
            image = (Image)field.get(this.shell);
            if (image == null && this.shell.getImages() != null && this.shell.getImages().length > 0) {
                image = this.shell.getImages()[0];
            }
            if (image == null && this.shell.getImage() != null) {
                image = this.shell.getImage();
            }
            if (image == null && (image2 = ShellIcon.getSystemIcons(2, 65536)) != null && ((Image[])image2).length > 0) {
                image = image2[0];
                this.shell.setImage(image);
            }
            if (image != null) {
                if (image.getImageData().width != 16) {
                    image2 = new Image(null, image.getImageData().scaledTo(16, 16));
                    label.setImage(image2);
                } else {
                    label.setImage(image);
                }
            }
        }
        catch (Exception exception) {
            SWT.error((int)1, (Throwable)exception);
        }
        label.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (!Window.this.menuManager.isMenuVisiable()) {
                    Window.this.menuManager.showMenu(Window.this.getClientArea().getParent().toDisplay(new Point(0, 0)));
                }
            }
        });
        label.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                Window.this.shell.close();
            }
        });
        composite.setData("image", (Object)label);
    }

    private void createWindowTitle(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 5;
        composite2.setLayoutData((Object)gridData);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        FontData fontData = event.gc.getFont().getFontData()[0];
                        fontData.setStyle(UIManager.getTitleBarFontStyle(Window.this.theme));
                        Font font = new Font((Device)Window.this.getDisplay(), fontData);
                        event.gc.setFont(font);
                        int n = event.gc.getFontMetrics().getHeight();
                        int n2 = ((Window)Window.this).titleArea.getBounds().height;
                        Color color = Window.this.getBorder(1).getForeground();
                        if (UIManager.isTitleUsedShadow(Window.this.theme)) {
                            RGB rGB = color.getRGB();
                            RGB rGB2 = new RGB(255 - rGB.red, 255 - rGB.green, 255 - rGB.blue);
                            Color color2 = ColorCache.getInstance().getColor(rGB2);
                            event.gc.setForeground(color2);
                            event.gc.drawText(Window.this.shell.getText(), 1, (n2 - n) / 2 + 1, true);
                        }
                        event.gc.setForeground(color);
                        event.gc.drawText(Window.this.shell.getText(), 0, (n2 - n) / 2, true);
                        font.dispose();
                        break;
                    }
                    case 8: {
                        if (!Window.this.getEnabled(2) && !Window.this.getEnabled(3)) break;
                        if (Window.this.shell.getMaximized()) {
                            Window.this.shell.setMaximized(false);
                            break;
                        }
                        Window.this.shell.setMaximized(true);
                    }
                }
            }
        };
        composite2.addListener(9, listener);
        composite2.addListener(8, listener);
        composite2.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Window.this.menuManager.showMenu();
            }
        });
        composite.setData("title", (Object)composite2);
    }

    public void redrawShell() {
        if (!UIManager.isInstall(this)) {
            Extension.SetWindowRgn((int)this.shell.handle, (int)0, (boolean)true);
            return;
        }
        Region region = new Region();
        Rectangle rectangle = this.shell.getClientArea();
        region.add(rectangle);
        if (!this.shell.getMaximized()) {
            ImageData imageData = ((ImageSkin)this.getSkin(0)).getImage().getImageData();
            Region region2 = ImageRegion.calculateOpaquePath(imageData, imageData.transparentPixel);
            region.subtract(region2);
            region2.dispose();
            imageData = ((ImageSkin)this.getSkin(2)).getImage().getImageData();
            region2 = ImageRegion.calculateOpaquePath(imageData, imageData.transparentPixel, rectangle.width - imageData.width, 0);
            region.subtract(region2);
            region2.dispose();
            imageData = ((ImageSkin)this.getSkin(5)).getImage().getImageData();
            region2 = ImageRegion.calculateOpaquePath(imageData, imageData.transparentPixel, 0, rectangle.height - imageData.height);
            region.subtract(region2);
            region2.dispose();
            imageData = ((ImageSkin)this.getSkin(7)).getImage().getImageData();
            region2 = ImageRegion.calculateOpaquePath(imageData, imageData.transparentPixel, rectangle.width - imageData.width, rectangle.height - imageData.height);
            region.subtract(region2);
            region2.dispose();
        }
        int n = 0;
        n = Extension.CreateRectRgn((int)0, (int)0, (int)0, (int)0);
        Extension.CombineRgn((int)n, (int)region.handle, (int)n, (int)2);
        Extension.SetWindowRgn((int)this.shell.handle, (int)n, (boolean)true);
        Extension.DeleteObject((int)n);
        region.dispose();
    }

    protected void setShellMax() {
        this.hiddenBorders(true);
        this.checkButtonStatus(true);
    }

    protected void restoreShell() {
        this.hiddenBorders(false);
        this.checkButtonStatus(false);
    }

    private void checkButtonStatus(boolean bl) {
        if (this.getClientArea() == null || this.getClientArea().isDisposed()) {
            return;
        }
        if (!this.getEnabled(2) && !this.getEnabled(3)) {
            return;
        }
        ButtonCanvas buttonCanvas = (ButtonCanvas)((Object)this.buttons.get(new Integer(2)));
        this.hiddenControl((Control)buttonCanvas, bl);
        ButtonCanvas buttonCanvas2 = (ButtonCanvas)((Object)this.buttons.get(new Integer(3)));
        this.hiddenControl((Control)buttonCanvas2, !bl);
        this.buttonArea.layout();
        this.getBorder(1).layout();
    }

    private void checkButtonStatus() {
        if (this.getClientArea() == null || this.getClientArea().isDisposed()) {
            return;
        }
        if (!this.getEnabled(2) && !this.getEnabled(3)) {
            return;
        }
        boolean bl = this.shell.getMaximized();
        this.checkButtonStatus(bl);
    }

    public boolean isThemeInstalled() {
        return UIManager.isInstall(this);
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String string) {
        this.theme = string;
    }
}

