/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.swt.win32.extension.widgets;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.swt.win32.extension.Win32;
import org.sf.feeling.swt.win32.extension.shell.Windows;
import org.sf.feeling.swt.win32.extension.widgets.CToolBar;
import org.sf.feeling.swt.win32.extension.widgets.CToolItem;
import org.sf.feeling.swt.win32.extension.widgets.MenuControl;
import org.sf.feeling.swt.win32.extension.widgets.MenuHolder;
import org.sf.feeling.swt.win32.extension.widgets.theme.BlackGlossyThemeRender;
import org.sf.feeling.swt.win32.extension.widgets.theme.ThemeRender;

class ToolMenuControl
extends MenuControl {
    private int toolStyle;
    private CToolItem[] items;
    private Point topRight;
    CToolBar toolbar;

    protected ToolMenuControl(MenuHolder menuHolder, ThemeRender themeRender, int n) {
        super(menuHolder, themeRender);
        this.toolStyle = n;
    }

    void setToolItems(CToolItem[] cToolItemArray) {
        this.items = cToolItemArray;
    }

    void setTopRightLocation(Point point) {
        this.topRight = point;
    }

    protected void createAndShowWindow() {
        if (this.shell == null || this.shell.isDisposed()) {
            int n = 540684;
            if (Win32.getWin32Version() < Win32.VERSION(5, 0)) {
                n = 540672;
            }
            this.shell = new Shell(this.holder.getShell(), n);
            if (Win32.getWin32Version() < Win32.VERSION(5, 0)) {
                Windows.hideTitleBar(this.shell.handle);
            }
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 1;
            gridLayout.marginWidth = 1;
            this.shell.setLayout((Layout)gridLayout);
            this.shell.setBackground(this.theme.getTool_menu_control_border());
            this.toolbar = new CToolBar((Composite)this.shell, this.toolStyle | 2, this.theme){

                protected boolean checkEnableHandleEvent() {
                    return true;
                }

                public void hideMenu() {
                    ToolMenuControl.this.holder.hideMenu();
                }
            };
            GridData gridData = new GridData(1040);
            gridData.widthHint = 150;
            this.toolbar.getControl().setLayoutData((Object)gridData);
            this.toolbar.addItems(this.items);
            this.shell.layout();
            Display.getDefault().addFilter(3, new Listener(){

                public void handleEvent(Event event) {
                    if (ToolMenuControl.this.shell == null || ToolMenuControl.this.shell.isDisposed()) {
                        Display.getDefault().removeFilter(3, (Listener)this);
                        return;
                    }
                    if (((Control)event.widget).isDisposed() || ToolMenuControl.this.holder.checkMouseDownEvent(((Control)event.widget).toDisplay(event.x, event.y))) {
                        ToolMenuControl.this.holder.hideMenu();
                    }
                }
            });
            this.toolbar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (selectionEvent.data instanceof CToolItem) {
                        ToolMenuControl.this.holder.hideMenu();
                    }
                }
            });
            this.toolbar.recalculate();
            this.toolbar.setFocusControl(true);
            this.toolbar.getControl().getParent().layout();
            this.shell.setSize(this.toolbar.getControl().getBounds().width + 2, this.toolbar.recalculate().height + 2);
            if (this.topRight != null) {
                int n2 = 1;
                if (this.theme instanceof BlackGlossyThemeRender) {
                    n2 = 0;
                }
                if (this.topRight.y + this.shell.getSize().y <= Display.getDefault().getClientArea().y + Display.getDefault().getClientArea().height) {
                    this.shell.setLocation(new Point(this.topRight.x - this.shell.getSize().x, this.topRight.y - n2));
                } else {
                    this.shell.setLocation(new Point(this.topRight.x - this.shell.getSize().x, this.topRight.y - this.holder.getControl().getSize().y - this.shell.getSize().y + n2));
                }
            }
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (!ToolMenuControl.this.shell.isDisposed()) {
                        if (Win32.getWin32Version() >= Win32.VERSION(5, 0)) {
                            Windows.showWindowBlend(ToolMenuControl.this.shell.handle, 200);
                        } else {
                            ToolMenuControl.this.shell.setVisible(true);
                        }
                        ToolMenuControl.this.toolbar.refresh();
                    }
                }
            });
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    if (ToolMenuControl.this.shell == null || ToolMenuControl.this.shell.isDisposed()) {
                        Display.getDefault().removeFilter(1, (Listener)this);
                        event.doit = false;
                        return;
                    }
                    Event event2 = new Event();
                    event2.time = event.time;
                    event2.doit = event.doit;
                    event2.character = event.character;
                    event2.keyCode = event.keyCode;
                    if (event2.keyCode == 0x1000004 || event2.keyCode == 0x1000002) {
                        event2.detail = 64;
                        ToolMenuControl.this.toolbar.getControl().notifyListeners(31, event2);
                    }
                    if (event2.keyCode == 0x1000003 || event2.keyCode == 0x1000001) {
                        event2.detail = 32;
                        ToolMenuControl.this.toolbar.getControl().notifyListeners(31, event2);
                    }
                    if (event2.character == '\r') {
                        event2.detail = 4;
                        ToolMenuControl.this.toolbar.getControl().notifyListeners(31, event2);
                    }
                    if (event2.character == '\u001b') {
                        event2.detail = 2;
                        ToolMenuControl.this.toolbar.getControl().notifyListeners(31, event2);
                    }
                }
            };
            Display.getDefault().addFilter(1, listener);
        }
    }
}

